/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class PartitionExpressionForMetastore
implements PartitionExpressionProxy {
    private static final Log LOG = LogFactory.getLog(PartitionExpressionForMetastore.class);

    public String convertExprToFilter(byte[] exprBytes) throws MetaException {
        return this.deserializeExpr(exprBytes).getExprString();
    }

    public boolean filterPartitionsByExpr(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, byte[] exprBytes, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        ExprNodeGenericFuncDesc expr = this.deserializeExpr(exprBytes);
        try {
            long startTime = System.nanoTime();
            long len = partitionNames.size();
            boolean result = PartitionPruner.prunePartitionNames(partColumnNames, partColumnTypeInfos, expr, defaultPartitionName, partitionNames);
            double timeMs = (double)(System.nanoTime() - startTime) / 1000000.0;
            LOG.debug((Object)("Pruning " + len + " partition names took " + timeMs + "ms"));
            return result;
        }
        catch (HiveException ex) {
            LOG.error((Object)"Failed to apply the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
    }

    private ExprNodeGenericFuncDesc deserializeExpr(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc expr = null;
        try {
            expr = Utilities.deserializeExpressionFromKryo(exprBytes);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to deserialize the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
        if (expr == null) {
            throw new MetaException("Failed to deserialize expression - ExprNodeDesc not present");
        }
        return expr;
    }
}

