/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;

public class YarnFairScheduling {
    public static boolean usingNonImpersonationModeWithFairScheduling(HiveConf conf) {
        return conf != null && !conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS) && conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_MAP_FAIR_SCHEDULER_QUEUE);
    }

    public static void setDefaultJobQueue(HiveConf conf, String forUser) throws IOException, HiveException {
        Preconditions.checkState(YarnFairScheduling.usingNonImpersonationModeWithFairScheduling(conf), "Unable to map job to fair-scheduler because either impersonation is on or fair-scheduling is disabled.");
        ShimLoader.getSchedulerShims().refreshDefaultQueue(conf, forUser);
    }

    public static void validateYarnQueue(HiveConf conf, String forUser) throws IOException, HiveException {
        Preconditions.checkState(YarnFairScheduling.usingNonImpersonationModeWithFairScheduling(conf), "Unable to map job to fair-scheduler because either impersonation is on or fair-scheduling is disabled.");
        ShimLoader.getSchedulerShims().validateQueueConfiguration(conf, forUser);
    }
}

