/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.mapred.JobConf;

public class AvroSerdeUtils {
    private static final Log LOG = LogFactory.getLog(AvroSerdeUtils.class);
    @Deprecated
    public static final String SCHEMA_LITERAL = "avro.schema.literal";
    @Deprecated
    public static final String SCHEMA_URL = "avro.schema.url";
    @Deprecated
    public static final String SCHEMA_NAMESPACE = "avro.schema.namespace";
    @Deprecated
    public static final String SCHEMA_NAME = "avro.schema.name";
    @Deprecated
    public static final String SCHEMA_DOC = "avro.schema.doc";
    @Deprecated
    public static final String AVRO_SERDE_SCHEMA = AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName();
    @Deprecated
    public static final String SCHEMA_RETRIEVER = AvroTableProperties.SCHEMA_RETRIEVER.getPropName();
    public static final String SCHEMA_NONE = "none";
    public static final String EXCEPTION_MESSAGE = "Neither " + AvroTableProperties.SCHEMA_LITERAL.getPropName() + " nor " + AvroTableProperties.SCHEMA_URL.getPropName() + " specified, can't determine table schema";

    public static Schema determineSchemaOrThrowException(Configuration conf, Properties properties) throws IOException, AvroSerdeException {
        String schemaString = properties.getProperty(AvroTableProperties.SCHEMA_LITERAL.getPropName());
        if (schemaString != null && !schemaString.equals(SCHEMA_NONE)) {
            return AvroSerdeUtils.getSchemaFor(schemaString);
        }
        schemaString = properties.getProperty(AvroTableProperties.SCHEMA_URL.getPropName());
        if (schemaString == null || schemaString.equals(SCHEMA_NONE)) {
            throw new AvroSerdeException(EXCEPTION_MESSAGE);
        }
        try {
            Schema s = AvroSerdeUtils.getSchemaFromFS(schemaString, conf);
            if (s == null) {
                return AvroSerdeUtils.getSchemaFor(new URL(schemaString).openStream());
            }
            return s;
        }
        catch (IOException ioe) {
            throw new AvroSerdeException("Unable to read schema from given path: " + schemaString, ioe);
        }
        catch (URISyntaxException urie) {
            throw new AvroSerdeException("Unable to read schema from given path: " + schemaString, urie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema getSchemaFromFS(String schemaFSUrl, Configuration conf) throws IOException, URISyntaxException {
        FSDataInputStream in = null;
        FileSystem fs = null;
        try {
            fs = FileSystem.get((URI)new URI(schemaFSUrl), (Configuration)conf);
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                String msg = "Failed to open file system for uri " + schemaFSUrl + " assuming it is not a FileSystem url";
                LOG.debug((Object)msg, (Throwable)ioe);
            }
            return null;
        }
        try {
            Schema s;
            in = fs.open(new Path(schemaFSUrl));
            Schema schema = s = AvroSerdeUtils.getSchemaFor((InputStream)in);
            return schema;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean isNullableType(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (schema.getTypes().get(0).getType().equals((Object)Schema.Type.NULL) || schema.getTypes().get(1).getType().equals((Object)Schema.Type.NULL));
    }

    public static Schema getOtherTypeFromNullableType(Schema schema) {
        List<Schema> types = schema.getTypes();
        return types.get(0).getType().equals((Object)Schema.Type.NULL) ? types.get(1) : types.get(0);
    }

    public static boolean insideMRJob(JobConf job) {
        return job != null && HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN) != null && !HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN).isEmpty();
    }

    public static Buffer getBufferFromBytes(byte[] input) {
        ByteBuffer bb = ByteBuffer.wrap(input);
        return bb.rewind();
    }

    public static Buffer getBufferFromDecimal(HiveDecimal dec, int scale) {
        if (dec == null) {
            return null;
        }
        dec = dec.setScale(scale);
        return AvroSerdeUtils.getBufferFromBytes(dec.unscaledValue().toByteArray());
    }

    public static byte[] getBytesFromByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    public static HiveDecimal getHiveDecimalFromByteBuffer(ByteBuffer byteBuffer, int scale) {
        byte[] result = AvroSerdeUtils.getBytesFromByteBuffer(byteBuffer);
        HiveDecimal dec = HiveDecimal.create(new BigInteger(result), scale);
        return dec;
    }

    public static Schema getSchemaFor(String str) {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(str);
        return schema;
    }

    public static Schema getSchemaFor(File file) {
        Schema schema;
        Schema.Parser parser = new Schema.Parser();
        try {
            schema = parser.parse(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Avro schema from " + file.getName(), e);
        }
        return schema;
    }

    public static Schema getSchemaFor(InputStream stream) {
        Schema schema;
        Schema.Parser parser = new Schema.Parser();
        try {
            schema = parser.parse(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Avro schema", e);
        }
        return schema;
    }

    public static enum AvroTableProperties {
        SCHEMA_LITERAL("avro.schema.literal"),
        SCHEMA_URL("avro.schema.url"),
        SCHEMA_NAMESPACE("avro.schema.namespace"),
        SCHEMA_NAME("avro.schema.name"),
        SCHEMA_DOC("avro.schema.doc"),
        AVRO_SERDE_SCHEMA("avro.serde.schema"),
        SCHEMA_RETRIEVER("avro.schema.retriever");

        private final String propName;

        private AvroTableProperties(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }
}

