/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenSecretManager;
import org.apache.hadoop.hive.thrift.DelegationTokenStore;
import org.apache.hadoop.hive.thrift.MemoryTokenStore;
import org.apache.hadoop.hive.thrift.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge {
    private static final Log LOG = LogFactory.getLog(HadoopThriftAuthBridge.class);

    public Client createClient() {
        return new Client();
    }

    public Client createClientWithConf(String authMethod) {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current login user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug((Object)("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current."));
            return new Client();
        }
        LOG.debug((Object)("Setting UGI conf as passed-in authMethod of " + authMethod + " != current."));
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        return new Server(keytabFile, principalConf);
    }

    public String getServerPrincipal(String principalConfig, String host) throws IOException {
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
        String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
        }
        return serverPrincipal;
    }

    public UserGroupInformation getCurrentUGIWithConf(String authMethod) throws IOException {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug((Object)("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current."));
            return ugi;
        }
        LOG.debug((Object)("Setting UGI conf as passed-in authMethod of " + authMethod + " != current."));
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return UserGroupInformation.getCurrentUser();
    }

    private boolean loginUserHasCurrentAuthMethod(UserGroupInformation ugi, String sAuthMethod) {
        UserGroupInformation.AuthenticationMethod authMethod;
        try {
            authMethod = Enum.valueOf(UserGroupInformation.AuthenticationMethod.class, sAuthMethod.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + sAuthMethod, iae);
        }
        LOG.debug((Object)("Current authMethod = " + ugi.getAuthenticationMethod()));
        return ugi.getAuthenticationMethod().equals((Object)authMethod);
    }

    public Map<String, String> getHadoopSaslProperties(Configuration conf) {
        SaslRpcServer.init((Configuration)conf);
        return SaslRpcServer.SASL_PROPS;
    }

    public static class Server {
        public static final String DELEGATION_TOKEN_GC_INTERVAL = "hive.cluster.delegation.token.gc-interval";
        private static final long DELEGATION_TOKEN_GC_INTERVAL_DEFAULT = 3600000L;
        public static final String DELEGATION_KEY_UPDATE_INTERVAL_KEY = "hive.cluster.delegation.key.update-interval";
        public static final long DELEGATION_KEY_UPDATE_INTERVAL_DEFAULT = 86400000L;
        public static final String DELEGATION_TOKEN_RENEW_INTERVAL_KEY = "hive.cluster.delegation.token.renew-interval";
        public static final long DELEGATION_TOKEN_RENEW_INTERVAL_DEFAULT = 86400000L;
        public static final String DELEGATION_TOKEN_MAX_LIFETIME_KEY = "hive.cluster.delegation.token.max-lifetime";
        public static final long DELEGATION_TOKEN_MAX_LIFETIME_DEFAULT = 604800000L;
        public static final String DELEGATION_TOKEN_STORE_CLS = "hive.cluster.delegation.token.store.class";
        public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_STR = "hive.cluster.delegation.token.store.zookeeper.connectString";
        public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_STR_ALTERNATE = "hive.zookeeper.quorum";
        public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_TIMEOUTMILLIS = "hive.cluster.delegation.token.store.zookeeper.connectTimeoutMillis";
        public static final String DELEGATION_TOKEN_STORE_ZK_ZNODE = "hive.cluster.delegation.token.store.zookeeper.znode";
        public static final String DELEGATION_TOKEN_STORE_ZK_ACL = "hive.cluster.delegation.token.store.zookeeper.acl";
        public static final String DELEGATION_TOKEN_STORE_ZK_ZNODE_DEFAULT = "/hivedelegation";
        protected final UserGroupInformation realUgi;
        protected DelegationTokenSecretManager secretManager;
        static final ThreadLocal<InetAddress> remoteAddress = new ThreadLocal<InetAddress>(){

            @Override
            protected synchronized InetAddress initialValue() {
                return null;
            }
        };
        static final ThreadLocal<UserGroupInformation.AuthenticationMethod> authenticationMethod = new ThreadLocal<UserGroupInformation.AuthenticationMethod>(){

            @Override
            protected synchronized UserGroupInformation.AuthenticationMethod initialValue() {
                return UserGroupInformation.AuthenticationMethod.TOKEN;
            }
        };
        private static ThreadLocal<String> remoteUser = new ThreadLocal<String>(){

            @Override
            protected synchronized String initialValue() {
                return null;
            }
        };

        public Server() throws TTransportException {
            try {
                this.realUgi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ioe) {
                throw new TTransportException(ioe);
            }
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            if (keytabFile == null || keytabFile.isEmpty()) {
                throw new TTransportException("No keytab specified");
            }
            if (principalConf == null || principalConf.isEmpty()) {
                throw new TTransportException("No principal specified");
            }
            try {
                String kerberosName = SecurityUtil.getServerPrincipal((String)principalConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.realUgi = UserGroupInformation.getLoginUser();
                assert (this.realUgi.isFromKeytab());
            }
            catch (IOException ioe) {
                throw new TTransportException(ioe);
            }
        }

        public TTransportFactory createTransportFactory(Map<String, String> saslProps) throws TTransportException {
            TSaslServerTransport.Factory transFactory = this.createSaslServerTransportFactory(saslProps);
            return new TUGIAssumingTransportFactory(transFactory, this.realUgi);
        }

        public TSaslServerTransport.Factory createSaslServerTransportFactory(Map<String, String> saslProps) throws TTransportException {
            String kerberosName = this.realUgi.getUserName();
            String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
            if (names.length != 3) {
                throw new TTransportException("Kerberos principal should have 3 parts: " + kerberosName);
            }
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], saslProps, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler());
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, new SaslDigestCallbackHandler(this.secretManager));
            return transFactory;
        }

        public TTransportFactory wrapTransportFactory(TTransportFactory transFactory) {
            return new TUGIAssumingTransportFactory(transFactory, this.realUgi);
        }

        public TProcessor wrapProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, true);
        }

        public TProcessor wrapNonAssumingProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, false);
        }

        protected DelegationTokenStore getTokenStore(Configuration conf) throws IOException {
            String tokenStoreClassName = conf.get(DELEGATION_TOKEN_STORE_CLS, "");
            if (StringUtils.isBlank(tokenStoreClassName)) {
                return new MemoryTokenStore();
            }
            try {
                Class<DelegationTokenStore> storeClass = Class.forName(tokenStoreClassName).asSubclass(DelegationTokenStore.class);
                return (DelegationTokenStore)ReflectionUtils.newInstance(storeClass, (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error initializing delegation token store: " + tokenStoreClassName, e);
            }
        }

        public void startDelegationTokenSecretManager(Configuration conf, Object hms, ServerMode smode) throws IOException {
            long secretKeyInterval = conf.getLong(DELEGATION_KEY_UPDATE_INTERVAL_KEY, 86400000L);
            long tokenMaxLifetime = conf.getLong(DELEGATION_TOKEN_MAX_LIFETIME_KEY, 604800000L);
            long tokenRenewInterval = conf.getLong(DELEGATION_TOKEN_RENEW_INTERVAL_KEY, 86400000L);
            long tokenGcInterval = conf.getLong(DELEGATION_TOKEN_GC_INTERVAL, 3600000L);
            DelegationTokenStore dts = this.getTokenStore(conf);
            dts.init(hms, smode);
            this.secretManager = new TokenStoreDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenGcInterval, dts);
            this.secretManager.startThreads();
        }

        public String getDelegationToken(String owner, final String renewer) throws IOException, InterruptedException {
            if (!authenticationMethod.get().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                throw new AuthorizationException("Delegation Token can be issued only with kerberos authentication. Current AuthenticationMethod: " + authenticationMethod.get());
            }
            UserGroupInformation currUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation ownerUgi = UserGroupInformation.createRemoteUser((String)owner);
            if (!ownerUgi.getShortUserName().equals(currUser.getShortUserName())) {
                ownerUgi = UserGroupInformation.createProxyUser((String)owner, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                InetAddress remoteAddr = this.getRemoteAddress();
                ProxyUsers.authorize((UserGroupInformation)ownerUgi, (String)remoteAddr.getHostAddress(), null);
            }
            return (String)ownerUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return Server.this.secretManager.getDelegationToken(renewer);
                }
            });
        }

        public String getDelegationTokenWithService(String owner, String renewer, String service) throws IOException, InterruptedException {
            String token = this.getDelegationToken(owner, renewer);
            return Utils.addServiceToToken(token, service);
        }

        public long renewDelegationToken(String tokenStrForm) throws IOException {
            if (!authenticationMethod.get().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                throw new AuthorizationException("Delegation Token can be issued only with kerberos authentication. Current AuthenticationMethod: " + authenticationMethod.get());
            }
            return this.secretManager.renewDelegationToken(tokenStrForm);
        }

        public String getUserFromToken(String tokenStr) throws IOException {
            return this.secretManager.getUserFromToken(tokenStr);
        }

        public void cancelDelegationToken(String tokenStrForm) throws IOException {
            this.secretManager.cancelDelegationToken(tokenStrForm);
        }

        public InetAddress getRemoteAddress() {
            return remoteAddress.get();
        }

        public String getRemoteUser() {
            return remoteUser.get();
        }

        static class TUGIAssumingTransportFactory
        extends TTransportFactory {
            private final UserGroupInformation ugi;
            private final TTransportFactory wrapped;

            public TUGIAssumingTransportFactory(TTransportFactory wrapped, UserGroupInformation ugi) {
                assert (wrapped != null);
                assert (ugi != null);
                this.wrapped = wrapped;
                this.ugi = ugi;
            }

            @Override
            public TTransport getTransport(final TTransport trans) {
                return (TTransport)this.ugi.doAs((PrivilegedAction)new PrivilegedAction<TTransport>(){

                    @Override
                    public TTransport run() {
                        return TUGIAssumingTransportFactory.this.wrapped.getTransport(trans);
                    }
                });
            }
        }

        protected class TUGIAssumingProcessor
        implements TProcessor {
            final TProcessor wrapped;
            DelegationTokenSecretManager secretManager;
            boolean useProxy;

            TUGIAssumingProcessor(TProcessor wrapped, DelegationTokenSecretManager secretManager, boolean useProxy) {
                this.wrapped = wrapped;
                this.secretManager = secretManager;
                this.useProxy = useProxy;
            }

            @Override
            public boolean process(final TProtocol inProt, final TProtocol outProt) throws TException {
                TTransport trans = inProt.getTransport();
                if (!(trans instanceof TSaslServerTransport)) {
                    throw new TException("Unexpected non-SASL transport " + trans.getClass());
                }
                TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
                SaslServer saslServer = saslTrans.getSaslServer();
                String authId = saslServer.getAuthorizationID();
                authenticationMethod.set(UserGroupInformation.AuthenticationMethod.KERBEROS);
                LOG.debug((Object)("AUTH ID ======>" + authId));
                String endUser = authId;
                if (saslServer.getMechanismName().equals("DIGEST-MD5")) {
                    try {
                        TokenIdentifier tokenId = SaslRpcServer.getIdentifier((String)authId, (SecretManager)this.secretManager);
                        endUser = tokenId.getUser().getUserName();
                        authenticationMethod.set(UserGroupInformation.AuthenticationMethod.TOKEN);
                    }
                    catch (SecretManager.InvalidToken e) {
                        throw new TException(e.getMessage());
                    }
                }
                Socket socket = ((TSocket)saslTrans.getUnderlyingTransport()).getSocket();
                remoteAddress.set(socket.getInetAddress());
                UserGroupInformation clientUgi = null;
                try {
                    if (this.useProxy) {
                        clientUgi = UserGroupInformation.createProxyUser((String)endUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                        ProxyUsers.authorize((UserGroupInformation)clientUgi, (String)Server.this.getRemoteAddress().getHostAddress(), null);
                        remoteUser.set(clientUgi.getShortUserName());
                        LOG.debug((Object)("Set remoteUser :" + (String)remoteUser.get()));
                        boolean bl = (Boolean)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                try {
                                    return TUGIAssumingProcessor.this.wrapped.process(inProt, outProt);
                                }
                                catch (TException te) {
                                    throw new RuntimeException(te);
                                }
                            }
                        });
                        return bl;
                    }
                    UserGroupInformation endUserUgi = UserGroupInformation.createRemoteUser((String)endUser);
                    remoteUser.set(endUserUgi.getShortUserName());
                    LOG.debug((Object)("Set remoteUser :" + (String)remoteUser.get() + ", from endUser :" + endUser));
                    boolean bl = this.wrapped.process(inProt, outProt);
                    return bl;
                }
                catch (RuntimeException rte) {
                    if (rte.getCause() instanceof TException) {
                        throw (TException)rte.getCause();
                    }
                    throw rte;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    if (clientUgi != null) {
                        try {
                            FileSystem.closeAllForUGI((UserGroupInformation)clientUgi);
                        }
                        catch (IOException exception) {
                            LOG.error((Object)("Could not clean up file-system handles for UGI: " + clientUgi), (Throwable)exception);
                        }
                    }
                }
            }
        }

        static class SaslDigestCallbackHandler
        implements CallbackHandler {
            private final DelegationTokenSecretManager secretManager;

            public SaslDigestCallbackHandler(DelegationTokenSecretManager secretManager) {
                this.secretManager = secretManager;
            }

            private char[] getPassword(DelegationTokenIdentifier tokenid) throws SecretManager.InvalidToken {
                return this.encodePassword(this.secretManager.retrievePassword(tokenid));
            }

            private char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }

            @Override
            public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof AuthorizeCallback) {
                        ac = (AuthorizeCallback)callback;
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) continue;
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
                }
                if (pc != null) {
                    DelegationTokenIdentifier tokenIdentifier = (DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)nc.getDefaultName(), (SecretManager)this.secretManager);
                    char[] password = this.getPassword(tokenIdentifier);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser()));
                    }
                    pc.setPassword(password);
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (ac.isAuthorized()) {
                        if (LOG.isDebugEnabled()) {
                            String username = ((DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)authzid, (SecretManager)this.secretManager)).getUser().getUserName();
                            LOG.debug((Object)("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username));
                        }
                        ac.setAuthorizedID(authzid);
                    }
                }
            }
        }

        public static enum ServerMode {
            HIVESERVER2,
            METASTORE;

        }
    }

    public static class Client {
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            SaslRpcServer.AuthMethod method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr);
            TSaslClientTransport saslTransport = null;
            switch (method) {
                case DIGEST: {
                    Token t = new Token();
                    t.decodeFromUrlString(tokenStrForm);
                    saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, new SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
                    return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
                }
                case KERBEROS: {
                    String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                    String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                    if (names.length != 3) {
                        throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                    }
                    try {
                        saslTransport = new TSaslClientTransport(method.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                        return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
                    }
                    catch (SaslException se) {
                        throw new IOException("Could not instantiate SASL transport", se);
                    }
                }
            }
            throw new IOException("Unsupported authentication method: " + method);
        }

        private static class SaslClientCallbackHandler
        implements CallbackHandler {
            private final String userName;
            private final char[] userPassword;

            public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
                this.userName = SaslClientCallbackHandler.encodeIdentifier(token.getIdentifier());
                this.userPassword = SaslClientCallbackHandler.encodePassword(token.getPassword());
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                TextInputCallback rc = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof RealmChoiceCallback) continue;
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        rc = (RealmCallback)callback;
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
                }
                if (nc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL client callback: setting username: " + this.userName));
                    }
                    nc.setName(this.userName);
                }
                if (pc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SASL client callback: setting userPassword");
                    }
                    pc.setPassword(this.userPassword);
                }
                if (rc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL client callback: setting realm: " + rc.getDefaultText()));
                    }
                    rc.setText(rc.getDefaultText());
                }
            }

            static String encodeIdentifier(byte[] identifier) {
                return new String(Base64.encodeBase64((byte[])identifier));
            }

            static char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }
        }
    }
}

