/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;

public class FilterUtils {
    public static Database filterDbIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Database db) throws MetaException, NoSuchObjectException {
        Database filteredDb;
        if (isFilterEnabled && (filteredDb = filterHook.filterDatabase(db)) == null) {
            throw new NoSuchObjectException("DB " + db.getName() + " not found.");
        }
        return db;
    }

    public static List<String> filterDbNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<String> dbNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterDatabases(dbNames);
        }
        return dbNames;
    }

    public static List<String> filterTableNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String dbName, List<String> tableNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterTableNames(dbName, tableNames);
        }
        return tableNames;
    }

    public static List<Table> filterTablesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<Table> tables) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterTables(tables);
        }
        return tables;
    }

    public static Table filterTableIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Table table) throws MetaException, NoSuchObjectException {
        Table filteredTable;
        if (isFilterEnabled && (filteredTable = filterHook.filterTable(table)) == null) {
            throw new NoSuchObjectException("Table " + table.getDbName() + "." + table.getTableName() + " not found.");
        }
        return table;
    }

    public static List<TableMeta> filterTableMetasIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String dbName, List<TableMeta> tableMetas) throws MetaException, NoSuchObjectException {
        if (tableMetas == null || tableMetas.isEmpty()) {
            return tableMetas;
        }
        if (isFilterEnabled) {
            List<String> tableNames = tableMetas.stream().map(t -> t.getTableName()).collect(Collectors.toList());
            HashSet<String> filteredTableNames = new HashSet<String>(filterHook.filterTableNames(dbName, tableNames));
            ArrayList<TableMeta> filtedTableMetas = new ArrayList<TableMeta>(tableMetas.size());
            for (TableMeta tableMeta : tableMetas) {
                if (!filteredTableNames.contains(tableMeta.getTableName())) continue;
                filtedTableMetas.add(tableMeta);
            }
            return filtedTableMetas;
        }
        return tableMetas;
    }

    public static Partition filterPartitionIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Partition p) throws MetaException, NoSuchObjectException {
        Partition filteredPartition;
        if (isFilterEnabled && (filteredPartition = filterHook.filterPartition(p)) == null) {
            throw new NoSuchObjectException("Partition in " + p.getDbName() + "." + p.getTableName() + " not found.");
        }
        return p;
    }

    public static List<Partition> filterPartitionsIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<Partition> partitions) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitions(partitions);
        }
        return partitions;
    }

    public static List<String> filterPartitionNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String dbName, String tableName, List<String> partitionNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitionNames(dbName, tableName, partitionNames);
        }
        return partitionNames;
    }

    public static List<PartitionSpec> filterPartitionSpecsIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<PartitionSpec> partitionSpecs) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitionSpecs(partitionSpecs);
        }
        return partitionSpecs;
    }

    public static Index filterIndexIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Index index) throws MetaException, NoSuchObjectException {
        if (isFilterEnabled) {
            return filterHook.filterIndex(index);
        }
        return index;
    }

    public static List<String> filterIndexNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String dbName, String tableName, List<String> indexNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterIndexNames(dbName, tableName, indexNames);
        }
        return indexNames;
    }

    public static List<Index> filterIndexesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<Index> indexes) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterIndexes(indexes);
        }
        return indexes;
    }

    public static void checkDbAndTableFilters(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        if (dbName == null) {
            throw new NullPointerException("dbName is null");
        }
        if (StringUtils.isBlank(dbName)) {
            throw new NoSuchObjectException("dbName is not valid");
        }
        List<String> filteredDb = FilterUtils.filterDbNamesIfEnabled(isFilterEnabled, filterHook, Collections.singletonList(dbName));
        if (filteredDb.isEmpty()) {
            throw new NoSuchObjectException("Database " + dbName + " does not exist");
        }
        if (tblName == null) {
            throw new NullPointerException("tblName is null");
        }
        if (StringUtils.isBlank(tblName)) {
            throw new NoSuchObjectException("tblName is not valid");
        }
        List<String> filteredTable = FilterUtils.filterTableNamesIfEnabled(isFilterEnabled, filterHook, dbName, Collections.singletonList(tblName));
        if (filteredTable.isEmpty()) {
            throw new NoSuchObjectException("Table " + tblName + " does not exist");
        }
    }
}

