/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsTask
extends Task<StatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(StatsTask.class);
    private Table table;
    private Collection<Partition> dpPartSpecs = null;

    @Override
    protected void receiveFeed(Task.FeedType feedType, Object feedValue) {
        if (feedType == Task.FeedType.DYNAMIC_PARTITIONS) {
            this.dpPartSpecs = (Collection)feedValue;
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info("Executing stats task");
        int workComponentsPresent = 0;
        if (((StatsWork)this.work).getLoadTableDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getTableSpecs() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        assert (workComponentsPresent == 1);
        String tableName = "";
        Hive hive = this.getHive();
        try {
            tableName = ((StatsWork)this.work).getLoadTableDesc() != null ? ((StatsWork)this.work).getLoadTableDesc().getTable().getTableName() : (((StatsWork)this.work).getTableSpecs() != null ? ((StatsWork)this.work).getTableSpecs().tableName : ((StatsWork)this.work).getLoadFileDesc().getDestinationCreateTable());
            this.table = hive.getTable(tableName);
        }
        catch (HiveException e) {
            LOG.error("Cannot get table " + tableName, (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats(hive);
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private int aggregateStats(Hive db) {
        block42: {
            block39: {
                block40: {
                    statsAggregator = null;
                    ret = 0;
                    scc = null;
                    environmentContext = null;
                    wh = new Warehouse(this.conf);
                    if (!((StatsWork)this.getWork()).getNoStatsAggregator() && !((StatsWork)this.getWork()).isNoScanAnalyzeCommand()) {
                        try {
                            scc = this.getContext();
                            statsAggregator = this.createStatsAggregator(scc);
                        }
                        catch (HiveException e) {
                            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                                throw e;
                            }
                            this.console.printError(ErrorMsg.STATS_SKIPPING_BY_ERROR.getErrorCodedMsg(new String[]{e.toString()}));
                        }
                    }
                    partitions = this.getPartitionsList(db);
                    atomic = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_ATOMIC);
                    tableFullName = this.table.getDbName() + "." + this.table.getTableName();
                    if (partitions != null) ** GOTO lbl51
                    tTable = this.table.getTTable();
                    parameters = tTable.getParameters();
                    if (((StatsWork)this.work).getTableSpecs() == null && AcidUtils.isAcidTable(this.table)) {
                        StatsSetupConst.setBasicStatsState(parameters, "false");
                    } else if (((StatsWork)this.work).getTableSpecs() != null || ((StatsWork)this.work).getLoadTableDesc() != null && ((StatsWork)this.work).getLoadTableDesc().getReplace() || ((StatsWork)this.work).getLoadFileDesc() != null && !((StatsWork)this.work).getLoadFileDesc().getDestinationCreateTable().isEmpty()) {
                        StatsSetupConst.setBasicStatsState(parameters, "true");
                    }
                    if (this.existStats(parameters) || !atomic) break block39;
                    var12_16 = 0;
                    if (statsAggregator == null) break block40;
                    statsAggregator.closeConnection(scc);
                }
                return var12_16;
            }
            try {
                block43: {
                    if (((StatsWork)this.work).isClearAggregatorStats()) {
                        StatsSetupConst.setBasicStatsState(parameters, "false");
                    }
                    this.updateQuickStats(wh, parameters, tTable.getSd());
                    if (StatsSetupConst.areBasicStatsUptoDate(parameters)) {
                        if (statsAggregator != null) {
                            prefix = this.getAggregationPrefix(this.table, null);
                            this.updateStats(statsAggregator, parameters, prefix, atomic);
                        }
                        if (!((StatsWork)this.getWork()).getNoStatsAggregator()) {
                            environmentContext = new EnvironmentContext();
                            environmentContext.putToProperties("STATS_GENERATED", "TASK");
                        }
                    }
                    this.getHive().alterTable(tableFullName, new Table(tTable), environmentContext);
                    if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                        this.console.printInfo("Table " + tableFullName + " stats: [" + this.toString(parameters) + ']');
                    }
                    StatsTask.LOG.info("Table " + tableFullName + " stats: [" + this.toString(parameters) + ']');
                    break block43;
lbl51:
                    // 1 sources

                    updates = new ArrayList<Partition>();
                    fileStatusMap = new ConcurrentHashMap<K, V>();
                    poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 1);
                    poolSize = Math.max(poolSize, 1);
                    pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("stats-updater-thread-%d").build());
                    futures = Lists.newLinkedList();
                    StatsTask.LOG.debug("Getting file stats of all partitions. threadpool size:" + poolSize);
                    try {
                        for (Partition partn : partitions) {
                            partitionName = partn.getName();
                            tPart = partn.getTPartition();
                            parameters = tPart.getParameters();
                            if (!this.existStats(parameters) && atomic) continue;
                            futures.add(pool.submit(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    FileStatus[] partfileStatus = wh.getFileStatusesForSD(tPart.getSd());
                                    fileStatusMap.put(partitionName, partfileStatus);
                                    return null;
                                }
                            }));
                        }
                        pool.shutdown();
                        for (Object future : futures) {
                            future.get();
                        }
                    }
                    catch (InterruptedException e) {
                        StatsTask.LOG.debug("Cancelling " + futures.size() + " file stats lookup tasks");
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                        if (((StatsWork)this.work).isStatsReliable()) {
                            ret = 1;
                        }
                    }
                    finally {
                        if (pool != null) {
                            pool.shutdownNow();
                        }
                        StatsTask.LOG.debug("Finished getting file stats of all partitions");
                    }
                    for (Partition partn : partitions) {
                        tPart = partn.getTPartition();
                        parameters = tPart.getParameters();
                        if (((StatsWork)this.work).getTableSpecs() == null && AcidUtils.isAcidTable(this.table)) {
                            StatsSetupConst.setBasicStatsState(parameters, "false");
                        } else if (((StatsWork)this.work).getTableSpecs() != null || ((StatsWork)this.work).getLoadTableDesc() != null && ((StatsWork)this.work).getLoadTableDesc().getReplace() || ((StatsWork)this.work).getLoadFileDesc() != null && !((StatsWork)this.work).getLoadFileDesc().getDestinationCreateTable().isEmpty()) {
                            StatsSetupConst.setBasicStatsState(parameters, "true");
                        }
                        if (!fileStatusMap.containsKey(partn.getName())) continue;
                        if (((StatsWork)this.work).isClearAggregatorStats()) {
                            StatsSetupConst.setBasicStatsState(parameters, "false");
                        }
                        this.updateQuickStats(parameters, (FileStatus[])fileStatusMap.get(partn.getName()));
                        if (StatsSetupConst.areBasicStatsUptoDate(parameters)) {
                            if (statsAggregator != null) {
                                prefix = this.getAggregationPrefix(this.table, partn);
                                this.updateStats(statsAggregator, parameters, prefix, atomic);
                            }
                            if (!((StatsWork)this.getWork()).getNoStatsAggregator()) {
                                environmentContext = new EnvironmentContext();
                                environmentContext.putToProperties("STATS_GENERATED", "TASK");
                            }
                        }
                        updates.add(new Partition(this.table, tPart));
                        if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                            this.console.printInfo("Partition " + tableFullName + partn.getSpec() + " stats: [" + this.toString(parameters) + ']');
                        }
                        StatsTask.LOG.info("Partition " + tableFullName + partn.getSpec() + " stats: [" + this.toString(parameters) + ']');
                    }
                    if (!updates.isEmpty()) {
                        db.alterPartitions(tableFullName, updates, environmentContext);
                    }
                }
                if (statsAggregator == null) break block42;
                statsAggregator.closeConnection(scc);
            }
            catch (Exception e) {
                try {
                    this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (((StatsWork)this.work).isStatsReliable()) {
                        ret = 1;
                    }
                    if (statsAggregator == null) break block42;
                    statsAggregator.closeConnection(scc);
                }
                catch (Throwable var21_28) {
                    if (statsAggregator != null) {
                        statsAggregator.closeConnection(scc);
                    }
                    throw var21_28;
                }
            }
        }
        return ret;
    }

    private String getAggregationPrefix(Table table, Partition partition) throws MetaException {
        String prefix = table.getDbName() + "." + MetaStoreUtils.encodeTableName(table.getTableName());
        if (partition != null) {
            return Utilities.join(prefix, Warehouse.makePartPath(partition.getSpec()));
        }
        return prefix;
    }

    private StatsAggregator createStatsAggregator(StatsCollectionContext scc) throws HiveException {
        String statsImpl = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory factory = StatsFactory.newFactory(statsImpl, this.conf);
        if (factory == null) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
        }
        StatsPublisher statsPublisher = factory.getStatsPublisher();
        if (!statsPublisher.init(scc)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        StatsAggregator statsAggregator = factory.getStatsAggregator();
        if (!statsAggregator.connect(scc)) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_CONNECTION_ERROR.getErrorCodedMsg(statsImpl));
        }
        return statsAggregator;
    }

    private StatsCollectionContext getContext() throws HiveException {
        StatsCollectionContext scc = new StatsCollectionContext(this.conf);
        Task sourceTask = ((StatsWork)this.getWork()).getSourceTask();
        if (sourceTask == null) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_SOURCETASK_NULL.getErrorCodedMsg());
        }
        scc.setTask(sourceTask);
        scc.setStatsTmpDir(((StatsWork)this.getWork()).getStatsTmpDir());
        return scc;
    }

    private boolean existStats(Map<String, String> parameters) {
        return parameters.containsKey("numRows") || parameters.containsKey("numFiles") || parameters.containsKey("totalSize") || parameters.containsKey("rawDataSize") || parameters.containsKey("numPartitions");
    }

    private void updateStats(StatsAggregator statsAggregator, Map<String, String> parameters, String prefix, boolean atomic) throws HiveException {
        String aggKey = prefix.endsWith("/") ? prefix : prefix + "/";
        for (String statType : StatsSetupConst.STATS_REQUIRE_COMPUTE) {
            String value = statsAggregator.aggregateStats(aggKey, statType);
            if (value != null && !value.isEmpty()) {
                String originalValue;
                long longValue = Long.parseLong(value);
                if (((StatsWork)this.work).getLoadTableDesc() != null && !((StatsWork)this.work).getLoadTableDesc().getReplace() && (originalValue = parameters.get(statType)) != null) {
                    longValue += Long.parseLong(originalValue);
                }
                parameters.put(statType, String.valueOf(longValue));
                continue;
            }
            if (!atomic) continue;
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_MISSED_SOMESTATS, statType);
        }
    }

    private void updateQuickStats(Warehouse wh, Map<String, String> parameters, StorageDescriptor desc) throws MetaException {
        FileStatus[] partfileStatus = wh.getFileStatusesForSD(desc);
        this.updateQuickStats(parameters, partfileStatus);
    }

    private void updateQuickStats(Map<String, String> parameters, FileStatus[] partfileStatus) throws MetaException {
        MetaStoreUtils.populateQuickStats(partfileStatus, parameters);
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.SUPPORTED_STATS) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList(Hive db) throws HiveException {
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            return null;
        }
        ArrayList<Partition> list = new ArrayList<Partition>();
        if (((StatsWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = ((StatsWork)this.work).getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partn : partitions) {
                    list.add(partn);
                }
            }
        } else if (((StatsWork)this.work).getLoadTableDesc() != null) {
            LoadTableDesc tbd = ((StatsWork)this.work).getLoadTableDesc();
            this.table = db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                if (this.dpPartSpecs != null) {
                    list.addAll(this.dpPartSpecs);
                }
            } else {
                Partition partn = db.getPartition(this.table, tbd.getPartitionSpec(), false);
                list.add(partn);
            }
        }
        return list;
    }
}

