/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprCondExprCondExpr
extends IfExprCondExprBase {
    private static final long serialVersionUID = 1L;
    protected final int arg2Column;
    protected final int arg3Column;

    public IfExprCondExprCondExpr(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(arg1Column, outputColumnNum);
        this.arg2Column = arg2Column;
        this.arg3Column = arg3Column;
    }

    public IfExprCondExprCondExpr() {
        this.arg2Column = -1;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int batchIndex;
        int i;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        super.evaluate(batch);
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        outputColVector.init();
        ColumnVector thenColVector = batch.cols[this.arg2Column];
        ColumnVector elseColVector = batch.cols[this.arg3Column];
        int thenCount = this.thenSelectedCount;
        int elseCount = this.elseSelectedCount;
        if (this.isIfStatementResultRepeated) {
            if (this.isIfStatementResultThen) {
                this.childExpressions[1].evaluate(batch);
                thenColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            } else {
                this.childExpressions[2].evaluate(batch);
                elseColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            }
            return;
        }
        this.conditionalEvaluate(batch, this.childExpressions[1], this.thenSelected, thenCount);
        for (i = 0; i < thenCount; ++i) {
            batchIndex = this.thenSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, thenColVector);
        }
        this.conditionalEvaluate(batch, this.childExpressions[2], this.elseSelected, elseCount);
        for (i = 0; i < elseCount; ++i) {
            batchIndex = this.elseSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, elseColVector);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumnNum;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", " + this.getColumnParamString(1, this.arg2Column) + this.getColumnParamString(2, this.arg3Column);
    }
}

