/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongColGreaterLongScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputColumn;
    protected int colNum;
    protected long value;

    public LongColGreaterLongScalar(int colNum, long value, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public LongColGreaterLongScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = vector[0] > this.value ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = this.value - vector[i] >>> 63;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.value - vector[i] >>> 63;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value - vector[i] >>> 63;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    outputVector[i] = this.value - vector[i] >>> 63;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value - vector[i] >>> 63;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

