/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetLongArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToLong;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class PosModLongToLong
extends MathFuncLongToLong
implements ISetLongArg {
    private static final long serialVersionUID = 1L;
    private long divisor;
    private String outputCastType = "bigint";

    public PosModLongToLong(int inputCol, long scalarVal, int outputCol) {
        super(inputCol, outputCol);
        this.divisor = scalarVal;
    }

    public PosModLongToLong() {
    }

    @Override
    protected long func(long v) {
        switch (this.outputCastType) {
            case "tinyint": {
                byte castedByte = (byte)v;
                byte castedDivisorByte = (byte)this.divisor;
                return (castedByte % castedDivisorByte + castedDivisorByte) % castedDivisorByte;
            }
            case "smallint": {
                short castedShort = (short)v;
                short castedDivisorShort = (short)this.divisor;
                return (castedShort % castedDivisorShort + castedDivisorShort) % castedDivisorShort;
            }
            case "int": {
                int castedInt = (int)v;
                int castedDivisorInt = (int)this.divisor;
                return (castedInt % castedDivisorInt + castedDivisorInt) % castedDivisorInt;
            }
        }
        return (v % this.divisor + this.divisor) % this.divisor;
    }

    @Override
    public void setOutputTypeInfo(TypeInfo outputTypeInfo) {
        this.outputTypeInfo = outputTypeInfo;
        if (outputTypeInfo != null) {
            this.outputCastType = outputTypeInfo.getTypeName();
        }
    }

    @Override
    public void setArg(long arg) {
        this.divisor = arg;
    }

    public void setDivisor(long v) {
        this.divisor = v;
    }

    public long getDivisor() {
        return this.divisor;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", divisor " + this.divisor;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

