/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddScalarCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private Object object;
    private long longValue = 0L;
    private Timestamp timestampValue = null;
    private byte[] stringValue = null;
    protected boolean isPositive = true;
    private final transient DateParser dateParser = new DateParser();
    private final transient Date baseDate = new Date(0L);

    public VectorUDFDateAddScalarCol() {
    }

    public VectorUDFDateAddScalarCol(Object object, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.object = object;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof Timestamp) {
            this.timestampValue = (Timestamp)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        } else {
            throw new RuntimeException("Unexpected scalar object " + object.getClass().getName() + " " + object.toString());
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputCol = (LongColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        boolean[] outputIsNull = outputColVector.isNull;
        switch (this.inputTypes[0]) {
            case DATE: {
                this.baseDate.setTime(DateWritable.daysToMillis((int)this.longValue));
                break;
            }
            case TIMESTAMP: {
                this.baseDate.setTime(this.timestampValue.getTime());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                boolean parsed = this.dateParser.parseDate(new String(this.stringValue, StandardCharsets.UTF_8), this.baseDate);
                if (parsed) break;
                outputColVector.noNulls = false;
                if (selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        outputColVector.isNull[i] = true;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        outputColVector.isNull[i] = true;
                    }
                }
                return;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
        if (batch.size == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        long baseDateDays = DateWritable.millisToDays(this.baseDate.getTime());
        if (inputCol.isRepeating) {
            if (inputCol.noNulls || !inputCol.isNull[0]) {
                outputColVector.isNull[0] = false;
                this.evaluate(baseDateDays, inputCol.vector[0], outputColVector, 0);
            } else {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputCol.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputColVector.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            }
        }
    }

    private void evaluate(long baseDateDays, long numDays, LongColumnVector output, int i) {
        long result = baseDateDays;
        result = this.isPositive ? (result += numDays) : (result -= numDays);
        output.vector[i] = result;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setPositive(boolean isPositive) {
        this.isPositive = isPositive;
    }

    @Override
    public String vectorExpressionParameters() {
        String value;
        if (this.object instanceof Long) {
            Date tempDate = new Date(0L);
            tempDate.setTime(DateWritable.daysToMillis((int)this.longValue));
            value = tempDate.toString();
        } else {
            value = this.object instanceof Timestamp ? this.timestampValue.toString() : (this.object instanceof byte[] ? new String(this.stringValue, StandardCharsets.UTF_8) : "unknown");
        }
        return "val " + value + ", " + this.getColumnParamString(0, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

