/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterIntervalDayTimeColNotEqualIntervalDayTimeColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;

    public FilterIntervalDayTimeColNotEqualIntervalDayTimeColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterIntervalDayTimeColNotEqualIntervalDayTimeColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector1 = (IntervalDayTimeColumnVector)batch.cols[this.colNum1];
        IntervalDayTimeColumnVector inputColVector2 = (IntervalDayTimeColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (inputColVector1.compareTo(0, inputColVector2, 0) == 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos2[0] || inputColVector1.compareTo(0, inputColVector2, 0) == 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos2[i] || inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos2[i] || inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos1[0] || inputColVector1.compareTo(0, inputColVector2, 0) == 0) {
                    batch.size = 0;
                    return;
                }
            } else if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (nullPos1[0] || nullPos2[0] || inputColVector1.compareTo(0, inputColVector2, 0) == 0) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (nullPos1[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || inputColVector1.compareTo(0, inputColVector2, i) == 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (nullPos2[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || inputColVector1.compareTo(i, inputColVector2, 0) == 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos1[i] || nullPos2[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos1[i] || nullPos2[i] || inputColVector1.compareTo(i, inputColVector2, i) == 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

