/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprDoubleColumnLongScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg2Column;
    private long arg3Scalar;
    private int outputColumn;

    public IfExprDoubleColumnLongScalar(int arg1Column, int arg2Column, long arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprDoubleColumnLongScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        DoubleColumnVector arg2ColVector = (DoubleColumnVector)batch.cols[this.arg2Column];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        double[] vector2 = arg2ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] == 1L ? vector2[i] : (double)this.arg3Scalar;
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? vector2[i] : (double)this.arg3Scalar;
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : (double)this.arg3Scalar;
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : (double)this.arg3Scalar;
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        }
        arg2ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getArg1Column() {
        return this.arg1Column;
    }

    public void setArg1Column(int colNum) {
        this.arg1Column = colNum;
    }

    public int getArg2Column() {
        return this.arg2Column;
    }

    public void setArg2Column(int colNum) {
        this.arg2Column = colNum;
    }

    public long getArg3Scalar() {
        return this.arg3Scalar;
    }

    public void setArg3Scalar(long value) {
        this.arg3Scalar = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", col " + this.arg2Column + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

