/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReader;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, PrimitiveType parquetType, TypeInfo hiveType, Dictionary dictionary, ValuesReader valuesReader, boolean skipTimestampConversion) throws IOException {
        int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        switch (parquetType.getPrimitiveTypeName()) {
            case INT32: {
                return isDictionary ? new TypesFromInt32PageReader(dictionary, length) : new TypesFromInt32PageReader(valuesReader, length);
            }
            case INT64: {
                return isDictionary ? new TypesFromInt64PageReader(dictionary, length) : new TypesFromInt64PageReader(valuesReader, length);
            }
            case FLOAT: {
                return isDictionary ? new TypesFromFloatPageReader(dictionary, length) : new TypesFromFloatPageReader(valuesReader, length);
            }
            case INT96: {
                return isDictionary ? new TypesFromInt96PageReader(dictionary, length, skipTimestampConversion) : new TypesFromInt96PageReader(valuesReader, length, skipTimestampConversion);
            }
            case BOOLEAN: {
                return isDictionary ? new TypesFromBooleanPageReader(dictionary, length) : new TypesFromBooleanPageReader(valuesReader, length);
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetDataColumnReaderFactory.getConvertorFromBinary(isDictionary, parquetType, hiveType, valuesReader, dictionary);
            }
            case DOUBLE: {
                return isDictionary ? new TypesFromDoublePageReader(dictionary, length) : new TypesFromDoublePageReader(valuesReader, length);
            }
        }
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
    }

    private static ParquetDataColumnReader getConvertorFromBinary(boolean isDict, PrimitiveType parquetType, TypeInfo hiveType, ValuesReader valuesReader, Dictionary dictionary) {
        OriginalType originalType = parquetType.getOriginalType();
        int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        if (originalType == null) {
            return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
        }
        switch (originalType) {
            case DECIMAL: {
                short scale = (short)parquetType.asPrimitiveType().getDecimalMetadata().getScale();
                return isDict ? new TypesFromDecimalPageReader(dictionary, length, scale) : new TypesFromDecimalPageReader(valuesReader, length, scale);
            }
            case UTF8: {
                return isDict ? new TypesFromStringPageReader(dictionary, length) : new TypesFromStringPageReader(valuesReader, length);
            }
        }
        return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(PrimitiveType parquetType, TypeInfo hiveType, Dictionary realReader, boolean skipTimestampConversion) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, parquetType, hiveType, realReader, null, skipTimestampConversion);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(PrimitiveType parquetType, TypeInfo hiveType, ValuesReader realReader, boolean skipTimestampConversion) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, parquetType, hiveType, null, realReader, skipTimestampConversion);
    }

    private static int getVarcharLength(TypeInfo hiveType) {
        int length = -1;
        if (hiveType instanceof PrimitiveTypeInfo) {
            PrimitiveTypeInfo hivePrimitiveType = (PrimitiveTypeInfo)hiveType;
            switch (hivePrimitiveType.getPrimitiveCategory()) {
                case CHAR: {
                    length = ((CharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
                case VARCHAR: {
                    length = ((VarcharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
            }
        }
        return length;
    }

    public static class TypesFromStringPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromStringPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromStringPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readVarchar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        private byte[] truncateIfNecesssary(byte[] bytes) {
            if (this.length <= 0 || bytes == null) {
                return bytes;
            }
            int len = bytes.length;
            int truncatedLength = StringExpr.truncate(bytes, 0, len, this.length);
            if (truncatedLength >= len) {
                return bytes;
            }
            return Arrays.copyOf(bytes, truncatedLength);
        }
    }

    public static class TypesFromDecimalPageReader
    extends DefaultParquetDataColumnReader {
        private HiveDecimalWritable tempDecimal = new HiveDecimalWritable();
        private short scale;

        public TypesFromDecimalPageReader(ValuesReader realReader, int length, short scale) {
            super(realReader, length);
            this.scale = scale;
        }

        public TypesFromDecimalPageReader(Dictionary dict, int length, short scale) {
            super(dict, length);
            this.scale = scale;
        }

        @Override
        public byte[] readString() {
            return this.convertToBytes(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString(int id) {
            return this.convertToBytes(this.dict.decodeToBinary(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        private String convertToString(Binary value) {
            this.tempDecimal.set(value.getBytesUnsafe(), this.scale);
            return this.tempDecimal.toString();
        }

        private byte[] convertToBytes(Binary value) {
            return TypesFromDecimalPageReader.convertToBytes(this.convertToString(value));
        }
    }

    public static class TypesFromInt96PageReader
    extends DefaultParquetDataColumnReader {
        private boolean skipTimestampConversion = false;

        public TypesFromInt96PageReader(ValuesReader realReader, int length, boolean skipTimestampConversion) {
            super(realReader, length);
            this.skipTimestampConversion = skipTimestampConversion;
        }

        public TypesFromInt96PageReader(Dictionary dict, int length, boolean skipTimestampConversion) {
            super(dict, length);
            this.skipTimestampConversion = skipTimestampConversion;
        }

        private Timestamp convert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            NanoTime nt = new NanoTime(julianDay, timeOfDayNanos);
            return NanoTimeUtils.getTimestamp(nt, this.skipTimestampConversion);
        }

        @Override
        public Timestamp readTimestamp(int id) {
            return this.convert(this.dict.decodeToBinary(id));
        }

        @Override
        public Timestamp readTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString() {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        private static String convertToString(Timestamp value) {
            return value.toString();
        }

        private static byte[] convertToBytes(Timestamp value) {
            return TypesFromInt96PageReader.convertToBytes(TypesFromInt96PageReader.convertToString(value));
        }
    }

    public static class TypesFromBooleanPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromBooleanPageReader(ValuesReader valuesReader, int length) {
            super(valuesReader, length);
        }

        public TypesFromBooleanPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readString() {
            return TypesFromBooleanPageReader.convertToBytes(this.valuesReader.readBoolean());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromBooleanPageReader.convertToBytes(this.dict.decodeToBoolean(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        private static String convertToString(boolean value) {
            return Boolean.toString(value);
        }

        private static byte[] convertToBytes(boolean value) {
            return TypesFromBooleanPageReader.convertToBytes(TypesFromBooleanPageReader.convertToString(value));
        }
    }

    public static class TypesFromDoublePageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromDoublePageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromDoublePageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readString() {
            return TypesFromDoublePageReader.convertToBytes(this.valuesReader.readDouble());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromDoublePageReader.convertToBytes(this.dict.decodeToDouble(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        private static String convertToString(double value) {
            return Double.toString(value);
        }

        private static byte[] convertToBytes(double value) {
            return TypesFromDoublePageReader.convertToBytes(TypesFromDoublePageReader.convertToString(value));
        }
    }

    public static class TypesFromFloatPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromFloatPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromFloatPageReader(Dictionary realReader, int length) {
            super(realReader, length);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readFloat();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromFloatPageReader.convertToBytes(this.valuesReader.readFloat());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromFloatPageReader.convertToBytes(this.dict.decodeToFloat(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        private static String convertToString(float value) {
            return Float.toString(value);
        }

        private static byte[] convertToBytes(float value) {
            return TypesFromFloatPageReader.convertToBytes(TypesFromFloatPageReader.convertToString(value));
        }
    }

    public static class TypesFromInt64PageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromInt64PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromInt64PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readLong();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readLong();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromInt64PageReader.convertToBytes(this.valuesReader.readLong());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt64PageReader.convertToBytes(this.dict.decodeToLong(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        private static String convertToString(long value) {
            return Long.toString(value);
        }

        private static byte[] convertToBytes(long value) {
            return TypesFromInt64PageReader.convertToBytes(TypesFromInt64PageReader.convertToString(value));
        }
    }

    public static class TypesFromInt32PageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromInt32PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromInt32PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readInteger();
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readInteger();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readInteger();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromInt32PageReader.convertToBytes(this.valuesReader.readInteger());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt32PageReader.convertToBytes(this.dict.decodeToInt(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        private static String convertToString(int value) {
            return Integer.toString(value);
        }

        private static byte[] convertToBytes(int value) {
            return TypesFromInt32PageReader.convertToBytes(TypesFromInt32PageReader.convertToString(value));
        }
    }

    public static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        protected ValuesReader valuesReader;
        protected Dictionary dict;
        protected int length = -1;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader, int length) {
            this.valuesReader = valuesReader;
            this.length = length;
        }

        public DefaultParquetDataColumnReader(Dictionary dict, int length) {
            this.dict = dict;
            this.length = length;
        }

        public void initFromPage(int i, ByteBuffer byteBuffer, int i1) throws IOException {
            this.valuesReader.initFromPage(i, byteBuffer, i1);
        }

        @Override
        public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
            this.initFromPage(valueCount, ByteBuffer.wrap(page), offset);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readString(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readString() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readChar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readChar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public Timestamp readTimestamp() {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public Timestamp readTimestamp(int id) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public int readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        public void skip() {
            this.valuesReader.skip();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }

        protected String enforceMaxLength(String value) {
            return HiveBaseChar.enforceMaxLength(value, this.length);
        }

        protected String getPaddedString(String value) {
            return HiveBaseChar.getPaddedValue(value, this.length);
        }

        protected static byte[] convertToBytes(String value) {
            try {
                return value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to encode string in UTF-8", e);
            }
        }
    }
}

