/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.DemuxOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationOptimizer;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.IntraQueryCorrelation;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DemuxDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MuxDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPlanTreeTransformation {
    private static final Logger LOG = LoggerFactory.getLogger((String)QueryPlanTreeTransformation.class.getName());

    private static void setNewTag(IntraQueryCorrelation correlation, List<Operator<? extends OperatorDesc>> childrenOfDemux, ReduceSinkOperator rsop, Map<ReduceSinkOperator, Integer> bottomRSToNewTag) throws SemanticException {
        Operator<?> child;
        int newTag = bottomRSToNewTag.get(rsop);
        int oldTag = ((ReduceSinkDesc)rsop.getConf()).getTag();
        if (oldTag == -1) {
            oldTag = 0;
        }
        if (!childrenOfDemux.contains(child = CorrelationUtilities.getSingleChild(rsop, true))) {
            childrenOfDemux.add(child);
        }
        int childIndex = childrenOfDemux.indexOf(child);
        correlation.setNewTag(newTag, oldTag, childIndex);
        ((ReduceSinkDesc)rsop.getConf()).setTag(newTag);
    }

    protected static void applyCorrelation(ParseContext pCtx, CorrelationOptimizer.CorrelationNodeProcCtx corrCtx, IntraQueryCorrelation correlation) throws SemanticException {
        List<ReduceSinkOperator> bottomReduceSinkOperators = correlation.getBottomReduceSinkOperators();
        int numReducers = correlation.getNumReducers();
        ArrayList<Operator<? extends OperatorDesc>> childrenOfDemux = new ArrayList<Operator<? extends OperatorDesc>>();
        ArrayList<Operator<? extends OperatorDesc>> parentRSsOfDemux = new ArrayList<Operator<? extends OperatorDesc>>();
        HashMap<Integer, Integer> childIndexToOriginalNumParents = new HashMap<Integer, Integer>();
        ArrayList<TableDesc> keysSerializeInfos = new ArrayList<TableDesc>();
        ArrayList<TableDesc> valuessSerializeInfos = new ArrayList<TableDesc>();
        HashMap<ReduceSinkOperator, Integer> bottomRSToNewTag = new HashMap<ReduceSinkOperator, Integer>();
        int newTag = 0;
        CompilationOpContext opCtx = null;
        for (ReduceSinkOperator rsop : bottomReduceSinkOperators) {
            if (opCtx == null) {
                opCtx = rsop.getCompilationOpContext();
            }
            ((ReduceSinkDesc)rsop.getConf()).setNumReducers(numReducers);
            bottomRSToNewTag.put(rsop, newTag);
            parentRSsOfDemux.add(rsop);
            keysSerializeInfos.add(((ReduceSinkDesc)rsop.getConf()).getKeySerializeInfo());
            valuessSerializeInfos.add(((ReduceSinkDesc)rsop.getConf()).getValueSerializeInfo());
            Operator<?> child = CorrelationUtilities.getSingleChild(rsop, true);
            if (!childrenOfDemux.contains(child)) {
                childrenOfDemux.add((Operator<? extends OperatorDesc>)child);
                int n = childrenOfDemux.size() - 1;
                childIndexToOriginalNumParents.put(n, child.getNumParent());
            }
            ++newTag;
        }
        for (ReduceSinkOperator rsop : bottomReduceSinkOperators) {
            QueryPlanTreeTransformation.setNewTag(correlation, childrenOfDemux, rsop, bottomRSToNewTag);
        }
        DemuxDesc demuxDesc = new DemuxDesc(correlation.getNewTagToOldTag(), correlation.getNewTagToChildIndex(), childIndexToOriginalNumParents, keysSerializeInfos, valuessSerializeInfos);
        Operator<DemuxDesc> demuxOp = OperatorFactory.get(opCtx, demuxDesc);
        demuxOp.setChildOperators(childrenOfDemux);
        demuxOp.setParentOperators(parentRSsOfDemux);
        for (Operator operator : childrenOfDemux) {
            ArrayList<Operator<? extends OperatorDesc>> parentsWithMultipleDemux = new ArrayList<Operator<? extends OperatorDesc>>();
            boolean hasBottomReduceSinkOperators = false;
            boolean hasNonBottomReduceSinkOperators = false;
            for (int i = 0; i < operator.getParentOperators().size(); ++i) {
                Operator<OperatorDesc> p = operator.getParentOperators().get(i);
                assert (p instanceof ReduceSinkOperator);
                ReduceSinkOperator rsop = (ReduceSinkOperator)p;
                if (bottomReduceSinkOperators.contains(rsop)) {
                    hasBottomReduceSinkOperators = true;
                    parentsWithMultipleDemux.add(demuxOp);
                    continue;
                }
                hasNonBottomReduceSinkOperators = true;
                parentsWithMultipleDemux.add(rsop);
            }
            if (hasBottomReduceSinkOperators && hasNonBottomReduceSinkOperators) {
                operator.setParentOperators(parentsWithMultipleDemux);
                continue;
            }
            operator.setParentOperators(Utilities.makeList(demuxOp));
        }
        for (Operator operator : parentRSsOfDemux) {
            operator.setChildOperators(Utilities.makeList(demuxOp));
        }
        HashSet<ReduceSinkOperator> handledRSs = new HashSet<ReduceSinkOperator>();
        for (ReduceSinkOperator rsop : correlation.getAllReduceSinkOperators()) {
            ArrayList<Operator<? extends OperatorDesc>> parentsOfMux;
            if (bottomReduceSinkOperators.contains(rsop) || handledRSs.contains(rsop)) continue;
            Operator<?> childOP = CorrelationUtilities.getSingleChild(rsop, true);
            if (childOP instanceof GroupByOperator) {
                CorrelationUtilities.removeReduceSinkForGroupBy(rsop, (GroupByOperator)childOP, pCtx, corrCtx);
                parentsOfMux = new ArrayList();
                Operator<?> parentOp = CorrelationUtilities.getSingleParent(childOP, true);
                parentsOfMux.add(parentOp);
                Operator<MuxDesc> mux = OperatorFactory.get(childOP.getCompilationOpContext(), new MuxDesc(parentsOfMux));
                mux.setChildOperators(Utilities.makeList(childOP));
                mux.setParentOperators(parentsOfMux);
                childOP.setParentOperators(Utilities.makeList(mux));
                parentOp.setChildOperators(Utilities.makeList(mux));
                continue;
            }
            parentsOfMux = new ArrayList<Operator<? extends OperatorDesc>>();
            List<Operator<? extends OperatorDesc>> siblingOPs = CorrelationUtilities.findSiblingOperators(rsop);
            for (Operator<? extends OperatorDesc> op : siblingOPs) {
                if (op instanceof DemuxOperator) {
                    parentsOfMux.add(op);
                    continue;
                }
                if (op instanceof ReduceSinkOperator) {
                    GroupByOperator pGBYm = CorrelationUtilities.getSingleParent(op, GroupByOperator.class);
                    if (pGBYm != null && ((GroupByDesc)pGBYm.getConf()).getMode() == GroupByDesc.Mode.HASH) {
                        CorrelationUtilities.removeOperator(pGBYm, op, CorrelationUtilities.getSingleParent(pGBYm, true), pCtx);
                    }
                    handledRSs.add((ReduceSinkOperator)op);
                    parentsOfMux.add(CorrelationUtilities.getSingleParent(op, true));
                    continue;
                }
                throw new SemanticException("An slibing of ReduceSinkOperator is nethier a DemuxOperator nor a ReduceSinkOperator");
            }
            MuxDesc muxDesc = new MuxDesc(siblingOPs);
            Operator<MuxDesc> mux = OperatorFactory.get(rsop.getCompilationOpContext(), muxDesc);
            mux.setChildOperators(Utilities.makeList(childOP));
            mux.setParentOperators(parentsOfMux);
            for (Operator operator : parentsOfMux) {
                if (operator instanceof DemuxOperator) {
                    if (!operator.getChildOperators().contains(childOP)) continue;
                    operator.replaceChild(childOP, mux);
                    continue;
                }
                operator.setChildOperators(Utilities.makeList(mux));
            }
            childOP.setParentOperators(Utilities.makeList(mux));
        }
        for (ReduceSinkOperator rsop : handledRSs) {
            rsop.setChildOperators(null);
            rsop.setParentOperators(null);
        }
    }
}

