/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.BRoundWithNumDigitsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncBRoundWithNumDigitsDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncBRoundDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncBRoundDoubleToDouble;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.RoundUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="bround", value="_FUNC_(x[, d]) - round x to d decimal places using HALF_EVEN rounding mode.", extended="Banker's rounding. The value is rounded to the nearest even number. Also known as Gaussian rounding.\nExample:\n  > SELECT _FUNC_(12.25, 1);\n  12.2")
@VectorizedExpressions(value={FuncBRoundDoubleToDouble.class, BRoundWithNumDigitsDoubleToDouble.class, FuncBRoundWithNumDigitsDecimalToDecimal.class, FuncBRoundDecimalToDecimal.class})
public class GenericUDFBRound
extends GenericUDFRound {
    @Override
    protected HiveDecimal round(HiveDecimal input, int scale) {
        return RoundUtils.bround(input, scale);
    }

    @Override
    protected long round(long input, int scale) {
        return RoundUtils.bround(input, scale);
    }

    @Override
    protected double round(double input, int scale) {
        return RoundUtils.bround(input, scale);
    }

    @Override
    protected DoubleWritable round(DoubleWritable input, int scale) {
        double d = input.get();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return new DoubleWritable(d);
        }
        return new DoubleWritable(RoundUtils.bround(d, scale));
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("bround", children);
    }
}

