/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private ByteBuffer in;
    private int offset;

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.limit() - offset));
        this.lengthReader.initFromPage(valueCount, in, offset);
        offset = this.lengthReader.getNextOffset();
        this.in = in;
        this.offset = offset;
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        int start = this.offset;
        this.offset = start + length;
        return Binary.fromConstantByteBuffer(this.in, start, length);
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        this.offset += length;
    }
}

