/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.AutoProgressor;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFiles;

public class ScriptOperator
extends Operator<ScriptDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private final transient LongWritable serialize_error_count = new LongWritable();
    transient Thread outThread = null;
    transient Thread errThread = null;
    transient Process scriptPid = null;
    transient Configuration hconf;
    transient Serializer scriptInputSerializer;
    transient Deserializer scriptOutputDeserializer;
    volatile transient Throwable scriptError = null;
    transient RecordWriter scriptOutWriter = null;
    transient Set<String> blackListedConfEntries = null;
    static final String IO_EXCEPTION_BROKEN_PIPE_STRING = "Broken pipe";
    static final String IO_EXCEPTION_STREAM_CLOSED = "Stream closed";
    transient AutoProgressor autoProgressor;
    transient boolean firstRow;
    private transient String tableName;
    private transient String partitionName;

    String safeEnvVarName(String name) {
        StringBuilder safe = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            int s = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? c : 95;
            safe.append((char)s);
        }
        return safe.toString();
    }

    String safeEnvVarValue(String value, String name, boolean truncate) {
        int lenLimit = 20480;
        if (truncate && value.length() > 20480) {
            value = value.substring(0, 20480);
            this.LOG.warn("Length of environment variable " + name + " was truncated to " + 20480 + " bytes to fit system limits.");
        }
        return value;
    }

    boolean blackListed(Configuration conf, String name) {
        if (this.blackListedConfEntries == null) {
            String bl;
            this.blackListedConfEntries = new HashSet<String>();
            if (conf != null && (bl = conf.get(HiveConf.ConfVars.HIVESCRIPT_ENV_BLACKLIST.toString(), HiveConf.ConfVars.HIVESCRIPT_ENV_BLACKLIST.getDefaultValue())) != null && !bl.isEmpty()) {
                String[] bls = bl.split(",");
                Collections.addAll(this.blackListedConfEntries, bls);
            }
        }
        return this.blackListedConfEntries.contains(name);
    }

    void addJobConfToEnvironment(Configuration conf, Map<String, String> env) {
        for (Map.Entry en : conf) {
            String name = (String)en.getKey();
            if (this.blackListed(conf, name)) continue;
            String value = conf.get(name);
            name = this.safeEnvVarName(name);
            boolean truncate = conf.getBoolean(HiveConf.ConfVars.HIVESCRIPTTRUNCATEENV.toString(), false);
            value = this.safeEnvVarValue(value, name, truncate);
            env.put(name, value);
        }
    }

    protected ScriptOperator() {
    }

    public ScriptOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.firstRow = true;
        this.statsMap.put(Counter.DESERIALIZE_ERRORS.toString(), this.deserialize_error_count);
        this.statsMap.put(Counter.SERIALIZE_ERRORS.toString(), this.serialize_error_count);
        try {
            this.hconf = hconf;
            this.scriptOutputDeserializer = ((ScriptDesc)this.conf).getScriptOutputInfo().getDeserializerClass().newInstance();
            SerDeUtils.initializeSerDe(this.scriptOutputDeserializer, hconf, ((ScriptDesc)this.conf).getScriptOutputInfo().getProperties(), null);
            this.scriptInputSerializer = (Serializer)((Object)((ScriptDesc)this.conf).getScriptInputInfo().getDeserializerClass().newInstance());
            this.scriptInputSerializer.initialize(hconf, ((ScriptDesc)this.conf).getScriptInputInfo().getProperties());
            this.outputObjInspector = this.scriptOutputDeserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new HiveException(ErrorMsg.SCRIPT_INIT_ERROR.getErrorCodedMsg(), e);
        }
    }

    boolean isBrokenPipeException(IOException e) {
        return e.getMessage().equalsIgnoreCase(IO_EXCEPTION_BROKEN_PIPE_STRING) || e.getMessage().equalsIgnoreCase(IO_EXCEPTION_STREAM_CLOSED);
    }

    boolean allowPartialConsumption() {
        return HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.ALLOWPARTIALCONSUMP);
    }

    void displayBrokenPipeInfo() {
        if (this.isLogInfoEnabled) {
            this.LOG.info("The script did not consume all input data. This is considered as an error.");
            this.LOG.info("set " + HiveConf.ConfVars.ALLOWPARTIALCONSUMP.toString() + "=true; to ignore it.");
        }
    }

    @Override
    public void setInputContext(String tableName, String partitionName) {
        this.tableName = tableName;
        this.partitionName = partitionName;
        super.setInputContext(tableName, partitionName);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (this.firstRow) {
            this.firstRow = false;
            SparkConf sparkConf = null;
            try {
                String master;
                String[] cmdArgs = ScriptOperator.splitArgs(((ScriptDesc)this.conf).getScriptCmd());
                String prog = cmdArgs[0];
                File currentDir = new File(".").getAbsoluteFile();
                if (!new File(prog).isAbsolute()) {
                    File f;
                    PathFinder finder = new PathFinder("PATH");
                    finder.prependPathComponent(currentDir.toString());
                    if (HiveConf.getVar(this.hconf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
                        sparkConf = SparkEnv.get().conf();
                        finder.prependPathComponent(SparkFiles.getRootDirectory());
                    }
                    if ((f = finder.getAbsolutePath(prog)) != null) {
                        cmdArgs[0] = f.getAbsolutePath();
                    }
                    f = null;
                }
                String[] wrappedCmdArgs = this.addWrapper(cmdArgs);
                if (this.isLogInfoEnabled) {
                    this.LOG.info("Executing " + Arrays.asList(wrappedCmdArgs));
                    this.LOG.info("tablename=" + this.tableName);
                    this.LOG.info("partname=" + this.partitionName);
                    this.LOG.info("alias=" + this.alias);
                }
                ProcessBuilder pb = new ProcessBuilder(wrappedCmdArgs);
                Map<String, String> env = pb.environment();
                this.addJobConfToEnvironment(this.hconf, env);
                env.put(this.safeEnvVarName(HiveConf.ConfVars.HIVEALIAS.varname), String.valueOf(this.alias));
                String idEnvVarName = HiveConf.getVar(this.hconf, HiveConf.ConfVars.HIVESCRIPTIDENVVAR);
                String idEnvVarVal = this.getOperatorId();
                env.put(this.safeEnvVarName(idEnvVarName), idEnvVarVal);
                if (sparkConf != null && ((master = sparkConf.get("spark.master")).equals("local") || master.startsWith("local["))) {
                    pb.directory(new File(SparkFiles.getRootDirectory()));
                }
                this.scriptPid = pb.start();
                DataOutputStream scriptOut = new DataOutputStream(new BufferedOutputStream(this.scriptPid.getOutputStream()));
                DataInputStream scriptIn = new DataInputStream(new BufferedInputStream(this.scriptPid.getInputStream()));
                DataInputStream scriptErr = new DataInputStream(new BufferedInputStream(this.scriptPid.getErrorStream()));
                this.scriptOutWriter = ((ScriptDesc)this.conf).getInRecordWriterClass().newInstance();
                this.scriptOutWriter.initialize(scriptOut, this.hconf);
                RecordReader scriptOutputReader = ((ScriptDesc)this.conf).getOutRecordReaderClass().newInstance();
                scriptOutputReader.initialize(scriptIn, this.hconf, ((ScriptDesc)this.conf).getScriptOutputInfo().getProperties());
                this.outThread = new StreamThread(scriptOutputReader, new OutputStreamProcessor(this.scriptOutputDeserializer.getObjectInspector()), "OutputProcessor");
                RecordReader scriptErrReader = ((ScriptDesc)this.conf).getErrRecordReaderClass().newInstance();
                scriptErrReader.initialize(scriptErr, this.hconf, ((ScriptDesc)this.conf).getScriptErrInfo().getProperties());
                this.errThread = new StreamThread(scriptErrReader, new ErrorStreamProcessor(HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.SCRIPTERRORLIMIT)), "ErrorProcessor");
                if (HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVESCRIPTAUTOPROGRESS)) {
                    this.autoProgressor = new AutoProgressor(this.getClass().getName(), this.reporter, Utilities.getDefaultNotificationInterval(this.hconf), HiveConf.getTimeVar(this.hconf, HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT, TimeUnit.MILLISECONDS));
                    this.autoProgressor.go();
                }
                this.outThread.start();
                this.errThread.start();
            }
            catch (Exception e2) {
                throw new HiveException(ErrorMsg.SCRIPT_INIT_ERROR.getErrorCodedMsg(), e2);
            }
        }
        if (this.scriptError != null) {
            throw new HiveException(ErrorMsg.SCRIPT_GENERIC_ERROR.getErrorCodedMsg(), this.scriptError);
        }
        try {
            Writable res = this.scriptInputSerializer.serialize(row, this.inputObjInspectors[tag]);
            this.scriptOutWriter.write(res);
        }
        catch (SerDeException e) {
            this.LOG.error("Error in serializing the row: " + e.getMessage());
            this.scriptError = e;
            this.serialize_error_count.set(this.serialize_error_count.get() + 1L);
            throw new HiveException(e);
        }
        catch (IOException e) {
            if (this.isBrokenPipeException(e) && this.allowPartialConsumption()) {
                try {
                    this.scriptPid.waitFor();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                try {
                    if (this.outThread != null) {
                        this.outThread.join(0L);
                    }
                }
                catch (Exception e2) {
                    this.LOG.warn("Exception in closing outThread: " + StringUtils.stringifyException((Throwable)e2));
                }
                this.setDone(true);
                this.LOG.warn("Got broken pipe during write: ignoring exception and setting operator to done");
            }
            this.LOG.error("Error in writing to script: " + e.getMessage());
            if (this.isBrokenPipeException(e)) {
                this.displayBrokenPipeInfo();
            }
            this.scriptError = e;
            throw new HiveException(ErrorMsg.SCRIPT_IO_ERROR.getErrorCodedMsg(), e);
        }
    }

    @Override
    public void close(boolean abort) throws HiveException {
        boolean new_abort = abort;
        if (!abort) {
            if (this.scriptError != null) {
                throw new HiveException(ErrorMsg.SCRIPT_GENERIC_ERROR.getErrorCodedMsg(), this.scriptError);
            }
            try {
                try {
                    if (this.scriptOutWriter != null) {
                        this.scriptOutWriter.close();
                    }
                }
                catch (IOException e) {
                    if (this.isBrokenPipeException(e) && this.allowPartialConsumption()) {
                        this.LOG.warn("Got broken pipe: ignoring exception");
                    }
                    if (this.isBrokenPipeException(e)) {
                        this.displayBrokenPipeInfo();
                    }
                    throw e;
                }
                int exitVal = 0;
                if (this.scriptPid != null) {
                    exitVal = this.scriptPid.waitFor();
                }
                if (exitVal != 0) {
                    this.LOG.error("Script failed with code " + exitVal);
                    new_abort = true;
                }
            }
            catch (IOException e) {
                this.LOG.error("Got ioexception: " + e.getMessage());
                e.printStackTrace();
                new_abort = true;
            }
            catch (InterruptedException e) {}
        } else {
            try {
                final Thread mythread = Thread.currentThread();
                Timer timer = new Timer(true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        mythread.interrupt();
                    }
                }, 1000L);
                int exitVal = 0;
                if (this.scriptPid != null) {
                    this.scriptPid.waitFor();
                }
                timer.cancel();
                this.LOG.error("Script exited with code " + exitVal);
            }
            catch (InterruptedException e) {
                this.LOG.error("Script has not exited yet. It will be killed.");
            }
        }
        try {
            if (this.outThread != null) {
                this.outThread.join(0L);
            }
        }
        catch (Exception e) {
            this.LOG.warn("Exception in closing outThread: " + StringUtils.stringifyException((Throwable)e));
        }
        try {
            if (this.errThread != null) {
                this.errThread.join(0L);
            }
        }
        catch (Exception e) {
            this.LOG.warn("Exception in closing errThread: " + StringUtils.stringifyException((Throwable)e));
        }
        try {
            if (this.scriptPid != null) {
                this.scriptPid.destroy();
            }
        }
        catch (Exception e) {
            this.LOG.warn("Exception in destroying scriptPid: " + StringUtils.stringifyException((Throwable)e));
        }
        super.close(new_abort);
        if (new_abort && !abort) {
            throw new HiveException(ErrorMsg.SCRIPT_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    protected String[] addWrapper(String[] inArgs) {
        int i;
        String wrapper = HiveConf.getVar(this.hconf, HiveConf.ConfVars.SCRIPTWRAPPER);
        if (wrapper == null) {
            return inArgs;
        }
        String[] wrapComponents = ScriptOperator.splitArgs(wrapper);
        int totallength = wrapComponents.length + inArgs.length;
        String[] finalArgv = new String[totallength];
        for (i = 0; i < wrapComponents.length; ++i) {
            finalArgv[i] = wrapComponents[i];
        }
        for (i = 0; i < inArgs.length; ++i) {
            finalArgv[wrapComponents.length + i] = inArgs[i];
        }
        return finalArgv;
    }

    public static String[] splitArgs(String args) {
        boolean OUTSIDE = true;
        int SINGLEQ = 2;
        int DOUBLEQ = 3;
        ArrayList<String> argList = new ArrayList<String>();
        char[] ch = args.toCharArray();
        int clen = ch.length;
        int state = 1;
        int argstart = 0;
        for (int c = 0; c <= clen; ++c) {
            boolean last = c == clen;
            int lastState = state;
            boolean endToken = false;
            if (!last) {
                if (ch[c] == '\'') {
                    if (state == 1) {
                        state = 2;
                    } else if (state == 2) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == '\"') {
                    if (state == 1) {
                        state = 3;
                    } else if (state == 3) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == ' ' && state == 1) {
                    endToken = true;
                }
            }
            if (!last && !endToken) continue;
            if (c != argstart) {
                String a = args.substring(argstart, c);
                argList.add(a);
            }
            argstart = c + 1;
            lastState = state;
        }
        return argList.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return ScriptOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SCR";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SCRIPT;
    }

    class StreamThread
    extends Thread {
        RecordReader in;
        StreamProcessor proc;
        String name;

        StreamThread(RecordReader in, StreamProcessor proc, String name) {
            this.in = in;
            this.proc = proc;
            this.name = name;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long bytes;
                Writable row = this.in.createRow();
                while ((bytes = (long)this.in.next(row)) > 0L) {
                    this.proc.processLine(row);
                }
                if (ScriptOperator.this.isLogInfoEnabled) {
                    ScriptOperator.this.LOG.info("StreamThread " + this.name + " done");
                }
            }
            catch (Throwable th) {
                ScriptOperator.this.scriptError = th;
                ScriptOperator.this.LOG.warn("Exception in StreamThread.run(): " + th.getMessage() + "\nCause: " + th.getCause());
                ScriptOperator.this.LOG.warn(StringUtils.stringifyException((Throwable)th));
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (Exception e) {
                    ScriptOperator.this.LOG.warn(this.name + ": error in closing ..");
                    ScriptOperator.this.LOG.warn(StringUtils.stringifyException((Throwable)e));
                }
                try {
                    if (null != this.proc) {
                        this.proc.close();
                    }
                }
                catch (Exception e) {
                    ScriptOperator.this.LOG.warn(": error in closing .." + StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    class ErrorStreamProcessor
    implements StreamProcessor {
        private long bytesCopied = 0L;
        private final long maxBytes;
        private long lastReportTime;
        private CounterStatusProcessor counterStatus;

        public ErrorStreamProcessor(int maxBytes) {
            this.maxBytes = maxBytes;
            this.lastReportTime = 0L;
            if (HiveConf.getBoolVar(ScriptOperator.this.hconf, HiveConf.ConfVars.STREAMREPORTERENABLED)) {
                this.counterStatus = new CounterStatusProcessor(ScriptOperator.this.hconf, ScriptOperator.this.reporter);
            }
        }

        @Override
        public void processLine(Writable line) throws HiveException {
            String stringLine = line.toString();
            int len = 0;
            if (line instanceof Text) {
                len = ((Text)line).getLength();
            } else if (line instanceof BytesWritable) {
                len = ((BytesWritable)line).getSize();
            }
            long now = System.currentTimeMillis();
            if (now - this.lastReportTime > 60000L && ScriptOperator.this.reporter != null) {
                if (ScriptOperator.this.isLogInfoEnabled) {
                    ScriptOperator.this.LOG.info("ErrorStreamProcessor calling reporter.progress()");
                }
                this.lastReportTime = now;
                ScriptOperator.this.reporter.progress();
            }
            if (ScriptOperator.this.reporter != null && this.counterStatus != null && this.counterStatus.process(stringLine)) {
                return;
            }
            if (this.maxBytes < 0L || this.bytesCopied < this.maxBytes) {
                System.err.println(stringLine);
            }
            if (this.bytesCopied < this.maxBytes && this.bytesCopied + (long)len >= this.maxBytes) {
                System.err.println("Operator " + ScriptOperator.this.id + " " + ScriptOperator.this.getName() + ": exceeding stderr limit of " + this.maxBytes + " bytes, will truncate stderr messages.");
            }
            this.bytesCopied += (long)len;
        }

        @Override
        public void close() {
        }
    }

    class CounterStatusProcessor {
        private final String reporterPrefix;
        private final String counterPrefix;
        private final String statusPrefix;
        private final Reporter reporter;

        CounterStatusProcessor(Configuration hconf, Reporter reporter) {
            this.reporterPrefix = HiveConf.getVar(hconf, HiveConf.ConfVars.STREAMREPORTERPERFIX);
            this.counterPrefix = this.reporterPrefix + "counter:";
            this.statusPrefix = this.reporterPrefix + "status:";
            this.reporter = reporter;
        }

        private boolean process(String line) {
            if (line.startsWith(this.reporterPrefix)) {
                if (line.startsWith(this.counterPrefix)) {
                    this.incrCounter(line);
                }
                if (line.startsWith(this.statusPrefix)) {
                    this.setStatus(line);
                }
                return true;
            }
            return false;
        }

        private void incrCounter(String line) {
            String trimmedLine = line.substring(this.counterPrefix.length()).trim();
            String[] columns = trimmedLine.split(",");
            if (columns.length == 3) {
                try {
                    this.reporter.incrCounter(columns[0], columns[1], Long.parseLong(columns[2]));
                }
                catch (NumberFormatException e) {
                    ScriptOperator.this.LOG.warn("Cannot parse counter increment '" + columns[2] + "' from line " + line);
                }
            } else {
                ScriptOperator.this.LOG.warn("Cannot parse counter line: " + line);
            }
        }

        private void setStatus(String line) {
            this.reporter.setStatus(line.substring(this.statusPrefix.length()).trim());
        }
    }

    class OutputStreamProcessor
    implements StreamProcessor {
        Object row;
        ObjectInspector rowInspector;

        public OutputStreamProcessor(ObjectInspector rowInspector) {
            this.rowInspector = rowInspector;
        }

        @Override
        public void processLine(Writable line) throws HiveException {
            try {
                this.row = ScriptOperator.this.scriptOutputDeserializer.deserialize(line);
            }
            catch (SerDeException e) {
                ScriptOperator.this.deserialize_error_count.set(ScriptOperator.this.deserialize_error_count.get() + 1L);
                return;
            }
            ScriptOperator.this.forward(this.row, this.rowInspector);
        }

        @Override
        public void close() {
        }
    }

    static interface StreamProcessor {
        public void processLine(Writable var1) throws HiveException;

        public void close() throws HiveException;
    }

    public class PathFinder {
        String pathenv;
        String pathSep;
        String fileSep;

        public PathFinder(String envpath) {
            this.pathenv = System.getenv(envpath);
            this.pathSep = System.getProperty("path.separator");
            this.fileSep = System.getProperty("file.separator");
        }

        public void prependPathComponent(String str) {
            this.pathenv = str + this.pathSep + this.pathenv;
        }

        public File getAbsolutePath(String filename) {
            if (this.pathenv == null || this.pathSep == null || this.fileSep == null) {
                return null;
            }
            int val = -1;
            String classvalue = this.pathenv + this.pathSep;
            while ((val = classvalue.indexOf(this.pathSep)) >= 0 && classvalue.length() > 0) {
                String entry = classvalue.substring(0, val).trim();
                File f = new File(entry);
                try {
                    if (f.isDirectory()) {
                        f = new File(entry + this.fileSep + filename);
                    }
                    if (f.isFile() && f.canRead()) {
                        return f;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                classvalue = classvalue.substring(val + 1).trim();
            }
            return null;
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS,
        SERIALIZE_ERRORS;

    }
}

