/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="char", value="_FUNC_(str) - convert n where n : [0, 256) into the ascii equivalent as a varchar.If n is less than 0 return the empty string. If n > 256, return _FUNC_(n % 256).", extended="Example:\n  > SELECT _FUNC_('48') FROM src LIMIT 1;\n  '0'\n  > SELECT _FUNC_('65') FROM src LIMIT 1;\n  'A'")
public class UDFChr
extends UDF {
    private final Text result = new Text();
    final String nulString = String.valueOf('\u0000');

    public Text evaluate(LongWritable n) {
        if (n == null) {
            return null;
        }
        return this.evaluateInternal(n.get());
    }

    public Text evaluate(DoubleWritable n) {
        if (n == null) {
            return null;
        }
        return this.evaluateInternal(n.get());
    }

    private Text evaluateInternal(long n) {
        if (n == 0L) {
            this.result.set(this.nulString);
            return this.result;
        }
        if (n < 0L) {
            this.result.set("");
            return this.result;
        }
        return this.evaluateInternal((short)n);
    }

    private Text evaluateInternal(double n) {
        if (n == 0.0) {
            this.result.set(this.nulString);
            return this.result;
        }
        if (n < 0.0) {
            this.result.set("");
            return this.result;
        }
        return this.evaluateInternal((short)n);
    }

    private Text evaluateInternal(short n) {
        if (n > 255) {
            n = (short)(n % 256);
        }
        if (n == 0) {
            this.result.set(this.nulString);
            return this.result;
        }
        if (n < 0) {
            this.result.set("");
            return this.result;
        }
        this.result.set(String.valueOf((char)n));
        return this.result;
    }
}

