/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreChecker;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.MsckInfo;
import org.apache.hadoop.hive.metastore.MsckPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreException;
import org.apache.hadoop.hive.metastore.utils.RetryUtilities;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Msck {
    public static final Logger LOG = LoggerFactory.getLogger(Msck.class);
    public static final int separator = 9;
    private static final int terminator = 10;
    private boolean acquireLock;
    private boolean deleteData;
    private Configuration conf;
    private IMetaStoreClient msc;

    public Msck(boolean acquireLock, boolean deleteData) {
        this.acquireLock = acquireLock;
        this.deleteData = deleteData;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void init(Configuration conf) throws MetaException {
        if (this.msc == null) {
            Configuration metastoreConf = MetastoreConf.newMetastoreConf();
            metastoreConf.addResource(conf);
            metastoreConf.set(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), MsckPartitionExpressionProxy.class.getCanonicalName());
            this.setConf(metastoreConf);
            this.msc = new HiveMetaStoreClient(metastoreConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int repair(MsckInfo msckInfo) {
        int ret;
        block97: {
            long partitionExpirySeconds;
            long txnId;
            boolean success;
            String qualifiedTableName;
            ArrayList<String> repairOutput;
            CheckResult result;
            block94: {
                result = new CheckResult();
                repairOutput = new ArrayList<String>();
                qualifiedTableName = null;
                success = false;
                txnId = -1L;
                ret = 0;
                partitionExpirySeconds = msckInfo.getPartitionExpirySeconds();
                Table table = this.getMsc().getTable(msckInfo.getCatalogName(), msckInfo.getDbName(), msckInfo.getTableName());
                qualifiedTableName = Warehouse.getCatalogQualifiedTableName(table);
                HiveMetaStoreChecker checker = new HiveMetaStoreChecker(this.getMsc(), this.getConf(), partitionExpirySeconds);
                checker.checkMetastore(msckInfo.getCatalogName(), msckInfo.getDbName(), msckInfo.getTableName(), msckInfo.getPartSpecs(), result);
                Set<CheckResult.PartitionResult> partsNotInMs = result.getPartitionsNotInMs();
                Set<CheckResult.PartitionResult> partsNotInFs = result.getPartitionsNotOnFs();
                Set<CheckResult.PartitionResult> expiredPartitions = result.getExpiredPartitions();
                int totalPartsToFix = partsNotInMs.size() + partsNotInFs.size() + expiredPartitions.size();
                boolean lockRequired = totalPartsToFix > 0 && msckInfo.isRepairPartitions() && (msckInfo.isAddPartitions() || msckInfo.isDropPartitions());
                LOG.info("{} - #partsNotInMs: {} #partsNotInFs: {} #expiredPartitions: {} lockRequired: {} (R: {} A: {} D: {})", new Object[]{qualifiedTableName, partsNotInMs.size(), partsNotInFs.size(), expiredPartitions.size(), lockRequired, msckInfo.isRepairPartitions(), msckInfo.isAddPartitions(), msckInfo.isDropPartitions()});
                if (msckInfo.isRepairPartitions()) {
                    int batchSize;
                    if (this.acquireLock && lockRequired && table.getParameters() != null && MetaStoreUtils.isTransactionalTable(table.getParameters())) {
                        long lockId;
                        LockRequest lockRequest = this.createLockRequest(msckInfo.getDbName(), msckInfo.getTableName());
                        txnId = lockRequest.getTxnid();
                        try {
                            LockResponse res = this.getMsc().lock(lockRequest);
                            if (res.getState() != LockState.ACQUIRED) {
                                throw new MetastoreException("Unable to acquire lock(X) on " + qualifiedTableName);
                            }
                            lockId = res.getLockid();
                        }
                        catch (TException e) {
                            throw new MetastoreException("Unable to acquire lock(X) on " + qualifiedTableName, e);
                        }
                        LOG.info("Acquired lock(X) on {}. LockId: {}", (Object)qualifiedTableName, (Object)lockId);
                    }
                    int maxRetries = MetastoreConf.getIntVar(this.getConf(), MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_MAX_RETRIES);
                    int decayingFactor = 2;
                    if (msckInfo.isAddPartitions() && !partsNotInMs.isEmpty()) {
                        boolean doSkip;
                        batchSize = MetastoreConf.getIntVar(this.getConf(), MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_SIZE);
                        if (batchSize == 0) {
                            batchSize = partsNotInMs.size();
                        }
                        AbstractList<String> vals = null;
                        String settingStr = MetastoreConf.getVar(this.getConf(), MetastoreConf.ConfVars.MSCK_PATH_VALIDATION);
                        boolean doValidate = !"ignore".equals(settingStr);
                        boolean bl = doSkip = doValidate && "skip".equals(settingStr);
                        if (doValidate) {
                            Iterator<CheckResult.PartitionResult> iter = partsNotInMs.iterator();
                            while (iter.hasNext()) {
                                CheckResult.PartitionResult part = iter.next();
                                try {
                                    vals = Warehouse.makeValsFromName(part.getPartitionName(), vals);
                                }
                                catch (MetaException ex) {
                                    throw new MetastoreException(ex);
                                }
                                for (String val : vals) {
                                    String escapedPath = FileUtils.escapePathName(val);
                                    assert (escapedPath != null);
                                    if (escapedPath.equals(val)) continue;
                                    String errorMsg = "Repair: Cannot add partition " + msckInfo.getTableName() + ':' + part.getPartitionName() + " due to invalid characters in the name";
                                    if (doSkip) {
                                        repairOutput.add(errorMsg);
                                        iter.remove();
                                        continue;
                                    }
                                    throw new MetastoreException(errorMsg);
                                }
                            }
                        }
                        try {
                            this.createPartitionsInBatches(this.getMsc(), repairOutput, partsNotInMs, table, batchSize, decayingFactor, maxRetries);
                        }
                        catch (Exception e) {
                            throw new MetastoreException(e);
                        }
                    }
                    if (!(!msckInfo.isDropPartitions() || partsNotInFs.isEmpty() && expiredPartitions.isEmpty())) {
                        batchSize = MetastoreConf.getIntVar(this.getConf(), MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_SIZE);
                        if (batchSize == 0) {
                            batchSize = partsNotInFs.size() + expiredPartitions.size();
                        }
                        try {
                            this.dropPartitionsInBatches(this.getMsc(), repairOutput, partsNotInFs, expiredPartitions, table, batchSize, decayingFactor, maxRetries);
                        }
                        catch (Exception e) {
                            throw new MetastoreException(e);
                        }
                    }
                }
                success = true;
                if (msckInfo.getResFile() == null) break block94;
                BufferedWriter resultOut = null;
                try {
                    Path resFile = new Path(msckInfo.getResFile());
                    FileSystem fs = resFile.getFileSystem(this.getConf());
                    resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                    boolean firstWritten = false;
                    firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                    firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                    firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                    firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                    firstWritten |= this.writeMsckResult(result.getExpiredPartitions(), "Expired partitions (retention period: " + partitionExpirySeconds + "s) :", resultOut, firstWritten);
                    Collections.sort(repairOutput);
                    for (String rout : repairOutput) {
                        if (firstWritten) {
                            resultOut.write(10);
                        } else {
                            firstWritten = true;
                        }
                        resultOut.write(rout);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to save metacheck output: ", (Throwable)e);
                    ret = 1;
                }
                finally {
                    if (resultOut != null) {
                        try {
                            resultOut.close();
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to close output file: ", (Throwable)e);
                            ret = 1;
                        }
                    }
                }
            }
            LOG.info("Tables not in metastore: {}", result.getTablesNotInMs());
            LOG.info("Tables missing on filesystem: {}", result.getTablesNotOnFs());
            LOG.info("Partitions not in metastore: {}", result.getPartitionsNotInMs());
            LOG.info("Partitions missing from filesystem: {}", result.getPartitionsNotOnFs());
            LOG.info("Expired partitions: {}", result.getExpiredPartitions());
            if (this.acquireLock && txnId > 0L) {
                if (success) {
                    try {
                        LOG.info("txnId: {} succeeded. Committing..", (Object)txnId);
                        this.getMsc().commitTxn(txnId);
                    }
                    catch (Exception e) {
                        LOG.warn("Error while committing txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e});
                        ret = 1;
                    }
                } else {
                    try {
                        LOG.info("txnId: {} failed. Aborting..", (Object)txnId);
                        this.getMsc().abortTxns(Lists.newArrayList(txnId));
                    }
                    catch (Exception e) {
                        LOG.warn("Error while aborting txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e});
                        ret = 1;
                    }
                }
            }
            if (this.getMsc() != null) {
                this.getMsc().close();
                this.msc = null;
            }
            break block97;
            catch (Exception e) {
                block95: {
                    LOG.warn("Failed to run metacheck: ", (Throwable)e);
                    success = false;
                    ret = 1;
                    if (msckInfo.getResFile() == null) break block95;
                    BufferedWriter resultOut = null;
                    try {
                        Path resFile = new Path(msckInfo.getResFile());
                        FileSystem fs = resFile.getFileSystem(this.getConf());
                        resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                        boolean firstWritten = false;
                        firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                        firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                        firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                        firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                        firstWritten |= this.writeMsckResult(result.getExpiredPartitions(), "Expired partitions (retention period: " + partitionExpirySeconds + "s) :", resultOut, firstWritten);
                        Collections.sort(repairOutput);
                        for (String rout : repairOutput) {
                            if (firstWritten) {
                                resultOut.write(10);
                            } else {
                                firstWritten = true;
                            }
                            resultOut.write(rout);
                        }
                    }
                    catch (IOException e2) {
                        LOG.warn("Failed to save metacheck output: ", (Throwable)e2);
                        ret = 1;
                    }
                    finally {
                        if (resultOut != null) {
                            try {
                                resultOut.close();
                            }
                            catch (IOException e3) {
                                LOG.warn("Failed to close output file: ", (Throwable)e3);
                                ret = 1;
                            }
                        }
                    }
                }
                LOG.info("Tables not in metastore: {}", result.getTablesNotInMs());
                LOG.info("Tables missing on filesystem: {}", result.getTablesNotOnFs());
                LOG.info("Partitions not in metastore: {}", result.getPartitionsNotInMs());
                LOG.info("Partitions missing from filesystem: {}", result.getPartitionsNotOnFs());
                LOG.info("Expired partitions: {}", result.getExpiredPartitions());
                if (this.acquireLock && txnId > 0L) {
                    if (success) {
                        try {
                            LOG.info("txnId: {} succeeded. Committing..", (Object)txnId);
                            this.getMsc().commitTxn(txnId);
                        }
                        catch (Exception e4) {
                            LOG.warn("Error while committing txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e4});
                            ret = 1;
                        }
                    } else {
                        try {
                            LOG.info("txnId: {} failed. Aborting..", (Object)txnId);
                            this.getMsc().abortTxns(Lists.newArrayList(txnId));
                        }
                        catch (Exception e5) {
                            LOG.warn("Error while aborting txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e5});
                            ret = 1;
                        }
                    }
                }
                if (this.getMsc() != null) {
                    this.getMsc().close();
                    this.msc = null;
                }
                catch (Throwable throwable) {
                    if (msckInfo.getResFile() != null) {
                        BufferedWriter resultOut = null;
                        try {
                            Path resFile = new Path(msckInfo.getResFile());
                            FileSystem fs = resFile.getFileSystem(this.getConf());
                            resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                            boolean firstWritten = false;
                            firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                            firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                            firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                            firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                            firstWritten |= this.writeMsckResult(result.getExpiredPartitions(), "Expired partitions (retention period: " + partitionExpirySeconds + "s) :", resultOut, firstWritten);
                            Collections.sort(repairOutput);
                            for (String rout : repairOutput) {
                                if (firstWritten) {
                                    resultOut.write(10);
                                } else {
                                    firstWritten = true;
                                }
                                resultOut.write(rout);
                            }
                        }
                        catch (IOException e6) {
                            LOG.warn("Failed to save metacheck output: ", (Throwable)e6);
                            ret = 1;
                        }
                        finally {
                            if (resultOut != null) {
                                try {
                                    resultOut.close();
                                }
                                catch (IOException e7) {
                                    LOG.warn("Failed to close output file: ", (Throwable)e7);
                                    ret = 1;
                                }
                            }
                        }
                    }
                    LOG.info("Tables not in metastore: {}", result.getTablesNotInMs());
                    LOG.info("Tables missing on filesystem: {}", result.getTablesNotOnFs());
                    LOG.info("Partitions not in metastore: {}", result.getPartitionsNotInMs());
                    LOG.info("Partitions missing from filesystem: {}", result.getPartitionsNotOnFs());
                    LOG.info("Expired partitions: {}", result.getExpiredPartitions());
                    if (this.acquireLock && txnId > 0L) {
                        if (success) {
                            try {
                                LOG.info("txnId: {} succeeded. Committing..", (Object)txnId);
                                this.getMsc().commitTxn(txnId);
                            }
                            catch (Exception e8) {
                                LOG.warn("Error while committing txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e8});
                                ret = 1;
                            }
                        } else {
                            try {
                                LOG.info("txnId: {} failed. Aborting..", (Object)txnId);
                                this.getMsc().abortTxns(Lists.newArrayList(txnId));
                            }
                            catch (Exception e9) {
                                LOG.warn("Error while aborting txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e9});
                                ret = 1;
                            }
                        }
                    }
                    if (this.getMsc() != null) {
                        this.getMsc().close();
                        this.msc = null;
                    }
                    throw throwable;
                }
            }
        }
        return ret;
    }

    private LockRequest createLockRequest(String dbName, String tableName) throws TException {
        UserGroupInformation loggedInUser = null;
        try {
            loggedInUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.warn("Unable to get logged in user via UGI. err: {}", (Object)e.getMessage());
        }
        String username = loggedInUser == null ? System.getProperty("user.name") : loggedInUser.getShortUserName();
        long txnId = this.getMsc().openTxn(username);
        String agentInfo = Thread.currentThread().getName();
        LockRequestBuilder requestBuilder = new LockRequestBuilder(agentInfo);
        requestBuilder.setUser(username);
        requestBuilder.setTransactionId(txnId);
        LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setDbName(dbName).setTableName(tableName).setIsTransactional(true).setExclusive().setOperationType(DataOperationType.NO_TXN);
        requestBuilder.addLockComponent(lockCompBuilder.build());
        LOG.info("Created lock(X) request with info - user: {} txnId: {} agentInfo: {} dbName: {} tableName: {}", new Object[]{username, txnId, agentInfo, dbName, tableName});
        return requestBuilder.build();
    }

    public IMetaStoreClient getMsc() {
        return this.msc;
    }

    @VisibleForTesting
    public void createPartitionsInBatches(final IMetaStoreClient metastoreClient, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInMs, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String addMsgFormat = "Repair: Added partition to metastore " + table.getTableName() + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInMs);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws MetastoreException {
                try {
                    while (!batchWork.isEmpty()) {
                        ArrayList<Partition> partsToAdd = new ArrayList<Partition>();
                        int currentBatchSize = size;
                        ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                        ArrayList<String> addMsgs = new ArrayList<String>(currentBatchSize);
                        for (CheckResult.PartitionResult part : batchWork) {
                            if (currentBatchSize == 0) break;
                            Path tablePath = MetaStoreUtils.getPath(table);
                            if (tablePath == null) continue;
                            LinkedHashMap<String, String> partSpec = Warehouse.makeSpecFromName(part.getPartitionName());
                            Path location = new Path(tablePath, Warehouse.makePartPath(partSpec));
                            Partition partition = MetaStoreUtils.createMetaPartitionObject(table, partSpec, location);
                            partsToAdd.add(partition);
                            lastBatch.add(part);
                            addMsgs.add(String.format(addMsgFormat, part.getPartitionName()));
                            --currentBatchSize;
                        }
                        metastoreClient.add_partitions(partsToAdd, true, false);
                        batchWork.removeAll(lastBatch);
                        repairOutput.addAll(addMsgs);
                    }
                    return null;
                }
                catch (TException e) {
                    throw new MetastoreException(e);
                }
            }
        }.run();
    }

    public static String makePartExpr(Map<String, String> spec) throws MetaException {
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() == 0) {
                throw new MetaException("Partition spec is incorrect. " + spec);
            }
            if (i > 0) {
                suffixBuf.append(" AND ");
            }
            suffixBuf.append(Warehouse.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append("'").append(Warehouse.escapePathName(e.getValue())).append("'");
            ++i;
        }
        return suffixBuf.toString();
    }

    @VisibleForTesting
    public void dropPartitionsInBatches(final IMetaStoreClient metastoreClient, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInFs, Set<CheckResult.PartitionResult> expiredPartitions, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String dropMsgFormat = "Repair: Dropped partition from metastore " + Warehouse.getCatalogQualifiedTableName(table) + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInFs);
        if (expiredPartitions != null && !expiredPartitions.isEmpty()) {
            batchWork.addAll(expiredPartitions);
        }
        final PartitionDropOptions dropOptions = new PartitionDropOptions().deleteData(this.deleteData).ifExists(true);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws MetastoreException {
                try {
                    while (!batchWork.isEmpty()) {
                        int currentBatchSize = size;
                        ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                        ArrayList<String> dropMsgs = new ArrayList<String>(currentBatchSize);
                        ArrayList<String> dropParts = new ArrayList<String>(currentBatchSize);
                        for (CheckResult.PartitionResult part : batchWork) {
                            if (currentBatchSize == 0) break;
                            dropParts.add(part.getPartitionName());
                            lastBatch.add(part);
                            dropMsgs.add(String.format(dropMsgFormat, part.getPartitionName()));
                            --currentBatchSize;
                        }
                        List<Pair<Integer, byte[]>> partExprs = this.getPartitionExpr(dropParts);
                        metastoreClient.dropPartitions(table.getCatName(), table.getDbName(), table.getTableName(), partExprs, dropOptions);
                        batchWork.removeAll(lastBatch);
                        repairOutput.addAll(dropMsgs);
                    }
                    return null;
                }
                catch (TException e) {
                    throw new MetastoreException(e);
                }
            }

            private List<Pair<Integer, byte[]>> getPartitionExpr(List<String> parts) throws MetaException {
                ArrayList<Pair<Integer, byte[]>> expr = new ArrayList<Pair<Integer, byte[]>>(parts.size());
                for (int i = 0; i < parts.size(); ++i) {
                    String partName = parts.get(i);
                    LinkedHashMap<String, String> partSpec = Warehouse.makeSpecFromName(partName);
                    String partExpr = Msck.makePartExpr(partSpec);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Generated partExpr: {} for partName: {}", (Object)partExpr, (Object)partName);
                    }
                    expr.add(Pair.of(i, partExpr.getBytes(StandardCharsets.UTF_8)));
                }
                return expr;
            }
        }.run();
    }

    private boolean writeMsckResult(Set<?> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object entry : result) {
                out.write(9);
                out.write(entry.toString());
            }
            return true;
        }
        return false;
    }
}

