/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsckPartitionExpressionProxy
implements PartitionExpressionProxy {
    private static final Logger LOG = LoggerFactory.getLogger(MsckPartitionExpressionProxy.class);

    @Override
    public String convertExprToFilter(byte[] exprBytes, String defaultPartitionName) throws MetaException {
        return new String(exprBytes, StandardCharsets.UTF_8);
    }

    @Override
    public boolean filterPartitionsByExpr(List<FieldSchema> partColumns, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        String[] parts;
        String partExpr = new String(expr, StandardCharsets.UTF_8);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Partition expr: {}", (Object)expr);
        }
        HashSet<String> partValueSet = new HashSet<String>();
        for (String part : parts = partExpr.split(" AND ")) {
            String[] colAndValue = part.split("=");
            String key = FileUtils.unescapePathName(colAndValue[0]);
            String value = FileUtils.unescapePathName(colAndValue[1].substring(1, colAndValue[1].length() - 1));
            partValueSet.add(key + "=" + value);
        }
        ArrayList<String> partNamesSeq = new ArrayList<String>();
        for (String partition : partitionNames) {
            String[] partnames;
            boolean isMatch = true;
            for (String part : partnames = partition.split("/")) {
                if (partValueSet.contains(FileUtils.unescapePathName(part))) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            partNamesSeq.add(partition);
        }
        partitionNames.clear();
        partitionNames.addAll(partNamesSeq);
        LOG.info("The returned partition list is of size: {}", (Object)partitionNames.size());
        if (LOG.isDebugEnabled()) {
            for (String s : partitionNames) {
                LOG.debug("Matched partition: {}", (Object)s);
            }
        }
        return false;
    }

    @Override
    public FileMetadataExprType getMetadataType(String inputFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchArgument createSarg(byte[] expr) {
        throw new UnsupportedOperationException();
    }
}

