/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionProjectionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionProjectionEvaluator.class);
    private final boolean convertMapNullsToEmptyStrings;
    private final boolean isView;
    private final String includeParamKeyPattern;
    private final String excludeParamKeyPattern;
    private Set<String> projectionFields;
    private final ImmutableMap<String, MutivaluedFieldSetter> multiValuedFieldSetters = new ImmutableMap.Builder<String, PartitionValuesSetter>().put("values", new PartitionValuesSetter()).put("parameters", (PartitionValuesSetter)((Object)new PartitionParametersSetter())).put("sd.cols", (PartitionValuesSetter)((Object)new PartitionSDColsSetter())).put("sd.bucketCols", (PartitionValuesSetter)((Object)new PartitionSDBucketColsSetter())).put("sd.sortCols", (PartitionValuesSetter)((Object)new PartitionSortColsSetter())).put("sd.parameters", (PartitionValuesSetter)((Object)new PartitionSDParametersSetter())).put("sd.serdeInfo.parameters", (PartitionValuesSetter)((Object)new PartitionSerdeInfoParametersSetter())).put("sd.skewedInfo.skewedColNames", (PartitionValuesSetter)((Object)new PartitionSkewedColsNamesSetter())).put("sd.skewedInfo.skewedColValues", (PartitionValuesSetter)((Object)new PartitionSkewedColsValuesSetter())).put("sd.skewedInfo.skewedColValueLocationMaps", (PartitionValuesSetter)((Object)new PartitionSkewedColValLocationMapSetter())).build();
    private static final String PART_ID = "PART_ID";
    private static final String SD_ID = "SD_ID";
    private static final String SERDE_ID = "SERDE_ID";
    private static final String CD_ID = "CD_ID";
    private static final PartitionFieldNode partIdNode = new PartitionFieldNode("PART_ID");
    private static final PartitionFieldNode sdIdNode = new PartitionFieldNode("SD_ID");
    private static final PartitionFieldNode serdeIdNode = new PartitionFieldNode("SERDE_ID");
    private static final PartitionFieldNode cdIdNode = new PartitionFieldNode("CD_ID");
    private final ImmutableMap<String, String> fieldNameToTableName;
    private final Set<PartitionFieldNode> roots;
    private final String PARTITIONS;
    private final String SDS;
    private final String SERDES;
    private final String PARTITION_PARAMS;
    private final PersistenceManager pm;
    @VisibleForTesting
    static final String SD_PATTERN = "sd|sd\\.";
    @VisibleForTesting
    static final String SERDE_PATTERN = "sd\\.serdeInfo|sd\\.serdeInfo\\.";
    @VisibleForTesting
    static final String CD_PATTERN = "sd\\.cols|sd\\.cols\\.";
    private static final int SD_INDEX = 0;
    private static final int CD_INDEX = 1;
    private static final int SERDE_INDEX = 2;
    private static final int PART_INDEX = 3;
    private static final ImmutableMap<String, String> allPartitionSingleValuedFields = new ImmutableMap.Builder<String, String>().put("dbName", "table.database.name").put("tableName", "table.tableName").put("createTime", "createTime").put("lastAccessTime", "lastAccessTime").put("sd.location", "sd.location").put("sd.inputFormat", "sd.inputFormat").put("sd.outputFormat", "sd.outputFormat").put("sd.compressed", "sd.isCompressed").put("sd.numBuckets", "sd.numBuckets").put("sd.serdeInfo.name", "sd.serDeInfo.name").put("sd.serdeInfo.serializationLib", "sd.serDeInfo.serializationLib").put("sd.serdeInfo.description", "sd.serDeInfo.description").put("sd.serdeInfo.serializerClass", "sd.serDeInfo.serializerClass").put("sd.serdeInfo.deserializerClass", "sd.serDeInfo.deserializerClass").put("sd.serdeInfo.serdeType", "sd.serDeInfo.serdeType").put("catName", "table.database.catalogName").put("writeId", "writeId").build();
    private static final ImmutableSet<String> allPartitionMultiValuedFields = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add("values")).add("sd.cols.name")).add("sd.cols.type")).add("sd.cols.comment")).add("sd.serdeInfo.parameters")).add("sd.bucketCols")).add("sd.sortCols.col")).add("sd.sortCols.order")).add("sd.parameters")).add("sd.skewedInfo.skewedColNames")).add("sd.skewedInfo.skewedColValues")).add("sd.skewedInfo.skewedColValueLocationMaps")).add("parameters")).add("privileges.userPrivileges")).add("privileges.groupPrivileges")).add("privileges.rolePrivileges")).build();
    private static final ImmutableSet<String> allPartitionFields = ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)allPartitionSingleValuedFields.keySet())).addAll(allPartitionMultiValuedFields)).build();
    private static final String SPACE = " ";

    public PartitionProjectionEvaluator(PersistenceManager pm, ImmutableMap<String, String> fieldNameToTableName, List<String> projectionFields, boolean convertMapNullsToEmptyStrings, boolean isView, String includeParamKeyPattern, String excludeParamKeyPattern) throws MetaException {
        this.pm = pm;
        this.fieldNameToTableName = fieldNameToTableName;
        this.convertMapNullsToEmptyStrings = convertMapNullsToEmptyStrings;
        this.isView = isView;
        this.includeParamKeyPattern = includeParamKeyPattern;
        this.excludeParamKeyPattern = excludeParamKeyPattern;
        this.PARTITIONS = fieldNameToTableName.containsKey("PARTITIONS_TABLE_NAME") ? fieldNameToTableName.get("PARTITIONS_TABLE_NAME") : "PARTITIONS";
        this.SDS = fieldNameToTableName.containsKey("SDS_TABLE_NAME") ? fieldNameToTableName.get("SDS_TABLE_NAME") : "SDS";
        this.SERDES = fieldNameToTableName.containsKey("SERDES_TABLE_NAME") ? fieldNameToTableName.get("SERDES_TABLE_NAME") : "SERDES";
        this.PARTITION_PARAMS = fieldNameToTableName.containsKey("PARTITION_PARAMS") ? fieldNameToTableName.get("PARTITION_PARAMS") : "PARTITION_PARAMS";
        this.roots = this.parse(projectionFields);
        this.roots.add(partIdNode);
        if (this.find(SD_PATTERN)) {
            this.roots.add(sdIdNode);
        }
        if (this.find(SERDE_PATTERN)) {
            this.roots.add(serdeIdNode);
        }
        if (this.find(CD_PATTERN)) {
            this.roots.add(cdIdNode);
        }
    }

    @VisibleForTesting
    boolean find(String searchField) {
        Pattern p = Pattern.compile(searchField);
        for (PartitionFieldNode node : this.roots) {
            if (!PartitionProjectionEvaluator.find(node, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean find(PartitionFieldNode root, Pattern p) {
        if (root == null) {
            return false;
        }
        if (p.matcher(root.fieldName).matches()) {
            return true;
        }
        for (PartitionFieldNode child : root.children) {
            if (!PartitionProjectionEvaluator.find(child, p)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> expand(Collection<String> projectionList) throws MetaException {
        HashSet<String> result = new HashSet<String>();
        for (String projectedField : projectionList) {
            if (allPartitionFields.contains(projectedField)) {
                result.add(projectedField);
                continue;
            }
            boolean found = false;
            for (String partitionField : allPartitionFields) {
                if (!partitionField.startsWith(projectedField)) continue;
                LOG.debug("Found " + partitionField + " included within given projection field " + projectedField);
                result.add(partitionField);
                found = true;
            }
            if (found) continue;
            throw new MetaException("Invalid field name " + projectedField);
        }
        return result;
    }

    @VisibleForTesting
    Set<PartitionFieldNode> getRoots() {
        return this.roots;
    }

    private static void validate(Collection<String> projectionFields) throws MetaException {
        HashSet<String> verify = new HashSet<String>(projectionFields);
        verify.removeAll(allPartitionFields);
        if (verify.size() > 0) {
            throw new MetaException("Invalid partition fields in the projection spec" + Arrays.toString(verify.toArray(new String[verify.size()])));
        }
    }

    private Set<PartitionFieldNode> parse(List<String> inputProjectionFields) throws MetaException {
        this.projectionFields = new HashSet<String>(inputProjectionFields);
        this.projectionFields.remove("dbName");
        this.projectionFields.remove("tableName");
        this.projectionFields.remove("catName");
        if (this.isView) {
            this.projectionFields.removeIf(s -> s.matches(SD_PATTERN) || s.matches(SERDE_PATTERN) || s.matches(CD_PATTERN));
        }
        this.projectionFields = PartitionProjectionEvaluator.expand(this.projectionFields);
        this.removeUnsupportedFields();
        PartitionProjectionEvaluator.validate(this.projectionFields);
        HashMap<String, PartitionFieldNode> nestedNodes = new HashMap<String, PartitionFieldNode>();
        HashSet<PartitionFieldNode> rootNodes = new HashSet<PartitionFieldNode>();
        for (String projectedField : this.projectionFields) {
            String[] fields = projectedField.split("\\.");
            if (fields.length == 0) {
                LOG.warn("Invalid projected field {}. Ignoring ..", (Object)projectedField);
                continue;
            }
            StringBuilder fieldNameBuilder = new StringBuilder(fields[0]);
            PartitionFieldNode currentNode = this.createIfNotExists(nestedNodes, fieldNameBuilder.toString());
            rootNodes.add(currentNode);
            for (int level = 1; level < fields.length; ++level) {
                String name = fieldNameBuilder.append(".").append(fields[level]).toString();
                PartitionFieldNode childNode = this.createIfNotExists(nestedNodes, name);
                if (currentNode.isMultiValued) {
                    childNode.setMultiValued();
                }
                currentNode.addChild(childNode);
                currentNode = childNode;
            }
        }
        return rootNodes;
    }

    private void removeUnsupportedFields() {
        List<String> unsupportedFields = Arrays.asList("sd.serdeInfo.serializerClass", "sd.serdeInfo.deserializerClass", "sd.serdeInfo.serdeType", "sd.serdeInfo.description");
        for (String unsupportedField : unsupportedFields) {
            if (!this.projectionFields.contains(unsupportedField)) continue;
            LOG.warn("DirectSQL does not return partitions with the optional field" + unsupportedField + " set. Removing it from the projection list");
            this.projectionFields.remove(unsupportedField);
        }
    }

    private PartitionFieldNode createIfNotExists(Map<String, PartitionFieldNode> nestedNodes, String fieldName) {
        PartitionFieldNode currentNode = nestedNodes.computeIfAbsent(fieldName, k -> {
            if (this.multiValuedFieldSetters.containsKey(fieldName)) {
                return new PartitionFieldNode(fieldName, true);
            }
            return new PartitionFieldNode(fieldName);
        });
        return currentNode;
    }

    public List<Partition> getPartitionsUsingProjectionList(List<Long> partitionIds) throws MetaException {
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, List<FieldSchema>> cds = new TreeMap<Long, List<FieldSchema>>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        List<Partition> results = this.setSingleValuedFields(partitionIds, partitions, sds, serdes, cds);
        this.setMultivaluedFields(partitions, sds, serdes, cds);
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Partition> setSingleValuedFields(List<Long> partitionIds, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sdIds, TreeMap<Long, SerDeInfo> serdeIds, TreeMap<Long, List<FieldSchema>> cdIds) throws MetaException {
        StringBuilder queryTextBuilder = new StringBuilder();
        int numColumns = this.buildQueryForSingleValuedFields(partitionIds, queryTextBuilder);
        String queryText = queryTextBuilder.toString();
        try (Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);){
            long start = LOG.isDebugEnabled() ? System.nanoTime() : 0L;
            List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query, null, queryText);
            long queryTime = LOG.isDebugEnabled() ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(LOG.isDebugEnabled(), queryText, start, queryTime);
            Deadline.checkTimeout();
            final Long[] ids = new Long[4];
            Object[] rowVals = new Object[1];
            ArrayList<Partition> orderedResult = new ArrayList<Partition>(partitionIds.size());
            for (Object row : sqlResult) {
                if (numColumns > 1) {
                    rowVals = (Object[])row;
                } else {
                    rowVals[0] = row;
                }
                Partition part = new Partition();
                for (PartitionFieldNode root : this.roots) {
                    this.traverseAndSetValues(part, root, rowVals, new PartitionFieldValueSetter(){

                        public void setValue(Object partition, PartitionFieldNode node, Object value) throws MetaException {
                            if (!node.isMultiValued) {
                                if (node.equals(sdIdNode)) {
                                    ids[0] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(serdeIdNode)) {
                                    ids[2] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(cdIdNode)) {
                                    ids[1] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(partIdNode)) {
                                    ids[3] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else {
                                    if (node.fieldName.equals("sd.compressed") || node.fieldName.equals("sd.storedAsSubDirectories")) {
                                        value = MetastoreDirectSqlUtils.extractSqlBoolean(value);
                                    }
                                    MetaStoreUtils.setNestedProperty(partition, node.fieldName, value, true);
                                }
                            }
                        }
                    });
                }
                if (ids[3] == null) {
                    throw new MetaException("Could not find PART_ID for partition " + part);
                }
                partitions.put(ids[3], part);
                orderedResult.add(part);
                ids[3] = null;
                if (ids[0] != null) {
                    if (part.getSd() == null) {
                        part.setSd(new StorageDescriptor());
                    }
                    sdIds.put(ids[0], part.getSd());
                    ids[0] = null;
                }
                if (ids[2] != null) {
                    if (part.getSd().getSerdeInfo() == null) {
                        part.getSd().setSerdeInfo(new SerDeInfo());
                    }
                    serdeIds.put(ids[2], part.getSd().getSerdeInfo());
                    ids[2] = null;
                }
                if (ids[1] != null) {
                    cdIds.putIfAbsent(ids[1], new ArrayList(5));
                    if (part.getSd().getCols() == null) {
                        part.getSd().setCols(cdIds.get(ids[1]));
                    }
                    ids[1] = null;
                }
                Deadline.checkTimeout();
            }
            ArrayList<Partition> arrayList = orderedResult;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Exception received while getting partitions using projected fields", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    private void setMultivaluedFields(TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
        for (PartitionFieldNode root : this.roots) {
            this.traverseAndSetMultiValuedFields(root, partitions, sds, serdes, cds);
        }
    }

    private void traverseAndSetMultiValuedFields(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
        if (root == null) {
            return;
        }
        if (root.isMultiValued) {
            MutivaluedFieldSetter multiValuedFieldSetter = this.multiValuedFieldSetters.get(root.fieldName);
            if (multiValuedFieldSetter == null) {
                throw new MetaException("Cannot find multi-valued field setter for field " + root.fieldName);
            }
            multiValuedFieldSetter.setValue(root, partitions, sds, serdes, cds);
        } else {
            for (PartitionFieldNode child : root.children) {
                this.traverseAndSetMultiValuedFields(child, partitions, sds, serdes, cds);
            }
        }
    }

    private void traverseAndSetValues(Partition part, PartitionFieldNode root, Object[] row, PartitionFieldValueSetter valueSetter) throws MetaException {
        if (root == null || root.isMultiValued()) {
            return;
        }
        if (root.isLeafNode()) {
            valueSetter.setValue(part, root, row[root.fieldIndex]);
            return;
        }
        for (PartitionFieldNode child : root.children) {
            this.traverseAndSetValues(part, child, row, valueSetter);
        }
    }

    private int buildQueryForSingleValuedFields(List<Long> partitionIds, StringBuilder queryTextBuilder) {
        queryTextBuilder.append("select ");
        List<String> columnList = this.getSingleValuedColumnNames(this.roots);
        queryTextBuilder.append(Joiner.on(',').join(columnList));
        queryTextBuilder.append(SPACE);
        queryTextBuilder.append("from " + this.PARTITIONS);
        boolean foundSD = false;
        if (this.find(SD_PATTERN)) {
            queryTextBuilder.append(SPACE);
            queryTextBuilder.append("left outer join " + this.SDS + " on " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\"");
            foundSD = true;
        }
        if (foundSD || this.find(SERDE_PATTERN)) {
            queryTextBuilder.append(SPACE);
            queryTextBuilder.append("  left outer join " + this.SERDES + " on " + this.SDS + ".\"SERDE_ID\" = " + this.SERDES + ".\"SERDE_ID\"");
        }
        queryTextBuilder.append(SPACE);
        queryTextBuilder.append("where \"PART_ID\" in (" + Joiner.on(',').join(partitionIds) + ") order by \"PART_NAME\" asc");
        return columnList.size();
    }

    private int getSingleValuedColumnName(PartitionFieldNode root, int fieldId, List<String> columnNames) {
        if (root == null) {
            return fieldId;
        }
        if (root.isLeafNode() && !root.isMultiValued) {
            if (this.fieldNameToTableName.containsKey(root.fieldName)) {
                columnNames.add(this.fieldNameToTableName.get(root.fieldName));
                root.setFieldIndex(fieldId++);
                return fieldId;
            }
            throw new RuntimeException("No column name mapping found for partition field " + root.fieldName);
        }
        for (PartitionFieldNode child : root.children) {
            fieldId = this.getSingleValuedColumnName(child, fieldId, columnNames);
        }
        return fieldId;
    }

    private List<String> getSingleValuedColumnNames(Set<PartitionFieldNode> roots) {
        ArrayList<String> columnNames = new ArrayList<String>();
        int fieldIndex = 0;
        for (PartitionFieldNode node : roots) {
            fieldIndex = this.getSingleValuedColumnName(node, fieldIndex, columnNames);
        }
        return columnNames;
    }

    private static void getNestedFieldName(JsonNode jsonNode, String fieldName, Collection<String> results) {
        if (jsonNode instanceof ArrayNode) {
            Iterator elements = ((ArrayNode)jsonNode).elements();
            if (!elements.hasNext()) {
                results.add(fieldName);
                return;
            }
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                PartitionProjectionEvaluator.getNestedFieldName(element, fieldName, results);
            }
        } else {
            Iterator fields = jsonNode.fields();
            if (!fields.hasNext()) {
                results.add(fieldName);
                return;
            }
            while (fields.hasNext()) {
                Map.Entry fieldKV = (Map.Entry)fields.next();
                String key = (String)fieldKV.getKey();
                PartitionProjectionEvaluator.getNestedFieldName((JsonNode)fieldKV.getValue(), fieldName.length() == 0 ? key : fieldName + "." + key, results);
            }
        }
    }

    private List<String> getChildrenFieldNames(PartitionFieldNode root) throws MetaException {
        ArrayList<String> childFields = new ArrayList<String>(3);
        for (PartitionFieldNode child : root.getChildren()) {
            if (child.getFieldName().lastIndexOf(".") < 0) {
                throw new MetaException("Error parsing multi-valued field name " + child.getFieldName());
            }
            childFields.add(child.getFieldName().substring(child.getFieldName().lastIndexOf(".") + 1));
        }
        return childFields;
    }

    public static List<String> getMPartitionFieldNames(List<String> partitionFields) throws MetaException {
        if (partitionFields == null || partitionFields.isEmpty()) {
            return null;
        }
        PartitionProjectionEvaluator.validate(partitionFields);
        if (!((AbstractCollection)((Object)allPartitionSingleValuedFields.keySet())).containsAll(partitionFields)) {
            return null;
        }
        ArrayList<String> jdoFields = new ArrayList<String>(partitionFields.size());
        for (String partitionField : partitionFields) {
            jdoFields.add(allPartitionSingleValuedFields.get(partitionField));
        }
        return jdoFields;
    }

    private class PartitionSkewedColValLocationMapSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColValLocationMapSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String skewedStringListVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SKEWED_STRING_LIST_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SKEWED_STRING_LIST_VALUES") : "SKEWED_STRING_LIST_VALUES";
            String skewedColValLocMap = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SKEWED_COL_VALUE_LOC_MAP") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SKEWED_COL_VALUE_LOC_MAP") : "SKEWED_COL_VALUE_LOC_MAP";
            MetastoreDirectSqlUtils.setSkewedColLocationMaps(skewedColValLocMap, skewedStringListVals, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSkewedColsValuesSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColsValuesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String skewedStringListVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SKEWED_STRING_LIST_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SKEWED_STRING_LIST_VALUES") : "SKEWED_STRING_LIST_VALUES";
            String skewedVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SKEWED_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SKEWED_VALUES") : "SKEWED_VALUES";
            MetastoreDirectSqlUtils.setSkewedColValues(skewedStringListVals, skewedVals, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSkewedColsNamesSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColsNamesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SKEWED_COL_NAMES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SKEWED_COL_NAMES") : "SKEWED_COL_NAMES";
            MetastoreDirectSqlUtils.setSkewedColNames(tableName, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSerdeInfoParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionSerdeInfoParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SERDE_PARAMS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SERDE_PARAMS") : "SERDE_PARAMS";
            MetastoreDirectSqlUtils.setSerdeParams(tableName, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, serdes, Joiner.on(',').join(serdes.keySet()));
        }
    }

    private class PartitionSDParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionSDParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SD_PARAMS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SD_PARAMS") : "SD_PARAMS";
            MetastoreDirectSqlUtils.setSDParameters(tableName, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSortColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSortColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            List childFieldNames = PartitionProjectionEvaluator.this.getChildrenFieldNames(root);
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("SORT_COLS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("SORT_COLS") : "SORT_COLS";
            MetastoreDirectSqlUtils.setSDSortCols(tableName, childFieldNames, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSDBucketColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSDBucketColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("BUCKETING_COLS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("BUCKETING_COLS") : "BUCKETING_COLS";
            MetastoreDirectSqlUtils.setSDBucketCols(tableName, PartitionProjectionEvaluator.this.pm, sds, Joiner.on(',').join(sds.keySet()));
        }
    }

    private class PartitionSDColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSDColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            List childFields = PartitionProjectionEvaluator.this.getChildrenFieldNames(root);
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("COLUMNS_V2") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("COLUMNS_V2") : "COLUMNS_V2";
            MetastoreDirectSqlUtils.setSDCols(tableName, childFields, PartitionProjectionEvaluator.this.pm, cds, Joiner.on(',').join(cds.keySet()));
        }
    }

    private class PartitionParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            MetastoreDirectSqlUtils.setPartitionParametersWithFilter(PartitionProjectionEvaluator.this.PARTITION_PARAMS, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, Joiner.on(',').join(partitions.keySet()), partitions, PartitionProjectionEvaluator.this.includeParamKeyPattern, PartitionProjectionEvaluator.this.excludeParamKeyPattern);
        }
    }

    private class PartitionValuesSetter
    implements MutivaluedFieldSetter {
        private PartitionValuesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey("PARTITION_KEY_VALS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get("PARTITION_KEY_VALS") : "PARTITION_KEY_VALS";
            MetastoreDirectSqlUtils.setPartitionValues(tableName, PartitionProjectionEvaluator.this.pm, Joiner.on(',').join(partitions.keySet()), partitions);
        }
    }

    private static interface MutivaluedFieldSetter {
        public void setValue(PartitionFieldNode var1, TreeMap<Long, Partition> var2, TreeMap<Long, StorageDescriptor> var3, TreeMap<Long, SerDeInfo> var4, TreeMap<Long, List<FieldSchema>> var5) throws MetaException;
    }

    static class PartitionFieldNode {
        private String fieldName;
        private Set<PartitionFieldNode> children = new HashSet<PartitionFieldNode>(4);
        private boolean isMultiValued;
        private int fieldIndex;

        PartitionFieldNode(String fieldName) {
            this.fieldName = fieldName;
            this.isMultiValued = false;
        }

        PartitionFieldNode(String fieldName, boolean isMultiValued) {
            this.fieldName = fieldName;
            this.isMultiValued = isMultiValued;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFieldNode that = (PartitionFieldNode)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        boolean isLeafNode() {
            return this.children == null || this.children.isEmpty();
        }

        void setFieldIndex(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @VisibleForTesting
        void addChild(PartitionFieldNode child) {
            this.children.add(child);
        }

        @VisibleForTesting
        String getFieldName() {
            return this.fieldName;
        }

        @VisibleForTesting
        Set<PartitionFieldNode> getChildren() {
            return new HashSet<PartitionFieldNode>(this.children);
        }

        @VisibleForTesting
        boolean isMultiValued() {
            return this.isMultiValued;
        }

        public String toString() {
            return this.fieldName;
        }

        public int hashCode() {
            return Objects.hash(this.fieldName);
        }

        void setMultiValued() {
            this.isMultiValued = true;
        }
    }

    static interface PartitionFieldValueSetter<T> {
        public void setValue(T var1, PartitionFieldNode var2, Object var3) throws MetaException;
    }
}

