/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CreateTableRequest
implements TBase<CreateTableRequest, _Fields>,
Serializable,
Cloneable,
Comparable<CreateTableRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("CreateTableRequest");
    private static final TField TABLE_FIELD_DESC = new TField("table", 12, 1);
    private static final TField ENV_CONTEXT_FIELD_DESC = new TField("envContext", 12, 2);
    private static final TField PRIMARY_KEYS_FIELD_DESC = new TField("primaryKeys", 15, 3);
    private static final TField FOREIGN_KEYS_FIELD_DESC = new TField("foreignKeys", 15, 4);
    private static final TField UNIQUE_CONSTRAINTS_FIELD_DESC = new TField("uniqueConstraints", 15, 5);
    private static final TField NOT_NULL_CONSTRAINTS_FIELD_DESC = new TField("notNullConstraints", 15, 6);
    private static final TField DEFAULT_CONSTRAINTS_FIELD_DESC = new TField("defaultConstraints", 15, 7);
    private static final TField CHECK_CONSTRAINTS_FIELD_DESC = new TField("checkConstraints", 15, 8);
    private static final TField PROCESSOR_CAPABILITIES_FIELD_DESC = new TField("processorCapabilities", 15, 9);
    private static final TField PROCESSOR_IDENTIFIER_FIELD_DESC = new TField("processorIdentifier", 11, 10);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private Table table;
    private EnvironmentContext envContext;
    private List<SQLPrimaryKey> primaryKeys;
    private List<SQLForeignKey> foreignKeys;
    private List<SQLUniqueConstraint> uniqueConstraints;
    private List<SQLNotNullConstraint> notNullConstraints;
    private List<SQLDefaultConstraint> defaultConstraints;
    private List<SQLCheckConstraint> checkConstraints;
    private List<String> processorCapabilities;
    private String processorIdentifier;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CreateTableRequest() {
    }

    public CreateTableRequest(Table table) {
        this();
        this.table = table;
    }

    public CreateTableRequest(CreateTableRequest other) {
        if (other.isSetTable()) {
            this.table = new Table(other.table);
        }
        if (other.isSetEnvContext()) {
            this.envContext = new EnvironmentContext(other.envContext);
        }
        if (other.isSetPrimaryKeys()) {
            ArrayList<SQLPrimaryKey> __this__primaryKeys = new ArrayList<SQLPrimaryKey>(other.primaryKeys.size());
            for (SQLPrimaryKey sQLPrimaryKey : other.primaryKeys) {
                __this__primaryKeys.add(new SQLPrimaryKey(sQLPrimaryKey));
            }
            this.primaryKeys = __this__primaryKeys;
        }
        if (other.isSetForeignKeys()) {
            ArrayList<SQLForeignKey> __this__foreignKeys = new ArrayList<SQLForeignKey>(other.foreignKeys.size());
            for (SQLForeignKey sQLForeignKey : other.foreignKeys) {
                __this__foreignKeys.add(new SQLForeignKey(sQLForeignKey));
            }
            this.foreignKeys = __this__foreignKeys;
        }
        if (other.isSetUniqueConstraints()) {
            ArrayList<SQLUniqueConstraint> __this__uniqueConstraints = new ArrayList<SQLUniqueConstraint>(other.uniqueConstraints.size());
            for (SQLUniqueConstraint sQLUniqueConstraint : other.uniqueConstraints) {
                __this__uniqueConstraints.add(new SQLUniqueConstraint(sQLUniqueConstraint));
            }
            this.uniqueConstraints = __this__uniqueConstraints;
        }
        if (other.isSetNotNullConstraints()) {
            ArrayList<SQLNotNullConstraint> __this__notNullConstraints = new ArrayList<SQLNotNullConstraint>(other.notNullConstraints.size());
            for (SQLNotNullConstraint sQLNotNullConstraint : other.notNullConstraints) {
                __this__notNullConstraints.add(new SQLNotNullConstraint(sQLNotNullConstraint));
            }
            this.notNullConstraints = __this__notNullConstraints;
        }
        if (other.isSetDefaultConstraints()) {
            ArrayList<SQLDefaultConstraint> __this__defaultConstraints = new ArrayList<SQLDefaultConstraint>(other.defaultConstraints.size());
            for (SQLDefaultConstraint sQLDefaultConstraint : other.defaultConstraints) {
                __this__defaultConstraints.add(new SQLDefaultConstraint(sQLDefaultConstraint));
            }
            this.defaultConstraints = __this__defaultConstraints;
        }
        if (other.isSetCheckConstraints()) {
            ArrayList<SQLCheckConstraint> __this__checkConstraints = new ArrayList<SQLCheckConstraint>(other.checkConstraints.size());
            for (SQLCheckConstraint sQLCheckConstraint : other.checkConstraints) {
                __this__checkConstraints.add(new SQLCheckConstraint(sQLCheckConstraint));
            }
            this.checkConstraints = __this__checkConstraints;
        }
        if (other.isSetProcessorCapabilities()) {
            ArrayList<String> __this__processorCapabilities = new ArrayList<String>(other.processorCapabilities);
            this.processorCapabilities = __this__processorCapabilities;
        }
        if (other.isSetProcessorIdentifier()) {
            this.processorIdentifier = other.processorIdentifier;
        }
    }

    public CreateTableRequest deepCopy() {
        return new CreateTableRequest(this);
    }

    @Override
    public void clear() {
        this.table = null;
        this.envContext = null;
        this.primaryKeys = null;
        this.foreignKeys = null;
        this.uniqueConstraints = null;
        this.notNullConstraints = null;
        this.defaultConstraints = null;
        this.checkConstraints = null;
        this.processorCapabilities = null;
        this.processorIdentifier = null;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public EnvironmentContext getEnvContext() {
        return this.envContext;
    }

    public void setEnvContext(EnvironmentContext envContext) {
        this.envContext = envContext;
    }

    public void unsetEnvContext() {
        this.envContext = null;
    }

    public boolean isSetEnvContext() {
        return this.envContext != null;
    }

    public void setEnvContextIsSet(boolean value) {
        if (!value) {
            this.envContext = null;
        }
    }

    public int getPrimaryKeysSize() {
        return this.primaryKeys == null ? 0 : this.primaryKeys.size();
    }

    public Iterator<SQLPrimaryKey> getPrimaryKeysIterator() {
        return this.primaryKeys == null ? null : this.primaryKeys.iterator();
    }

    public void addToPrimaryKeys(SQLPrimaryKey elem) {
        if (this.primaryKeys == null) {
            this.primaryKeys = new ArrayList<SQLPrimaryKey>();
        }
        this.primaryKeys.add(elem);
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<SQLPrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void unsetPrimaryKeys() {
        this.primaryKeys = null;
    }

    public boolean isSetPrimaryKeys() {
        return this.primaryKeys != null;
    }

    public void setPrimaryKeysIsSet(boolean value) {
        if (!value) {
            this.primaryKeys = null;
        }
    }

    public int getForeignKeysSize() {
        return this.foreignKeys == null ? 0 : this.foreignKeys.size();
    }

    public Iterator<SQLForeignKey> getForeignKeysIterator() {
        return this.foreignKeys == null ? null : this.foreignKeys.iterator();
    }

    public void addToForeignKeys(SQLForeignKey elem) {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<SQLForeignKey>();
        }
        this.foreignKeys.add(elem);
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(List<SQLForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public void unsetForeignKeys() {
        this.foreignKeys = null;
    }

    public boolean isSetForeignKeys() {
        return this.foreignKeys != null;
    }

    public void setForeignKeysIsSet(boolean value) {
        if (!value) {
            this.foreignKeys = null;
        }
    }

    public int getUniqueConstraintsSize() {
        return this.uniqueConstraints == null ? 0 : this.uniqueConstraints.size();
    }

    public Iterator<SQLUniqueConstraint> getUniqueConstraintsIterator() {
        return this.uniqueConstraints == null ? null : this.uniqueConstraints.iterator();
    }

    public void addToUniqueConstraints(SQLUniqueConstraint elem) {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
        }
        this.uniqueConstraints.add(elem);
    }

    public List<SQLUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void setUniqueConstraints(List<SQLUniqueConstraint> uniqueConstraints) {
        this.uniqueConstraints = uniqueConstraints;
    }

    public void unsetUniqueConstraints() {
        this.uniqueConstraints = null;
    }

    public boolean isSetUniqueConstraints() {
        return this.uniqueConstraints != null;
    }

    public void setUniqueConstraintsIsSet(boolean value) {
        if (!value) {
            this.uniqueConstraints = null;
        }
    }

    public int getNotNullConstraintsSize() {
        return this.notNullConstraints == null ? 0 : this.notNullConstraints.size();
    }

    public Iterator<SQLNotNullConstraint> getNotNullConstraintsIterator() {
        return this.notNullConstraints == null ? null : this.notNullConstraints.iterator();
    }

    public void addToNotNullConstraints(SQLNotNullConstraint elem) {
        if (this.notNullConstraints == null) {
            this.notNullConstraints = new ArrayList<SQLNotNullConstraint>();
        }
        this.notNullConstraints.add(elem);
    }

    public List<SQLNotNullConstraint> getNotNullConstraints() {
        return this.notNullConstraints;
    }

    public void setNotNullConstraints(List<SQLNotNullConstraint> notNullConstraints) {
        this.notNullConstraints = notNullConstraints;
    }

    public void unsetNotNullConstraints() {
        this.notNullConstraints = null;
    }

    public boolean isSetNotNullConstraints() {
        return this.notNullConstraints != null;
    }

    public void setNotNullConstraintsIsSet(boolean value) {
        if (!value) {
            this.notNullConstraints = null;
        }
    }

    public int getDefaultConstraintsSize() {
        return this.defaultConstraints == null ? 0 : this.defaultConstraints.size();
    }

    public Iterator<SQLDefaultConstraint> getDefaultConstraintsIterator() {
        return this.defaultConstraints == null ? null : this.defaultConstraints.iterator();
    }

    public void addToDefaultConstraints(SQLDefaultConstraint elem) {
        if (this.defaultConstraints == null) {
            this.defaultConstraints = new ArrayList<SQLDefaultConstraint>();
        }
        this.defaultConstraints.add(elem);
    }

    public List<SQLDefaultConstraint> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public void setDefaultConstraints(List<SQLDefaultConstraint> defaultConstraints) {
        this.defaultConstraints = defaultConstraints;
    }

    public void unsetDefaultConstraints() {
        this.defaultConstraints = null;
    }

    public boolean isSetDefaultConstraints() {
        return this.defaultConstraints != null;
    }

    public void setDefaultConstraintsIsSet(boolean value) {
        if (!value) {
            this.defaultConstraints = null;
        }
    }

    public int getCheckConstraintsSize() {
        return this.checkConstraints == null ? 0 : this.checkConstraints.size();
    }

    public Iterator<SQLCheckConstraint> getCheckConstraintsIterator() {
        return this.checkConstraints == null ? null : this.checkConstraints.iterator();
    }

    public void addToCheckConstraints(SQLCheckConstraint elem) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<SQLCheckConstraint>();
        }
        this.checkConstraints.add(elem);
    }

    public List<SQLCheckConstraint> getCheckConstraints() {
        return this.checkConstraints;
    }

    public void setCheckConstraints(List<SQLCheckConstraint> checkConstraints) {
        this.checkConstraints = checkConstraints;
    }

    public void unsetCheckConstraints() {
        this.checkConstraints = null;
    }

    public boolean isSetCheckConstraints() {
        return this.checkConstraints != null;
    }

    public void setCheckConstraintsIsSet(boolean value) {
        if (!value) {
            this.checkConstraints = null;
        }
    }

    public int getProcessorCapabilitiesSize() {
        return this.processorCapabilities == null ? 0 : this.processorCapabilities.size();
    }

    public Iterator<String> getProcessorCapabilitiesIterator() {
        return this.processorCapabilities == null ? null : this.processorCapabilities.iterator();
    }

    public void addToProcessorCapabilities(String elem) {
        if (this.processorCapabilities == null) {
            this.processorCapabilities = new ArrayList<String>();
        }
        this.processorCapabilities.add(elem);
    }

    public List<String> getProcessorCapabilities() {
        return this.processorCapabilities;
    }

    public void setProcessorCapabilities(List<String> processorCapabilities) {
        this.processorCapabilities = processorCapabilities;
    }

    public void unsetProcessorCapabilities() {
        this.processorCapabilities = null;
    }

    public boolean isSetProcessorCapabilities() {
        return this.processorCapabilities != null;
    }

    public void setProcessorCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.processorCapabilities = null;
        }
    }

    public String getProcessorIdentifier() {
        return this.processorIdentifier;
    }

    public void setProcessorIdentifier(String processorIdentifier) {
        this.processorIdentifier = processorIdentifier;
    }

    public void unsetProcessorIdentifier() {
        this.processorIdentifier = null;
    }

    public boolean isSetProcessorIdentifier() {
        return this.processorIdentifier != null;
    }

    public void setProcessorIdentifierIsSet(boolean value) {
        if (!value) {
            this.processorIdentifier = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((Table)value);
                break;
            }
            case ENV_CONTEXT: {
                if (value == null) {
                    this.unsetEnvContext();
                    break;
                }
                this.setEnvContext((EnvironmentContext)value);
                break;
            }
            case PRIMARY_KEYS: {
                if (value == null) {
                    this.unsetPrimaryKeys();
                    break;
                }
                this.setPrimaryKeys((List)value);
                break;
            }
            case FOREIGN_KEYS: {
                if (value == null) {
                    this.unsetForeignKeys();
                    break;
                }
                this.setForeignKeys((List)value);
                break;
            }
            case UNIQUE_CONSTRAINTS: {
                if (value == null) {
                    this.unsetUniqueConstraints();
                    break;
                }
                this.setUniqueConstraints((List)value);
                break;
            }
            case NOT_NULL_CONSTRAINTS: {
                if (value == null) {
                    this.unsetNotNullConstraints();
                    break;
                }
                this.setNotNullConstraints((List)value);
                break;
            }
            case DEFAULT_CONSTRAINTS: {
                if (value == null) {
                    this.unsetDefaultConstraints();
                    break;
                }
                this.setDefaultConstraints((List)value);
                break;
            }
            case CHECK_CONSTRAINTS: {
                if (value == null) {
                    this.unsetCheckConstraints();
                    break;
                }
                this.setCheckConstraints((List)value);
                break;
            }
            case PROCESSOR_CAPABILITIES: {
                if (value == null) {
                    this.unsetProcessorCapabilities();
                    break;
                }
                this.setProcessorCapabilities((List)value);
                break;
            }
            case PROCESSOR_IDENTIFIER: {
                if (value == null) {
                    this.unsetProcessorIdentifier();
                    break;
                }
                this.setProcessorIdentifier((String)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE: {
                return this.getTable();
            }
            case ENV_CONTEXT: {
                return this.getEnvContext();
            }
            case PRIMARY_KEYS: {
                return this.getPrimaryKeys();
            }
            case FOREIGN_KEYS: {
                return this.getForeignKeys();
            }
            case UNIQUE_CONSTRAINTS: {
                return this.getUniqueConstraints();
            }
            case NOT_NULL_CONSTRAINTS: {
                return this.getNotNullConstraints();
            }
            case DEFAULT_CONSTRAINTS: {
                return this.getDefaultConstraints();
            }
            case CHECK_CONSTRAINTS: {
                return this.getCheckConstraints();
            }
            case PROCESSOR_CAPABILITIES: {
                return this.getProcessorCapabilities();
            }
            case PROCESSOR_IDENTIFIER: {
                return this.getProcessorIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE: {
                return this.isSetTable();
            }
            case ENV_CONTEXT: {
                return this.isSetEnvContext();
            }
            case PRIMARY_KEYS: {
                return this.isSetPrimaryKeys();
            }
            case FOREIGN_KEYS: {
                return this.isSetForeignKeys();
            }
            case UNIQUE_CONSTRAINTS: {
                return this.isSetUniqueConstraints();
            }
            case NOT_NULL_CONSTRAINTS: {
                return this.isSetNotNullConstraints();
            }
            case DEFAULT_CONSTRAINTS: {
                return this.isSetDefaultConstraints();
            }
            case CHECK_CONSTRAINTS: {
                return this.isSetCheckConstraints();
            }
            case PROCESSOR_CAPABILITIES: {
                return this.isSetProcessorCapabilities();
            }
            case PROCESSOR_IDENTIFIER: {
                return this.isSetProcessorIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof CreateTableRequest) {
            return this.equals((CreateTableRequest)that);
        }
        return false;
    }

    public boolean equals(CreateTableRequest that) {
        if (that == null) {
            return false;
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_envContext = this.isSetEnvContext();
        boolean that_present_envContext = that.isSetEnvContext();
        if (this_present_envContext || that_present_envContext) {
            if (!this_present_envContext || !that_present_envContext) {
                return false;
            }
            if (!this.envContext.equals(that.envContext)) {
                return false;
            }
        }
        boolean this_present_primaryKeys = this.isSetPrimaryKeys();
        boolean that_present_primaryKeys = that.isSetPrimaryKeys();
        if (this_present_primaryKeys || that_present_primaryKeys) {
            if (!this_present_primaryKeys || !that_present_primaryKeys) {
                return false;
            }
            if (!this.primaryKeys.equals(that.primaryKeys)) {
                return false;
            }
        }
        boolean this_present_foreignKeys = this.isSetForeignKeys();
        boolean that_present_foreignKeys = that.isSetForeignKeys();
        if (this_present_foreignKeys || that_present_foreignKeys) {
            if (!this_present_foreignKeys || !that_present_foreignKeys) {
                return false;
            }
            if (!this.foreignKeys.equals(that.foreignKeys)) {
                return false;
            }
        }
        boolean this_present_uniqueConstraints = this.isSetUniqueConstraints();
        boolean that_present_uniqueConstraints = that.isSetUniqueConstraints();
        if (this_present_uniqueConstraints || that_present_uniqueConstraints) {
            if (!this_present_uniqueConstraints || !that_present_uniqueConstraints) {
                return false;
            }
            if (!this.uniqueConstraints.equals(that.uniqueConstraints)) {
                return false;
            }
        }
        boolean this_present_notNullConstraints = this.isSetNotNullConstraints();
        boolean that_present_notNullConstraints = that.isSetNotNullConstraints();
        if (this_present_notNullConstraints || that_present_notNullConstraints) {
            if (!this_present_notNullConstraints || !that_present_notNullConstraints) {
                return false;
            }
            if (!this.notNullConstraints.equals(that.notNullConstraints)) {
                return false;
            }
        }
        boolean this_present_defaultConstraints = this.isSetDefaultConstraints();
        boolean that_present_defaultConstraints = that.isSetDefaultConstraints();
        if (this_present_defaultConstraints || that_present_defaultConstraints) {
            if (!this_present_defaultConstraints || !that_present_defaultConstraints) {
                return false;
            }
            if (!this.defaultConstraints.equals(that.defaultConstraints)) {
                return false;
            }
        }
        boolean this_present_checkConstraints = this.isSetCheckConstraints();
        boolean that_present_checkConstraints = that.isSetCheckConstraints();
        if (this_present_checkConstraints || that_present_checkConstraints) {
            if (!this_present_checkConstraints || !that_present_checkConstraints) {
                return false;
            }
            if (!this.checkConstraints.equals(that.checkConstraints)) {
                return false;
            }
        }
        boolean this_present_processorCapabilities = this.isSetProcessorCapabilities();
        boolean that_present_processorCapabilities = that.isSetProcessorCapabilities();
        if (this_present_processorCapabilities || that_present_processorCapabilities) {
            if (!this_present_processorCapabilities || !that_present_processorCapabilities) {
                return false;
            }
            if (!this.processorCapabilities.equals(that.processorCapabilities)) {
                return false;
            }
        }
        boolean this_present_processorIdentifier = this.isSetProcessorIdentifier();
        boolean that_present_processorIdentifier = that.isSetProcessorIdentifier();
        if (this_present_processorIdentifier || that_present_processorIdentifier) {
            if (!this_present_processorIdentifier || !that_present_processorIdentifier) {
                return false;
            }
            if (!this.processorIdentifier.equals(that.processorIdentifier)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_table = this.isSetTable();
        list.add(present_table);
        if (present_table) {
            list.add(this.table);
        }
        boolean present_envContext = this.isSetEnvContext();
        list.add(present_envContext);
        if (present_envContext) {
            list.add(this.envContext);
        }
        boolean present_primaryKeys = this.isSetPrimaryKeys();
        list.add(present_primaryKeys);
        if (present_primaryKeys) {
            list.add(this.primaryKeys);
        }
        boolean present_foreignKeys = this.isSetForeignKeys();
        list.add(present_foreignKeys);
        if (present_foreignKeys) {
            list.add(this.foreignKeys);
        }
        boolean present_uniqueConstraints = this.isSetUniqueConstraints();
        list.add(present_uniqueConstraints);
        if (present_uniqueConstraints) {
            list.add(this.uniqueConstraints);
        }
        boolean present_notNullConstraints = this.isSetNotNullConstraints();
        list.add(present_notNullConstraints);
        if (present_notNullConstraints) {
            list.add(this.notNullConstraints);
        }
        boolean present_defaultConstraints = this.isSetDefaultConstraints();
        list.add(present_defaultConstraints);
        if (present_defaultConstraints) {
            list.add(this.defaultConstraints);
        }
        boolean present_checkConstraints = this.isSetCheckConstraints();
        list.add(present_checkConstraints);
        if (present_checkConstraints) {
            list.add(this.checkConstraints);
        }
        boolean present_processorCapabilities = this.isSetProcessorCapabilities();
        list.add(present_processorCapabilities);
        if (present_processorCapabilities) {
            list.add(this.processorCapabilities);
        }
        boolean present_processorIdentifier = this.isSetProcessorIdentifier();
        list.add(present_processorIdentifier);
        if (present_processorIdentifier) {
            list.add(this.processorIdentifier);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(CreateTableRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTable()).compareTo(other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo(this.table, other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEnvContext()).compareTo(other.isSetEnvContext());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvContext() && (lastComparison = TBaseHelper.compareTo(this.envContext, other.envContext)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrimaryKeys()).compareTo(other.isSetPrimaryKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrimaryKeys() && (lastComparison = TBaseHelper.compareTo(this.primaryKeys, other.primaryKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetForeignKeys()).compareTo(other.isSetForeignKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetForeignKeys() && (lastComparison = TBaseHelper.compareTo(this.foreignKeys, other.foreignKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUniqueConstraints()).compareTo(other.isSetUniqueConstraints());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUniqueConstraints() && (lastComparison = TBaseHelper.compareTo(this.uniqueConstraints, other.uniqueConstraints)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNotNullConstraints()).compareTo(other.isSetNotNullConstraints());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNotNullConstraints() && (lastComparison = TBaseHelper.compareTo(this.notNullConstraints, other.notNullConstraints)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefaultConstraints()).compareTo(other.isSetDefaultConstraints());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultConstraints() && (lastComparison = TBaseHelper.compareTo(this.defaultConstraints, other.defaultConstraints)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCheckConstraints()).compareTo(other.isSetCheckConstraints());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCheckConstraints() && (lastComparison = TBaseHelper.compareTo(this.checkConstraints, other.checkConstraints)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessorCapabilities()).compareTo(other.isSetProcessorCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorCapabilities() && (lastComparison = TBaseHelper.compareTo(this.processorCapabilities, other.processorCapabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessorIdentifier()).compareTo(other.isSetProcessorIdentifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorIdentifier() && (lastComparison = TBaseHelper.compareTo(this.processorIdentifier, other.processorIdentifier)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (CreateTableRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (CreateTableRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateTableRequest(");
        boolean first = true;
        sb.append("table:");
        if (this.table == null) {
            sb.append("null");
        } else {
            sb.append(this.table);
        }
        first = false;
        if (this.isSetEnvContext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("envContext:");
            if (this.envContext == null) {
                sb.append("null");
            } else {
                sb.append(this.envContext);
            }
            first = false;
        }
        if (this.isSetPrimaryKeys()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("primaryKeys:");
            if (this.primaryKeys == null) {
                sb.append("null");
            } else {
                sb.append(this.primaryKeys);
            }
            first = false;
        }
        if (this.isSetForeignKeys()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("foreignKeys:");
            if (this.foreignKeys == null) {
                sb.append("null");
            } else {
                sb.append(this.foreignKeys);
            }
            first = false;
        }
        if (this.isSetUniqueConstraints()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("uniqueConstraints:");
            if (this.uniqueConstraints == null) {
                sb.append("null");
            } else {
                sb.append(this.uniqueConstraints);
            }
            first = false;
        }
        if (this.isSetNotNullConstraints()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("notNullConstraints:");
            if (this.notNullConstraints == null) {
                sb.append("null");
            } else {
                sb.append(this.notNullConstraints);
            }
            first = false;
        }
        if (this.isSetDefaultConstraints()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("defaultConstraints:");
            if (this.defaultConstraints == null) {
                sb.append("null");
            } else {
                sb.append(this.defaultConstraints);
            }
            first = false;
        }
        if (this.isSetCheckConstraints()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("checkConstraints:");
            if (this.checkConstraints == null) {
                sb.append("null");
            } else {
                sb.append(this.checkConstraints);
            }
            first = false;
        }
        if (this.isSetProcessorCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorCapabilities:");
            if (this.processorCapabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.processorCapabilities);
            }
            first = false;
        }
        if (this.isSetProcessorIdentifier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorIdentifier:");
            if (this.processorIdentifier == null) {
                sb.append("null");
            } else {
                sb.append(this.processorIdentifier);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetTable()) {
            throw new TProtocolException("Required field 'table' is unset! Struct:" + this.toString());
        }
        if (this.table != null) {
            this.table.validate();
        }
        if (this.envContext != null) {
            this.envContext.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new CreateTableRequestStandardSchemeFactory());
        schemes.put(TupleScheme.class, new CreateTableRequestTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.ENV_CONTEXT, _Fields.PRIMARY_KEYS, _Fields.FOREIGN_KEYS, _Fields.UNIQUE_CONSTRAINTS, _Fields.NOT_NULL_CONSTRAINTS, _Fields.DEFAULT_CONSTRAINTS, _Fields.CHECK_CONSTRAINTS, _Fields.PROCESSOR_CAPABILITIES, _Fields.PROCESSOR_IDENTIFIER};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 1, new StructMetaData(12, Table.class)));
        tmpMap.put(_Fields.ENV_CONTEXT, new FieldMetaData("envContext", 2, new StructMetaData(12, EnvironmentContext.class)));
        tmpMap.put(_Fields.PRIMARY_KEYS, new FieldMetaData("primaryKeys", 2, new ListMetaData(15, new StructMetaData(12, SQLPrimaryKey.class))));
        tmpMap.put(_Fields.FOREIGN_KEYS, new FieldMetaData("foreignKeys", 2, new ListMetaData(15, new StructMetaData(12, SQLForeignKey.class))));
        tmpMap.put(_Fields.UNIQUE_CONSTRAINTS, new FieldMetaData("uniqueConstraints", 2, new ListMetaData(15, new StructMetaData(12, SQLUniqueConstraint.class))));
        tmpMap.put(_Fields.NOT_NULL_CONSTRAINTS, new FieldMetaData("notNullConstraints", 2, new ListMetaData(15, new StructMetaData(12, SQLNotNullConstraint.class))));
        tmpMap.put(_Fields.DEFAULT_CONSTRAINTS, new FieldMetaData("defaultConstraints", 2, new ListMetaData(15, new StructMetaData(12, SQLDefaultConstraint.class))));
        tmpMap.put(_Fields.CHECK_CONSTRAINTS, new FieldMetaData("checkConstraints", 2, new ListMetaData(15, new StructMetaData(12, SQLCheckConstraint.class))));
        tmpMap.put(_Fields.PROCESSOR_CAPABILITIES, new FieldMetaData("processorCapabilities", 2, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PROCESSOR_IDENTIFIER, new FieldMetaData("processorIdentifier", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CreateTableRequest.class, metaDataMap);
    }

    private static class CreateTableRequestTupleScheme
    extends TupleScheme<CreateTableRequest> {
        private CreateTableRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, CreateTableRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.table.write(oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetEnvContext()) {
                optionals.set(0);
            }
            if (struct.isSetPrimaryKeys()) {
                optionals.set(1);
            }
            if (struct.isSetForeignKeys()) {
                optionals.set(2);
            }
            if (struct.isSetUniqueConstraints()) {
                optionals.set(3);
            }
            if (struct.isSetNotNullConstraints()) {
                optionals.set(4);
            }
            if (struct.isSetDefaultConstraints()) {
                optionals.set(5);
            }
            if (struct.isSetCheckConstraints()) {
                optionals.set(6);
            }
            if (struct.isSetProcessorCapabilities()) {
                optionals.set(7);
            }
            if (struct.isSetProcessorIdentifier()) {
                optionals.set(8);
            }
            oprot.writeBitSet(optionals, 9);
            if (struct.isSetEnvContext()) {
                struct.envContext.write(oprot);
            }
            if (struct.isSetPrimaryKeys()) {
                oprot.writeI32(struct.primaryKeys.size());
                for (SQLPrimaryKey _iter1108 : struct.primaryKeys) {
                    _iter1108.write(oprot);
                }
            }
            if (struct.isSetForeignKeys()) {
                oprot.writeI32(struct.foreignKeys.size());
                for (SQLForeignKey _iter1109 : struct.foreignKeys) {
                    _iter1109.write(oprot);
                }
            }
            if (struct.isSetUniqueConstraints()) {
                oprot.writeI32(struct.uniqueConstraints.size());
                for (SQLUniqueConstraint _iter1110 : struct.uniqueConstraints) {
                    _iter1110.write(oprot);
                }
            }
            if (struct.isSetNotNullConstraints()) {
                oprot.writeI32(struct.notNullConstraints.size());
                for (SQLNotNullConstraint _iter1111 : struct.notNullConstraints) {
                    _iter1111.write(oprot);
                }
            }
            if (struct.isSetDefaultConstraints()) {
                oprot.writeI32(struct.defaultConstraints.size());
                for (SQLDefaultConstraint _iter1112 : struct.defaultConstraints) {
                    _iter1112.write(oprot);
                }
            }
            if (struct.isSetCheckConstraints()) {
                oprot.writeI32(struct.checkConstraints.size());
                for (SQLCheckConstraint _iter1113 : struct.checkConstraints) {
                    _iter1113.write(oprot);
                }
            }
            if (struct.isSetProcessorCapabilities()) {
                oprot.writeI32(struct.processorCapabilities.size());
                for (String _iter1114 : struct.processorCapabilities) {
                    oprot.writeString(_iter1114);
                }
            }
            if (struct.isSetProcessorIdentifier()) {
                oprot.writeString(struct.processorIdentifier);
            }
        }

        @Override
        public void read(TProtocol prot, CreateTableRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.table = new Table();
            struct.table.read(iprot);
            struct.setTableIsSet(true);
            BitSet incoming = iprot.readBitSet(9);
            if (incoming.get(0)) {
                struct.envContext = new EnvironmentContext();
                struct.envContext.read(iprot);
                struct.setEnvContextIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list1115 = new TList(12, iprot.readI32());
                struct.primaryKeys = new ArrayList(_list1115.size);
                for (int _i1117 = 0; _i1117 < _list1115.size; ++_i1117) {
                    SQLPrimaryKey _elem1116 = new SQLPrimaryKey();
                    _elem1116.read(iprot);
                    struct.primaryKeys.add(_elem1116);
                }
                struct.setPrimaryKeysIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list1118 = new TList(12, iprot.readI32());
                struct.foreignKeys = new ArrayList(_list1118.size);
                for (int _i1120 = 0; _i1120 < _list1118.size; ++_i1120) {
                    SQLForeignKey _elem1119 = new SQLForeignKey();
                    _elem1119.read(iprot);
                    struct.foreignKeys.add(_elem1119);
                }
                struct.setForeignKeysIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list1121 = new TList(12, iprot.readI32());
                struct.uniqueConstraints = new ArrayList(_list1121.size);
                for (int _i1123 = 0; _i1123 < _list1121.size; ++_i1123) {
                    SQLUniqueConstraint _elem1122 = new SQLUniqueConstraint();
                    _elem1122.read(iprot);
                    struct.uniqueConstraints.add(_elem1122);
                }
                struct.setUniqueConstraintsIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list1124 = new TList(12, iprot.readI32());
                struct.notNullConstraints = new ArrayList(_list1124.size);
                for (int _i1126 = 0; _i1126 < _list1124.size; ++_i1126) {
                    SQLNotNullConstraint _elem1125 = new SQLNotNullConstraint();
                    _elem1125.read(iprot);
                    struct.notNullConstraints.add(_elem1125);
                }
                struct.setNotNullConstraintsIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list1127 = new TList(12, iprot.readI32());
                struct.defaultConstraints = new ArrayList(_list1127.size);
                for (int _i1129 = 0; _i1129 < _list1127.size; ++_i1129) {
                    SQLDefaultConstraint _elem1128 = new SQLDefaultConstraint();
                    _elem1128.read(iprot);
                    struct.defaultConstraints.add(_elem1128);
                }
                struct.setDefaultConstraintsIsSet(true);
            }
            if (incoming.get(6)) {
                TList _list1130 = new TList(12, iprot.readI32());
                struct.checkConstraints = new ArrayList(_list1130.size);
                for (int _i1132 = 0; _i1132 < _list1130.size; ++_i1132) {
                    SQLCheckConstraint _elem1131 = new SQLCheckConstraint();
                    _elem1131.read(iprot);
                    struct.checkConstraints.add(_elem1131);
                }
                struct.setCheckConstraintsIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list1133 = new TList(11, iprot.readI32());
                struct.processorCapabilities = new ArrayList(_list1133.size);
                for (int _i1135 = 0; _i1135 < _list1133.size; ++_i1135) {
                    String _elem1134 = iprot.readString();
                    struct.processorCapabilities.add(_elem1134);
                }
                struct.setProcessorCapabilitiesIsSet(true);
            }
            if (incoming.get(8)) {
                struct.processorIdentifier = iprot.readString();
                struct.setProcessorIdentifierIsSet(true);
            }
        }
    }

    private static class CreateTableRequestTupleSchemeFactory
    implements SchemeFactory {
        private CreateTableRequestTupleSchemeFactory() {
        }

        public CreateTableRequestTupleScheme getScheme() {
            return new CreateTableRequestTupleScheme();
        }
    }

    private static class CreateTableRequestStandardScheme
    extends StandardScheme<CreateTableRequest> {
        private CreateTableRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, CreateTableRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.table = new Table();
                            struct.table.read(iprot);
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.envContext = new EnvironmentContext();
                            struct.envContext.read(iprot);
                            struct.setEnvContextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list1080 = iprot.readListBegin();
                            struct.primaryKeys = new ArrayList(_list1080.size);
                            for (int _i1082 = 0; _i1082 < _list1080.size; ++_i1082) {
                                SQLPrimaryKey _elem1081 = new SQLPrimaryKey();
                                _elem1081.read(iprot);
                                struct.primaryKeys.add(_elem1081);
                            }
                            iprot.readListEnd();
                            struct.setPrimaryKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list1083 = iprot.readListBegin();
                            struct.foreignKeys = new ArrayList(_list1083.size);
                            for (int _i1085 = 0; _i1085 < _list1083.size; ++_i1085) {
                                SQLForeignKey _elem1084 = new SQLForeignKey();
                                _elem1084.read(iprot);
                                struct.foreignKeys.add(_elem1084);
                            }
                            iprot.readListEnd();
                            struct.setForeignKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list1086 = iprot.readListBegin();
                            struct.uniqueConstraints = new ArrayList(_list1086.size);
                            for (int _i1088 = 0; _i1088 < _list1086.size; ++_i1088) {
                                SQLUniqueConstraint _elem1087 = new SQLUniqueConstraint();
                                _elem1087.read(iprot);
                                struct.uniqueConstraints.add(_elem1087);
                            }
                            iprot.readListEnd();
                            struct.setUniqueConstraintsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list1089 = iprot.readListBegin();
                            struct.notNullConstraints = new ArrayList(_list1089.size);
                            for (int _i1091 = 0; _i1091 < _list1089.size; ++_i1091) {
                                SQLNotNullConstraint _elem1090 = new SQLNotNullConstraint();
                                _elem1090.read(iprot);
                                struct.notNullConstraints.add(_elem1090);
                            }
                            iprot.readListEnd();
                            struct.setNotNullConstraintsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list1092 = iprot.readListBegin();
                            struct.defaultConstraints = new ArrayList(_list1092.size);
                            for (int _i1094 = 0; _i1094 < _list1092.size; ++_i1094) {
                                SQLDefaultConstraint _elem1093 = new SQLDefaultConstraint();
                                _elem1093.read(iprot);
                                struct.defaultConstraints.add(_elem1093);
                            }
                            iprot.readListEnd();
                            struct.setDefaultConstraintsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list1095 = iprot.readListBegin();
                            struct.checkConstraints = new ArrayList(_list1095.size);
                            for (int _i1097 = 0; _i1097 < _list1095.size; ++_i1097) {
                                SQLCheckConstraint _elem1096 = new SQLCheckConstraint();
                                _elem1096.read(iprot);
                                struct.checkConstraints.add(_elem1096);
                            }
                            iprot.readListEnd();
                            struct.setCheckConstraintsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list1098 = iprot.readListBegin();
                            struct.processorCapabilities = new ArrayList(_list1098.size);
                            for (int _i1100 = 0; _i1100 < _list1098.size; ++_i1100) {
                                String _elem1099 = iprot.readString();
                                struct.processorCapabilities.add(_elem1099);
                            }
                            iprot.readListEnd();
                            struct.setProcessorCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.processorIdentifier = iprot.readString();
                            struct.setProcessorIdentifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, CreateTableRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.table != null) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                struct.table.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.envContext != null && struct.isSetEnvContext()) {
                oprot.writeFieldBegin(ENV_CONTEXT_FIELD_DESC);
                struct.envContext.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.primaryKeys != null && struct.isSetPrimaryKeys()) {
                oprot.writeFieldBegin(PRIMARY_KEYS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.primaryKeys.size()));
                for (SQLPrimaryKey _iter1101 : struct.primaryKeys) {
                    _iter1101.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.foreignKeys != null && struct.isSetForeignKeys()) {
                oprot.writeFieldBegin(FOREIGN_KEYS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.foreignKeys.size()));
                for (SQLForeignKey _iter1102 : struct.foreignKeys) {
                    _iter1102.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.uniqueConstraints != null && struct.isSetUniqueConstraints()) {
                oprot.writeFieldBegin(UNIQUE_CONSTRAINTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.uniqueConstraints.size()));
                for (SQLUniqueConstraint _iter1103 : struct.uniqueConstraints) {
                    _iter1103.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.notNullConstraints != null && struct.isSetNotNullConstraints()) {
                oprot.writeFieldBegin(NOT_NULL_CONSTRAINTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.notNullConstraints.size()));
                for (SQLNotNullConstraint _iter1104 : struct.notNullConstraints) {
                    _iter1104.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.defaultConstraints != null && struct.isSetDefaultConstraints()) {
                oprot.writeFieldBegin(DEFAULT_CONSTRAINTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.defaultConstraints.size()));
                for (SQLDefaultConstraint _iter1105 : struct.defaultConstraints) {
                    _iter1105.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.checkConstraints != null && struct.isSetCheckConstraints()) {
                oprot.writeFieldBegin(CHECK_CONSTRAINTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.checkConstraints.size()));
                for (SQLCheckConstraint _iter1106 : struct.checkConstraints) {
                    _iter1106.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processorCapabilities != null && struct.isSetProcessorCapabilities()) {
                oprot.writeFieldBegin(PROCESSOR_CAPABILITIES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.processorCapabilities.size()));
                for (String _iter1107 : struct.processorCapabilities) {
                    oprot.writeString(_iter1107);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processorIdentifier != null && struct.isSetProcessorIdentifier()) {
                oprot.writeFieldBegin(PROCESSOR_IDENTIFIER_FIELD_DESC);
                oprot.writeString(struct.processorIdentifier);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class CreateTableRequestStandardSchemeFactory
    implements SchemeFactory {
        private CreateTableRequestStandardSchemeFactory() {
        }

        public CreateTableRequestStandardScheme getScheme() {
            return new CreateTableRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE(1, "table"),
        ENV_CONTEXT(2, "envContext"),
        PRIMARY_KEYS(3, "primaryKeys"),
        FOREIGN_KEYS(4, "foreignKeys"),
        UNIQUE_CONSTRAINTS(5, "uniqueConstraints"),
        NOT_NULL_CONSTRAINTS(6, "notNullConstraints"),
        DEFAULT_CONSTRAINTS(7, "defaultConstraints"),
        CHECK_CONSTRAINTS(8, "checkConstraints"),
        PROCESSOR_CAPABILITIES(9, "processorCapabilities"),
        PROCESSOR_IDENTIFIER(10, "processorIdentifier");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE;
                }
                case 2: {
                    return ENV_CONTEXT;
                }
                case 3: {
                    return PRIMARY_KEYS;
                }
                case 4: {
                    return FOREIGN_KEYS;
                }
                case 5: {
                    return UNIQUE_CONSTRAINTS;
                }
                case 6: {
                    return NOT_NULL_CONSTRAINTS;
                }
                case 7: {
                    return DEFAULT_CONSTRAINTS;
                }
                case 8: {
                    return CHECK_CONSTRAINTS;
                }
                case 9: {
                    return PROCESSOR_CAPABILITIES;
                }
                case 10: {
                    return PROCESSOR_IDENTIFIER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

