/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Schema
implements TBase<Schema, _Fields>,
Serializable,
Cloneable,
Comparable<Schema> {
    private static final TStruct STRUCT_DESC = new TStruct("Schema");
    private static final TField FIELD_SCHEMAS_FIELD_DESC = new TField("fieldSchemas", 15, 1);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private List<FieldSchema> fieldSchemas;
    private Map<String, String> properties;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Schema() {
    }

    public Schema(List<FieldSchema> fieldSchemas, Map<String, String> properties) {
        this();
        this.fieldSchemas = fieldSchemas;
        this.properties = properties;
    }

    public Schema(Schema other) {
        if (other.isSetFieldSchemas()) {
            ArrayList<FieldSchema> __this__fieldSchemas = new ArrayList<FieldSchema>(other.fieldSchemas.size());
            for (FieldSchema other_element : other.fieldSchemas) {
                __this__fieldSchemas.add(new FieldSchema(other_element));
            }
            this.fieldSchemas = __this__fieldSchemas;
        }
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>(other.properties);
            this.properties = __this__properties;
        }
    }

    public Schema deepCopy() {
        return new Schema(this);
    }

    @Override
    public void clear() {
        this.fieldSchemas = null;
        this.properties = null;
    }

    public int getFieldSchemasSize() {
        return this.fieldSchemas == null ? 0 : this.fieldSchemas.size();
    }

    public Iterator<FieldSchema> getFieldSchemasIterator() {
        return this.fieldSchemas == null ? null : this.fieldSchemas.iterator();
    }

    public void addToFieldSchemas(FieldSchema elem) {
        if (this.fieldSchemas == null) {
            this.fieldSchemas = new ArrayList<FieldSchema>();
        }
        this.fieldSchemas.add(elem);
    }

    public List<FieldSchema> getFieldSchemas() {
        return this.fieldSchemas;
    }

    public void setFieldSchemas(List<FieldSchema> fieldSchemas) {
        this.fieldSchemas = fieldSchemas;
    }

    public void unsetFieldSchemas() {
        this.fieldSchemas = null;
    }

    public boolean isSetFieldSchemas() {
        return this.fieldSchemas != null;
    }

    public void setFieldSchemasIsSet(boolean value) {
        if (!value) {
            this.fieldSchemas = null;
        }
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case FIELD_SCHEMAS: {
                if (value == null) {
                    this.unsetFieldSchemas();
                    break;
                }
                this.setFieldSchemas((List)value);
                break;
            }
            case PROPERTIES: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FIELD_SCHEMAS: {
                return this.getFieldSchemas();
            }
            case PROPERTIES: {
                return this.getProperties();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FIELD_SCHEMAS: {
                return this.isSetFieldSchemas();
            }
            case PROPERTIES: {
                return this.isSetProperties();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Schema) {
            return this.equals((Schema)that);
        }
        return false;
    }

    public boolean equals(Schema that) {
        if (that == null) {
            return false;
        }
        boolean this_present_fieldSchemas = this.isSetFieldSchemas();
        boolean that_present_fieldSchemas = that.isSetFieldSchemas();
        if (this_present_fieldSchemas || that_present_fieldSchemas) {
            if (!this_present_fieldSchemas || !that_present_fieldSchemas) {
                return false;
            }
            if (!this.fieldSchemas.equals(that.fieldSchemas)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_fieldSchemas = this.isSetFieldSchemas();
        list.add(present_fieldSchemas);
        if (present_fieldSchemas) {
            list.add(this.fieldSchemas);
        }
        boolean present_properties = this.isSetProperties();
        list.add(present_properties);
        if (present_properties) {
            list.add(this.properties);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Schema other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetFieldSchemas()).compareTo(other.isSetFieldSchemas());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFieldSchemas() && (lastComparison = TBaseHelper.compareTo(this.fieldSchemas, other.fieldSchemas)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProperties()).compareTo(other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo(this.properties, other.properties)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (Schema)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (Schema)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema(");
        boolean first = true;
        sb.append("fieldSchemas:");
        if (this.fieldSchemas == null) {
            sb.append("null");
        } else {
            sb.append(this.fieldSchemas);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("properties:");
        if (this.properties == null) {
            sb.append("null");
        } else {
            sb.append(this.properties);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new SchemaStandardSchemeFactory());
        schemes.put(TupleScheme.class, new SchemaTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FIELD_SCHEMAS, new FieldMetaData("fieldSchemas", 3, new ListMetaData(15, new StructMetaData(12, FieldSchema.class))));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Schema.class, metaDataMap);
    }

    private static class SchemaTupleScheme
    extends TupleScheme<Schema> {
        private SchemaTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, Schema struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetFieldSchemas()) {
                optionals.set(0);
            }
            if (struct.isSetProperties()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetFieldSchemas()) {
                oprot.writeI32(struct.fieldSchemas.size());
                for (FieldSchema fieldSchema : struct.fieldSchemas) {
                    fieldSchema.write(oprot);
                }
            }
            if (struct.isSetProperties()) {
                oprot.writeI32(struct.properties.size());
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
        }

        @Override
        public void read(TProtocol prot, Schema struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                TList _list335 = new TList(12, iprot.readI32());
                struct.fieldSchemas = new ArrayList(_list335.size);
                for (int _i337 = 0; _i337 < _list335.size; ++_i337) {
                    FieldSchema _elem336 = new FieldSchema();
                    _elem336.read(iprot);
                    struct.fieldSchemas.add(_elem336);
                }
                struct.setFieldSchemasIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map338 = new TMap(11, 11, iprot.readI32());
                struct.properties = new HashMap(2 * _map338.size);
                for (int _i341 = 0; _i341 < _map338.size; ++_i341) {
                    String _key339 = iprot.readString();
                    String _val340 = iprot.readString();
                    struct.properties.put(_key339, _val340);
                }
                struct.setPropertiesIsSet(true);
            }
        }
    }

    private static class SchemaTupleSchemeFactory
    implements SchemeFactory {
        private SchemaTupleSchemeFactory() {
        }

        public SchemaTupleScheme getScheme() {
            return new SchemaTupleScheme();
        }
    }

    private static class SchemaStandardScheme
    extends StandardScheme<Schema> {
        private SchemaStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, Schema struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list324 = iprot.readListBegin();
                            struct.fieldSchemas = new ArrayList(_list324.size);
                            for (int _i326 = 0; _i326 < _list324.size; ++_i326) {
                                FieldSchema _elem325 = new FieldSchema();
                                _elem325.read(iprot);
                                struct.fieldSchemas.add(_elem325);
                            }
                            iprot.readListEnd();
                            struct.setFieldSchemasIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 13) {
                            TMap _map327 = iprot.readMapBegin();
                            struct.properties = new HashMap(2 * _map327.size);
                            for (int _i330 = 0; _i330 < _map327.size; ++_i330) {
                                String _key328 = iprot.readString();
                                String _val329 = iprot.readString();
                                struct.properties.put(_key328, _val329);
                            }
                            iprot.readMapEnd();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, Schema struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.fieldSchemas != null) {
                oprot.writeFieldBegin(FIELD_SCHEMAS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.fieldSchemas.size()));
                for (FieldSchema fieldSchema : struct.fieldSchemas) {
                    fieldSchema.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.properties != null) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.properties.size()));
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SchemaStandardSchemeFactory
    implements SchemeFactory {
        private SchemaStandardSchemeFactory() {
        }

        public SchemaStandardScheme getScheme() {
            return new SchemaStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FIELD_SCHEMAS(1, "fieldSchemas"),
        PROPERTIES(2, "properties");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FIELD_SCHEMAS;
                }
                case 2: {
                    return PROPERTIES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

