/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.OpenTxn;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;

public class OpenTxnList {
    private long hwm;
    private List<OpenTxn> openTxnList;

    public OpenTxnList(long hwm, List<OpenTxn> openTxnList) {
        this.hwm = hwm;
        this.openTxnList = openTxnList;
    }

    public GetOpenTxnsInfoResponse toOpenTxnsInfoResponse() {
        return new GetOpenTxnsInfoResponse(this.getHwm(), this.openTxnList.stream().map(OpenTxn::toTxnInfo).collect(Collectors.toList()));
    }

    public long getHwm() {
        return this.hwm;
    }

    public List<OpenTxn> getOpenTxnList() {
        return this.openTxnList;
    }

    public GetOpenTxnsResponse toOpenTxnsResponse(List<TxnType> excludeTxnTypes) {
        ArrayList<Long> openList = new ArrayList<Long>();
        long minOpenTxn = Long.MAX_VALUE;
        BitSet abortedBits = new BitSet();
        for (OpenTxn openTxn : this.getOpenTxnList()) {
            if (openTxn.getStatus() == TxnStatus.OPEN) {
                minOpenTxn = Math.min(minOpenTxn, openTxn.getTxnId());
            }
            if (excludeTxnTypes.contains(openTxn.getType())) continue;
            openList.add(openTxn.getTxnId());
            if (openTxn.getStatus() != TxnStatus.ABORTED) continue;
            abortedBits.set(openList.size() - 1);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
        GetOpenTxnsResponse otr = new GetOpenTxnsResponse(this.getHwm(), openList, byteBuffer);
        if (minOpenTxn < Long.MAX_VALUE) {
            otr.setMin_open_txn(minOpenTxn);
        }
        return otr;
    }
}

