/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;

public class QueryState {
    private final HiveConf queryConf;
    private HiveOperation commandType;
    private LineageState lineageState = new LineageState();
    private HiveTxnManager txnManager;
    private long numModifiedRows = 0L;

    private QueryState(HiveConf conf) {
        this.queryConf = conf;
    }

    public String getQueryId() {
        return this.queryConf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public String getQueryString() {
        return this.queryConf.getQueryString();
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public HiveConf getConf() {
        return this.queryConf;
    }

    public LineageState getLineageState() {
        return this.lineageState;
    }

    public void setLineageState(LineageState lineageState) {
        this.lineageState = lineageState;
    }

    public HiveTxnManager getTxnManager() {
        return this.txnManager;
    }

    public void setTxnManager(HiveTxnManager txnManager) {
        this.txnManager = txnManager;
    }

    public long getNumModifiedRows() {
        return this.numModifiedRows;
    }

    public void setNumModifiedRows(long numModifiedRows) {
        this.numModifiedRows = numModifiedRows;
    }

    public String getQueryTag() {
        return HiveConf.getVar(this.queryConf, HiveConf.ConfVars.HIVEQUERYTAG);
    }

    public void setQueryTag(String queryTag) {
        HiveConf.setVar(this.queryConf, HiveConf.ConfVars.HIVEQUERYTAG, queryTag);
    }

    public static void setApplicationTag(HiveConf queryConf, String queryTag) {
        String jobTag = HiveConf.getVar(queryConf, HiveConf.ConfVars.HIVEQUERYTAG);
        jobTag = jobTag == null || jobTag.isEmpty() ? queryTag : jobTag.concat("," + queryTag);
        if (SessionState.get() != null) {
            jobTag = jobTag.concat(",userid=" + SessionState.get().getUserName());
        }
        queryConf.set("mapreduce.job.tags", jobTag);
        queryConf.set("tez.application.tags", jobTag);
    }

    public static QueryState getNewQueryState(HiveConf conf, LineageState lineageState) {
        return new Builder().withGenerateNewQueryId(true).withHiveConf(conf).withLineageState(lineageState).build();
    }

    public static class Builder {
        private Map<String, String> confOverlay = null;
        private boolean isolated = true;
        private boolean generateNewQueryId = false;
        private HiveConf hiveConf = null;
        private LineageState lineageState = null;

        public Builder withConfOverlay(Map<String, String> confOverlay) {
            this.confOverlay = confOverlay;
            return this;
        }

        public Builder nonIsolated() {
            this.isolated = false;
            return this;
        }

        public Builder withGenerateNewQueryId(boolean generateNewQueryId) {
            this.generateNewQueryId = generateNewQueryId;
            return this;
        }

        public Builder withHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
            return this;
        }

        public Builder withLineageState(LineageState lineageState) {
            this.lineageState = lineageState;
            return this;
        }

        public QueryState build() {
            HiveConf queryConf = this.isolated ? (this.hiveConf == null ? new HiveConf() : new HiveConf(this.hiveConf)) : this.hiveConf;
            if (this.confOverlay != null && !this.confOverlay.isEmpty()) {
                for (Map.Entry<String, String> confEntry : this.confOverlay.entrySet()) {
                    try {
                        queryConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Error applying statement specific settings", e);
                    }
                }
            }
            if (this.generateNewQueryId) {
                String queryId = QueryPlan.makeQueryId();
                queryConf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
                QueryState.setApplicationTag(queryConf, queryId);
                if (this.hiveConf != null) {
                    this.hiveConf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
                }
            }
            QueryState queryState = new QueryState(queryConf);
            if (this.lineageState != null) {
                queryState.setLineageState(this.lineageState);
            }
            return queryState;
        }
    }
}

