/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hive.common.util.TxnIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidTxnManager {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private final Driver driver;
    private final DriverContext driverContext;

    ValidTxnManager(Driver driver, DriverContext driverContext) {
        this.driver = driver;
        this.driverContext = driverContext;
    }

    boolean isValidTxnListState() throws LockException {
        String currentTxnString;
        long txnId;
        String txnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (txnString == null) {
            return true;
        }
        Set<String> nonSharedLockedTables = this.getNonSharedLockedTables();
        if (nonSharedLockedTables.isEmpty()) {
            return true;
        }
        String txnWriteIdListString = this.driverContext.getConf().get("hive.txn.tables.valid.writeids");
        if (StringUtils.isEmpty(txnWriteIdListString)) {
            return true;
        }
        GetOpenTxnsResponse openTxns = this.driverContext.getTxnManager().getOpenTxns();
        ValidTxnList validTxnList = TxnUtils.createValidReadTxnList(openTxns, 0L);
        if (validTxnList.isTxnRangeValid((txnId = this.driverContext.getTxnManager().getCurrentTxnId()) + 1L, openTxns.getTxn_high_water_mark()) != ValidTxnList.RangeResponse.NONE) {
            validTxnList.removeException(txnId);
            currentTxnString = validTxnList.toString();
        } else {
            currentTxnString = TxnUtils.createValidReadTxnList(openTxns, txnId).toString();
        }
        if (currentTxnString.equals(txnString)) {
            return true;
        }
        return this.checkWriteIds(currentTxnString, nonSharedLockedTables, txnWriteIdListString);
    }

    private Set<String> getNonSharedLockedTables() {
        if (CollectionUtils.isEmpty(this.driver.getContext().getHiveLocks())) {
            return Collections.emptySet();
        }
        HashSet<String> nonSharedLockedTables = new HashSet<String>();
        for (HiveLock lock2 : this.driver.getContext().getHiveLocks()) {
            if (lock2.mayContainComponents()) {
                for (LockComponent lockComponent : lock2.getHiveLockComponents()) {
                    if (lockComponent.getType() != LockType.EXCLUSIVE && lockComponent.getType() != LockType.EXCL_WRITE || lockComponent.getTablename() == null || "__GLOBAL_LOCKS".equals(lockComponent.getDbname())) continue;
                    nonSharedLockedTables.add(TableName.getDbTable(lockComponent.getDbname(), lockComponent.getTablename()));
                }
                continue;
            }
            if (lock2.getHiveLockMode() != HiveLockMode.EXCLUSIVE && lock2.getHiveLockMode() != HiveLockMode.SEMI_SHARED || lock2.getHiveLockObject().getPaths().length != 2) continue;
            nonSharedLockedTables.add(TableName.getDbTable(lock2.getHiveLockObject().getPaths()[0], lock2.getHiveLockObject().getPaths()[1]));
        }
        return nonSharedLockedTables;
    }

    private boolean checkWriteIds(String currentTxnString, Set<String> nonSharedLockedTables, String txnWriteIdListString) throws LockException {
        ValidTxnWriteIdList txnWriteIdList = new ValidTxnWriteIdList(txnWriteIdListString);
        Map<String, Table> writtenTables = this.getTables(false, true);
        ValidTxnWriteIdList currentTxnWriteIds = this.driverContext.getTxnManager().getValidWriteIds(this.getTransactionalTables(writtenTables), currentTxnString);
        for (Map.Entry<String, Table> tableInfo : writtenTables.entrySet()) {
            String fullQNameForLock = TableName.getDbTable(tableInfo.getValue().getDbName(), MetaStoreUtils.encodeTableName(tableInfo.getValue().getTableName()));
            if (!nonSharedLockedTables.contains(fullQNameForLock)) continue;
            if (AcidUtils.isTransactionalTable(tableInfo.getValue())) {
                ValidWriteIdList writeIdList = txnWriteIdList.getTableValidWriteIdList(tableInfo.getKey());
                ValidWriteIdList currentWriteIdList = currentTxnWriteIds.getTableValidWriteIdList(tableInfo.getKey());
                if (currentWriteIdList.isWriteIdRangeValid(writeIdList.getHighWatermark() + 1L, currentWriteIdList.getHighWatermark()) != ValidWriteIdList.RangeResponse.NONE) {
                    this.driverContext.setOutdatedTxn(true);
                    return false;
                }
                if (!TxnIdUtils.checkEquivalentWriteIds(writeIdList, currentWriteIdList)) {
                    return false;
                }
            }
            nonSharedLockedTables.remove(fullQNameForLock);
        }
        if (!nonSharedLockedTables.isEmpty()) {
            throw new LockException("Wrong state: non-shared locks contain information for tables that have not been visited when trying to validate the locks from query tables.\nTables: " + writtenTables.keySet() + "\n" + "Remaining locks after check: " + nonSharedLockedTables);
        }
        return true;
    }

    ValidTxnWriteIdList recordValidWriteIds() throws LockException {
        String txnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (StringUtils.isEmpty(txnString)) {
            throw new IllegalStateException("calling recordValidWritsIdss() without initializing ValidTxnList " + JavaUtils.txnIdToString(this.driverContext.getTxnManager().getCurrentTxnId()));
        }
        ValidTxnWriteIdList txnWriteIds = this.getTxnWriteIds(txnString);
        this.setValidWriteIds(txnWriteIds);
        LOG.debug("Encoding valid txn write ids info {} txnid: {}", (Object)txnWriteIds.toString(), (Object)this.driverContext.getTxnManager().getCurrentTxnId());
        return txnWriteIds;
    }

    private ValidTxnWriteIdList getTxnWriteIds(String txnString) throws LockException {
        List<String> txnTables = this.getTransactionalTables(this.getTables(true, true));
        ValidTxnWriteIdList txnWriteIds = null;
        if (this.driverContext.getCompactionWriteIds() != null) {
            if (txnTables.size() != 1) {
                throw new LockException("Unexpected tables in compaction: " + txnTables);
            }
            txnWriteIds = new ValidTxnWriteIdList(this.driverContext.getCompactorTxnId());
            txnWriteIds.addTableValidWriteIdList(this.driverContext.getCompactionWriteIds());
        } else {
            txnWriteIds = this.driverContext.getTxnManager().getValidWriteIds(txnTables, txnString);
        }
        if (this.driverContext.getTxnType() == TxnType.READ_ONLY && !this.getTables(false, true).isEmpty()) {
            throw new IllegalStateException(String.format("Inferred transaction type '%s' doesn't conform to the actual query string '%s'", this.driverContext.getTxnType(), this.driverContext.getQueryState().getQueryString()));
        }
        return txnWriteIds;
    }

    private void setValidWriteIds(ValidTxnWriteIdList txnWriteIds) {
        Operator<?> source;
        this.driverContext.getConf().set("hive.txn.tables.valid.writeids", txnWriteIds.toString());
        if (this.driverContext.getPlan().getFetchTask() != null && (source = ((FetchWork)this.driverContext.getPlan().getFetchTask().getWork()).getSource()) instanceof TableScanOperator) {
            TableScanOperator tsOp = (TableScanOperator)source;
            String fullTableName = AcidUtils.getFullTableName(((TableScanDesc)tsOp.getConf()).getDatabaseName(), ((TableScanDesc)tsOp.getConf()).getTableName());
            ValidWriteIdList writeIdList = txnWriteIds.getTableValidWriteIdList(fullTableName);
            if (((TableScanDesc)tsOp.getConf()).isTranscationalTable() && writeIdList == null) {
                throw new IllegalStateException(String.format("ACID table: %s is missing from the ValidWriteIdList config: %s", fullTableName, txnWriteIds.toString()));
            }
            if (writeIdList != null) {
                this.driverContext.getPlan().getFetchTask().setValidWriteIdList(writeIdList.toString());
            }
        }
    }

    private Map<String, Table> getTables(boolean inputNeeded, boolean outputNeeded) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        if (inputNeeded) {
            this.driverContext.getPlan().getInputs().forEach(input -> this.addTableFromEntity((Entity)input, (Map<String, Table>)tables));
        }
        if (outputNeeded) {
            this.driverContext.getPlan().getOutputs().forEach(output -> this.addTableFromEntity((Entity)output, (Map<String, Table>)tables));
        }
        return tables;
    }

    private void addTableFromEntity(Entity entity, Map<String, Table> tables) {
        Table table;
        switch (entity.getType()) {
            case TABLE: {
                table = entity.getTable();
                break;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                table = entity.getPartition().getTable();
                break;
            }
            default: {
                return;
            }
        }
        String fullTableName = AcidUtils.getFullTableName(table.getDbName(), table.getTableName());
        tables.put(fullTableName, table);
    }

    private List<String> getTransactionalTables(Map<String, Table> tables) {
        return tables.entrySet().stream().filter(entry -> AcidUtils.isTransactionalTable((Table)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

