/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

public final class DDLWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DDLDesc ddlDesc;
    private boolean needLock = false;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;
    private boolean isReplication;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public DDLWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs, DDLDesc ddlDesc, boolean isReplication, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.ddlDesc = ddlDesc;
        this.isReplication = isReplication;
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public DDLWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs, DDLDesc ddlDesc) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.ddlDesc = ddlDesc;
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public boolean isReplication() {
        return this.isReplication;
    }

    public boolean getNeedLock() {
        return this.needLock;
    }

    public void setNeedLock(boolean needLock) {
        this.needLock = needLock;
    }

    @Explain(skipHeader=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public DDLDesc getDDLDesc() {
        return this.ddlDesc;
    }
}

