/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.drop;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={867})
public class DropDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public DropDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = DropDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean ifExists = root.getFirstChildWithType(911) != null;
        boolean cascade = root.getFirstChildWithType(818) != null;
        Database database = this.getDatabase(databaseName, !ifExists);
        if (database == null) {
            return;
        }
        if (cascade) {
            try {
                List<String> tableNames = this.db.getAllTables(databaseName);
                if (tableNames != null) {
                    for (String tableName : tableNames) {
                        Table table = this.getTable(databaseName, tableName, true);
                        this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
                    }
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
        this.inputs.add(new ReadEntity(database));
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_EXCLUSIVE));
        DropDatabaseDesc desc = new DropDatabaseDesc(databaseName, ifExists, cascade, new ReplicationSpec());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

