/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.show;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.IOUtils;

public class ShowDatabasesOperation
extends DDLOperation<ShowDatabasesDesc> {
    public ShowDatabasesOperation(DDLOperationContext context, ShowDatabasesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        List<String> databases = null;
        if (((ShowDatabasesDesc)this.desc).getPattern() != null) {
            LOG.debug("pattern: {}", (Object)((ShowDatabasesDesc)this.desc).getPattern());
            databases = this.context.getDb().getDatabasesByPattern(((ShowDatabasesDesc)this.desc).getPattern());
        } else {
            databases = this.context.getDb().getAllDatabases();
        }
        LOG.info("Found {} database(s) matching the SHOW DATABASES statement.", (Object)databases.size());
        DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowDatabasesDesc)this.desc).getResFile()), this.context);
        try {
            this.context.getFormatter().showDatabases(outStream, databases);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show databases");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

