/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.use;

import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.use.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1092})
public class SwitchDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public SwitchDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = SwitchDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        Database database = this.getDatabase(databaseName, true);
        ReadEntity readEntity = new ReadEntity(database);
        readEntity.noLockNeeded();
        this.inputs.add(readEntity);
        SwitchDatabaseDesc desc = new SwitchDatabaseDesc(databaseName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

