/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.desc;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.function.desc.DescFunctionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={859})
public class DescFunctionAnalyzer
extends AbstractFunctionAnalyzer {
    public DescFunctionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        if (root.getChildCount() < 1 || root.getChildCount() > 2) {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        String functionName = DescFunctionAnalyzer.stripQuotes(root.getChild(0).getText());
        boolean isExtended = root.getChildCount() == 2;
        DescFunctionDesc desc = new DescFunctionDesc(this.ctx.getResFile(), functionName, isExtended);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("tab_name#string"));
    }
}

