/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.msck;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Metastore Check", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class MsckDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final List<Map<String, String>> partitionsSpecs;
    private final String resFile;
    private final boolean repairPartitions;
    private final boolean addPartitions;
    private final boolean dropPartitions;

    public MsckDesc(String tableName, List<Map<String, String>> partitionsSpecs, Path resFile, boolean repairPartitions, boolean addPartitions, boolean dropPartitions) {
        this.tableName = tableName;
        this.partitionsSpecs = partitionsSpecs;
        this.resFile = resFile.toString();
        this.repairPartitions = repairPartitions;
        this.addPartitions = addPartitions;
        this.dropPartitions = dropPartitions;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="partitions specs", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<Map<String, String>> getPartitionsSpecs() {
        return this.partitionsSpecs;
    }

    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="repair partition", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isRepairPartitions() {
        return this.repairPartitions;
    }

    @Explain(displayName="add partition", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isAddPartitions() {
        return this.addPartitions;
    }

    @Explain(displayName="drop partition", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isDropPartitions() {
        return this.dropPartitions;
    }
}

