/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.show.principals;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.privilege.AbstractPrivilegeAnalyzer;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1070})
public class ShowPrincipalsAnalyzer
extends AbstractPrivilegeAnalyzer {
    public ShowPrincipalsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @VisibleForTesting
    public ShowPrincipalsAnalyzer(QueryState queryState, Hive db) throws SemanticException {
        super(queryState, db);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createShowRolePrincipalsTask(root, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
            task.setFetchSource(true);
            this.setFetchTask(this.createFetchTask("principal_name,principal_type,grant_option,grantor,grantor_type,grant_time#string:string:boolean:string:string:bigint"));
        }
    }
}

