/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public final class AlterTableUtils {
    private AlterTableUtils() {
        throw new UnsupportedOperationException("AlterTableUtils should not be instantiated");
    }

    public static boolean allowOperationInReplicationScope(Hive db, String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) throws HiveException {
        if (null == replicationSpec || !replicationSpec.isInReplicationScope()) {
            return true;
        }
        Table existingTable = db.getTable(tableName, false);
        if (existingTable != null && replicationSpec.allowEventReplacementInto(existingTable.getParameters())) {
            if (partSpec != null) {
                Partition existingPtn = db.getPartition(existingTable, partSpec, false);
                return existingPtn != null && replicationSpec.allowEventReplacementInto(existingPtn.getParameters());
            }
            return true;
        }
        return false;
    }

    public static boolean isSchemaEvolutionEnabled(Table table, Configuration conf) {
        return AcidUtils.isTablePropertyTransactional(table.getMetadata()) || HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
    }

    public static boolean isFullPartitionSpec(Table table, Map<String, String> partitionSpec) {
        for (FieldSchema partitionCol : table.getPartCols()) {
            if (partitionSpec.get(partitionCol.getName()) != null) continue;
            return false;
        }
        return true;
    }
}

