/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.replace;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.column.replace.AlterTableReplaceColumnsDesc;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;

public class AlterTableReplaceColumnsOperation
extends AbstractAlterTableOperation<AlterTableReplaceColumnsDesc> {
    private static final Set<String> VALID_SERIALIZATION_LIBS = ImmutableSet.of(MetadataTypedColumnsetSerDe.class.getName(), LazySimpleSerDe.class.getName(), ColumnarSerDe.class.getName(), DynamicSerDe.class.getName(), ParquetHiveSerDe.class.getName(), OrcSerde.class.getName(), new String[0]);

    public AlterTableReplaceColumnsOperation(DDLOperationContext context, AlterTableReplaceColumnsDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        boolean droppingColumns;
        boolean isOrcSchemaEvolution;
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String serializationLib = sd.getSerdeInfo().getSerializationLib();
        if ("org.apache.hadoop.hive.serde.thrift.columnsetSerDe".equals(serializationLib)) {
            this.context.getConsole().printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
            sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
        } else if (!VALID_SERIALIZATION_LIBS.contains(serializationLib)) {
            throw new HiveException(ErrorMsg.CANNOT_REPLACE_COLUMNS, ((AlterTableReplaceColumnsDesc)this.desc).getDbTableName());
        }
        boolean bl = isOrcSchemaEvolution = serializationLib.equals(OrcSerde.class.getName()) && AlterTableUtils.isSchemaEvolutionEnabled(table, this.context.getConf());
        if (isOrcSchemaEvolution) {
            List<FieldSchema> existingCols = sd.getCols();
            List<FieldSchema> replaceCols = ((AlterTableReplaceColumnsDesc)this.desc).getNewColumns();
            if (replaceCols.size() < existingCols.size()) {
                throw new HiveException(ErrorMsg.REPLACE_CANNOT_DROP_COLUMNS, ((AlterTableReplaceColumnsDesc)this.desc).getDbTableName());
            }
        }
        boolean bl2 = droppingColumns = ((AlterTableReplaceColumnsDesc)this.desc).getNewColumns().size() < sd.getCols().size();
        if (ParquetHiveSerDe.isParquetTable(table) && AlterTableUtils.isSchemaEvolutionEnabled(table, this.context.getConf()) && !((AlterTableReplaceColumnsDesc)this.desc).isCascade() && droppingColumns && table.isPartitioned()) {
            LOG.warn("Cannot drop columns from a partitioned parquet table without the CASCADE option");
            throw new HiveException(ErrorMsg.REPLACE_CANNOT_DROP_COLUMNS, ((AlterTableReplaceColumnsDesc)this.desc).getDbTableName());
        }
        sd.setCols(((AlterTableReplaceColumnsDesc)this.desc).getNewColumns());
    }
}

