/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.update;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.column.update.AlterTableUpdateColumnsDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={787})
public class AlterTableUpdateColumnsAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableUpdateColumnsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        boolean isCascade = null != command.getFirstChildWithType(818);
        AlterTableUpdateColumnsDesc desc = new AlterTableUpdateColumnsDesc(tableName, partitionSpec, isCascade);
        Table table = this.getTable(tableName);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc), this.conf));
    }
}

