/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.like;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hive.common.util.AnnotationUtils;

public class CreateTableLikeOperation
extends DDLOperation<CreateTableLikeDesc> {
    public CreateTableLikeOperation(DDLOperationContext context, CreateTableLikeDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldTable = this.context.getDb().getTable(((CreateTableLikeDesc)this.desc).getLikeTableName());
        Table tbl = oldTable.getTableType() == TableType.VIRTUAL_VIEW || oldTable.getTableType() == TableType.MATERIALIZED_VIEW ? this.createViewLikeTable(oldTable) : this.createTableLikeTable(oldTable);
        if (CreateTableOperation.doesTableNeedLocation(tbl)) {
            CreateTableOperation.makeLocationQualified(tbl, this.context.getConf());
        }
        if (((CreateTableLikeDesc)this.desc).getLocation() == null && !tbl.isPartitioned() && this.context.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            StatsSetupConst.setStatsStateForCreateTable(tbl.getTTable().getParameters(), MetaStoreUtils.getColumnNames(tbl.getCols()), "true");
        }
        this.context.getDb().createTable(tbl, ((CreateTableLikeDesc)this.desc).getIfNotExists());
        DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        return 0;
    }

    private Table createViewLikeTable(Table oldTable) throws HiveException {
        Table table = this.context.getDb().newTable(((CreateTableLikeDesc)this.desc).getTableName());
        if (((CreateTableLikeDesc)this.desc).getTblProps() != null) {
            table.getTTable().getParameters().putAll(((CreateTableLikeDesc)this.desc).getTblProps());
        }
        table.setTableType(TableType.MANAGED_TABLE);
        if (((CreateTableLikeDesc)this.desc).isExternal()) {
            this.setExternalProperties(table);
        }
        this.setUserSpecifiedLocation(table);
        table.setFields(oldTable.getCols());
        table.setPartCols(oldTable.getPartCols());
        if (((CreateTableLikeDesc)this.desc).getDefaultSerdeProps() != null) {
            for (Map.Entry<String, String> e : ((CreateTableLikeDesc)this.desc).getDefaultSerdeProps().entrySet()) {
                table.setSerdeParam(e.getKey(), e.getValue());
            }
        }
        this.setStorage(table);
        return table;
    }

    private Table createTableLikeTable(Table table) throws SemanticException, HiveException {
        String[] names = Utilities.getDbTableName(((CreateTableLikeDesc)this.desc).getTableName());
        table.setDbName(names[0]);
        table.setTableName(names[1]);
        table.setOwner(SessionState.getUserFromAuthenticator());
        this.setUserSpecifiedLocation(table);
        this.setTableParameters(table);
        if (((CreateTableLikeDesc)this.desc).isUserStorageFormat()) {
            this.setStorage(table);
        }
        table.getTTable().setTemporary(((CreateTableLikeDesc)this.desc).isTemporary());
        table.getTTable().unsetId();
        if (((CreateTableLikeDesc)this.desc).isExternal()) {
            this.setExternalProperties(table);
        } else {
            table.getParameters().remove("EXTERNAL");
        }
        return table;
    }

    private void setUserSpecifiedLocation(Table table) {
        if (((CreateTableLikeDesc)this.desc).getLocation() != null) {
            table.setDataLocation(new Path(((CreateTableLikeDesc)this.desc).getLocation()));
        } else {
            table.unsetDataLocation();
        }
    }

    private void setTableParameters(Table tbl) throws HiveException {
        String paramsStr;
        Class<? extends Deserializer> serdeClass;
        HashSet<String> retainer = new HashSet<String>();
        try {
            serdeClass = tbl.getDeserializerClass();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        SerDeSpec spec = AnnotationUtils.getAnnotation(serdeClass, SerDeSpec.class);
        retainer.add("storage_handler");
        if (spec != null && spec.schemaProps() != null) {
            retainer.addAll(Arrays.asList(spec.schemaProps()));
        }
        if ((paramsStr = HiveConf.getVar(this.context.getConf(), HiveConf.ConfVars.DDL_CTL_PARAMETERS_WHITELIST)) != null) {
            retainer.addAll(Arrays.asList(paramsStr.split(",")));
        }
        Map<String, String> params = tbl.getParameters();
        if (!retainer.isEmpty()) {
            params.keySet().retainAll(retainer);
        } else {
            params.clear();
        }
        if (((CreateTableLikeDesc)this.desc).getTblProps() != null) {
            params.putAll(((CreateTableLikeDesc)this.desc).getTblProps());
        }
    }

    private void setStorage(Table table) throws HiveException {
        table.setInputFormatClass(((CreateTableLikeDesc)this.desc).getDefaultInputFormat());
        table.setOutputFormatClass(((CreateTableLikeDesc)this.desc).getDefaultOutputFormat());
        table.getTTable().getSd().setInputFormat(table.getInputFormatClass().getName());
        table.getTTable().getSd().setOutputFormat(table.getOutputFormatClass().getName());
        if (((CreateTableLikeDesc)this.desc).getDefaultSerName() == null) {
            LOG.info("Default to LazySimpleSerDe for table {}", (Object)((CreateTableLikeDesc)this.desc).getTableName());
            table.setSerializationLib(LazySimpleSerDe.class.getName());
        } else {
            DDLUtils.validateSerDe(((CreateTableLikeDesc)this.desc).getDefaultSerName(), this.context);
            table.setSerializationLib(((CreateTableLikeDesc)this.desc).getDefaultSerName());
        }
    }

    private void setExternalProperties(Table tbl) {
        tbl.setProperty("EXTERNAL", "TRUE");
        tbl.setTableType(TableType.EXTERNAL_TABLE);
        if (tbl.isPartitioned() && tbl.getProperty("discover.partitions") == null) {
            tbl.setProperty("discover.partitions", "true");
        }
    }
}

