/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.show;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hive.common.util.HiveStringUtils;
import org.stringtemplate.v4.ST;

public class ShowCreateTableOperation
extends DDLOperation<ShowCreateTableDesc> {
    private static final String EXTERNAL = "external";
    private static final String TEMPORARY = "temporary";
    private static final String NAME = "name";
    private static final String LIST_COLUMNS = "columns";
    private static final String COMMENT = "comment";
    private static final String PARTITIONS = "partitions";
    private static final String BUCKETS = "buckets";
    private static final String SKEWED = "skewedinfo";
    private static final String ROW_FORMAT = "row_format";
    private static final String LOCATION_BLOCK = "location_block";
    private static final String LOCATION = "location";
    private static final String PROPERTIES = "properties";
    private static final String CREATE_VIEW_COMMAND = "CREATE VIEW `%s` AS %s";
    private static final String CREATE_TABLE_TEMPLATE = "CREATE <temporary><external>TABLE `<name>`(\n<columns>)\n<comment>\n<partitions>\n<buckets>\n<skewedinfo>\n<row_format>\n<location_block>TBLPROPERTIES (\n<properties>)\n";
    private static final String CREATE_TABLE_TEMPLATE_LOCATION = "LOCATION\n<location>\n";
    private static final Set<String> PROPERTIES_TO_IGNORE_AT_TBLPROPERTIES = Sets.union(ImmutableSet.of("TEMPORARY", "EXTERNAL", "comment", "SORTBUCKETCOLSPREFIX", "storage_handler"), new HashSet<String>(StatsSetupConst.TABLE_PARAMS_STATS_KEYS));

    public ShowCreateTableOperation(DDLOperationContext context, ShowCreateTableDesc desc) {
        super(context, desc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowCreateTableDesc)this.desc).getResFile()), this.context);){
            Table table = this.context.getDb().getTable(((ShowCreateTableDesc)this.desc).getTableName(), false);
            String command = table.isView() ? this.getCreateViewCommand(table) : this.getCreateTableCommand(table);
            outStream.write(command.getBytes(StandardCharsets.UTF_8));
            int n = 0;
            return n;
        }
        catch (IOException e) {
            LOG.info("show create table: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private String getCreateViewCommand(Table table) {
        return String.format(CREATE_VIEW_COMMAND, ((ShowCreateTableDesc)this.desc).getTableName(), table.getViewExpandedText());
    }

    private String getCreateTableCommand(Table table) {
        ST command = new ST(CREATE_TABLE_TEMPLATE);
        command.add(NAME, (Object)((ShowCreateTableDesc)this.desc).getTableName());
        command.add(TEMPORARY, (Object)this.getTemporary(table));
        command.add(EXTERNAL, (Object)this.getExternal(table));
        command.add(LIST_COLUMNS, (Object)this.getColumns(table));
        command.add(COMMENT, (Object)this.getComment(table));
        command.add(PARTITIONS, (Object)this.getPartitions(table));
        command.add(BUCKETS, (Object)this.getBuckets(table));
        command.add(SKEWED, (Object)this.getSkewed(table));
        command.add(ROW_FORMAT, (Object)this.getRowFormat(table));
        command.add(LOCATION_BLOCK, (Object)this.getLocationBlock(table));
        command.add(PROPERTIES, (Object)this.getProperties(table));
        return command.render();
    }

    private String getTemporary(Table table) {
        return table.isTemporary() ? "TEMPORARY " : "";
    }

    private String getExternal(Table table) {
        return table.getTableType() == TableType.EXTERNAL_TABLE ? "EXTERNAL " : "";
    }

    private String getColumns(Table table) {
        ArrayList<String> columnDescs = new ArrayList<String>();
        for (FieldSchema col : table.getCols()) {
            String columnDesc = "  `" + col.getName() + "` " + this.formatType(TypeInfoUtils.getTypeInfoFromTypeString(col.getType()));
            if (col.getComment() != null) {
                columnDesc = columnDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(col.getComment()) + "'";
            }
            columnDescs.add(columnDesc);
        }
        return StringUtils.join(columnDescs, ", \n");
    }

    private String formatType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return typeInfo.getTypeName();
            }
            case STRUCT: {
                StringBuilder structFormattedType = new StringBuilder();
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                for (int i = 0; i < structTypeInfo.getAllStructFieldNames().size(); ++i) {
                    if (structFormattedType.length() != 0) {
                        structFormattedType.append(", ");
                    }
                    String structElementName = structTypeInfo.getAllStructFieldNames().get(i);
                    String structElementType = this.formatType(structTypeInfo.getAllStructFieldTypeInfos().get(i));
                    structFormattedType.append("`" + structElementName + "`:" + structElementType);
                }
                return "struct<" + structFormattedType.toString() + ">";
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                String elementType = this.formatType(listTypeInfo.getListElementTypeInfo());
                return "array<" + elementType + ">";
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                String keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo().getTypeName();
                String valueTypeInfo = this.formatType(mapTypeInfo.getMapValueTypeInfo());
                return "map<" + keyTypeInfo + "," + valueTypeInfo + ">";
            }
            case UNION: {
                StringBuilder unionFormattedType = new StringBuilder();
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                for (TypeInfo unionElementTypeInfo : unionTypeInfo.getAllUnionObjectTypeInfos()) {
                    if (unionFormattedType.length() != 0) {
                        unionFormattedType.append(", ");
                    }
                    String unionElementType = this.formatType(unionElementTypeInfo);
                    unionFormattedType.append(unionElementType);
                }
                return "uniontype<" + unionFormattedType.toString() + ">";
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)typeInfo.getCategory()));
    }

    private String getComment(Table table) {
        String comment = table.getProperty(COMMENT);
        return comment != null ? "COMMENT '" + HiveStringUtils.escapeHiveCommand(comment) + "'" : "";
    }

    private String getPartitions(Table table) {
        List<FieldSchema> partitionKeys = table.getPartitionKeys();
        if (partitionKeys.isEmpty()) {
            return "";
        }
        ArrayList<String> partitionDescs = new ArrayList<String>();
        for (FieldSchema partitionKey : partitionKeys) {
            String partitionDesc = "  `" + partitionKey.getName() + "` " + partitionKey.getType();
            if (partitionKey.getComment() != null) {
                partitionDesc = partitionDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(partitionKey.getComment()) + "'";
            }
            partitionDescs.add(partitionDesc);
        }
        return "PARTITIONED BY ( \n" + StringUtils.join(partitionDescs, ", \n") + ")";
    }

    private String getBuckets(Table table) {
        List<String> bucketCols = table.getBucketCols();
        if (bucketCols.isEmpty()) {
            return "";
        }
        String buckets = "CLUSTERED BY ( \n  " + StringUtils.join(bucketCols, ", \n  ") + ") \n";
        List<Order> sortColumns = table.getSortCols();
        if (!sortColumns.isEmpty()) {
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (Order sortColumn : sortColumns) {
                String sortKeyDesc = "  " + sortColumn.getCol() + " " + DirectionUtils.codeToText(sortColumn.getOrder());
                sortKeys.add(sortKeyDesc);
            }
            buckets = buckets + "SORTED BY ( \n" + StringUtils.join(sortKeys, ", \n") + ") \n";
        }
        buckets = buckets + "INTO " + table.getNumBuckets() + " BUCKETS";
        return buckets;
    }

    private String getSkewed(Table table) {
        SkewedInfo skewedInfo = table.getSkewedInfo();
        if (skewedInfo == null || skewedInfo.getSkewedColNames().isEmpty()) {
            return "";
        }
        ArrayList<String> columnValuesList = new ArrayList<String>();
        for (List<String> columnValues : skewedInfo.getSkewedColValues()) {
            columnValuesList.add("('" + StringUtils.join(columnValues, "','") + "')");
        }
        String skewed = "SKEWED BY (" + StringUtils.join(skewedInfo.getSkewedColNames(), ",") + ")\n" + "  ON (" + StringUtils.join(columnValuesList, ",") + ")";
        if (table.isStoredAsSubDirectories()) {
            skewed = skewed + "\n  STORED AS DIRECTORIES";
        }
        return skewed;
    }

    private String getRowFormat(Table table) {
        StringBuilder rowFormat = new StringBuilder();
        StorageDescriptor sd = table.getTTable().getSd();
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        rowFormat.append("ROW FORMAT SERDE \n").append("  '" + HiveStringUtils.escapeHiveCommand(serdeInfo.getSerializationLib()) + "' \n");
        Map<String, String> serdeParams = serdeInfo.getParameters();
        if (table.getStorageHandler() == null) {
            if ("1".equals(serdeParams.get("serialization.format"))) {
                serdeParams.remove("serialization.format");
            }
            if (!serdeParams.isEmpty()) {
                ShowCreateTableOperation.appendSerdeParams(rowFormat, serdeParams);
                rowFormat.append(" \n");
            }
            rowFormat.append("STORED AS INPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(sd.getInputFormat()) + "' \n").append("OUTPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(sd.getOutputFormat()) + "'");
        } else {
            String metaTableStorage = table.getParameters().get("storage_handler");
            rowFormat.append("STORED BY \n  '" + HiveStringUtils.escapeHiveCommand(metaTableStorage) + "' \n");
            if (!serdeParams.isEmpty()) {
                ShowCreateTableOperation.appendSerdeParams(rowFormat, serdeInfo.getParameters());
            }
        }
        return rowFormat.toString();
    }

    public static void appendSerdeParams(StringBuilder builder, Map<String, String> serdeParams) {
        TreeMap<String, String> sortedSerdeParams = new TreeMap<String, String>(serdeParams);
        ArrayList<String> serdeCols = new ArrayList<String>();
        for (Map.Entry entry : sortedSerdeParams.entrySet()) {
            serdeCols.add("  '" + (String)entry.getKey() + "'='" + HiveStringUtils.escapeHiveCommand((String)entry.getValue()) + "'");
        }
        builder.append("WITH SERDEPROPERTIES ( \n").append(StringUtils.join(serdeCols, ", \n")).append(')');
    }

    private String getLocationBlock(Table table) {
        if (!CreateTableOperation.doesTableNeedLocation(table)) {
            return "";
        }
        ST locationBlock = new ST(CREATE_TABLE_TEMPLATE_LOCATION);
        StorageDescriptor sd = table.getTTable().getSd();
        locationBlock.add(LOCATION, (Object)("  '" + HiveStringUtils.escapeHiveCommand(sd.getLocation()) + "'"));
        return locationBlock.render();
    }

    private String getProperties(Table table) {
        return DDLUtils.propertiesToString(table.getParameters(), PROPERTIES_TO_IGNORE_AT_TBLPROPERTIES);
    }
}

