/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.desc;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Describe Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DescTableDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "col_name,data_type,comment#string:string:string";
    public static final String COLUMN_STATISTICS_SCHEMA = "column_property,value#string:string";
    public static final List<String> COLUMN_STATISTICS_HEADERS = ImmutableList.of("col_name", "data_type", "min", "max", "num_nulls", "distinct_count", "avg_col_len", "max_col_len", "num_trues", "num_falses", "bit_vector", "comment", new String[0]);
    private final String resFile;
    private final TableName tableName;
    private final Map<String, String> partitionSpec;
    private final String columnPath;
    private final boolean isExtended;
    private final boolean isFormatted;

    public DescTableDesc(Path resFile, TableName tableName, Map<String, String> partitionSpec, String columnPath, boolean isExtended, boolean isFormatted) {
        this.resFile = resFile.toString();
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.columnPath = columnPath;
        this.isExtended = isExtended;
        this.isFormatted = isFormatted;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public String getColumnPath() {
        return this.columnPath;
    }

    @Explain(displayName="extended", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isExtended() {
        return this.isExtended;
    }

    @Explain(displayName="formatted", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isFormatted() {
        return this.isFormatted;
    }
}

