/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.truncate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractBaseAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.misc.truncate.TruncateTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.InputFormat;

@DDLSemanticAnalyzerFactory.DDLType(types={1139})
public class TruncateTableAnalyzer
extends AbstractBaseAlterTableAnalyzer {
    public TruncateTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        ASTNode tableNode = (ASTNode)root.getChild(0);
        String tableNameString = TruncateTableAnalyzer.getUnescapedName((ASTNode)tableNode.getChild(0));
        Table table = this.getTable(tableNameString, true);
        TableName tableName = HiveTableName.of(table);
        this.checkTruncateEligibility(root, tableNode, tableNameString, table);
        Map<String, String> partitionSpec = TruncateTableAnalyzer.getPartSpec((ASTNode)tableNode.getChild(1));
        this.addTruncateTableOutputs(tableNode, table, partitionSpec);
        Task<?> truncateTask = null;
        ASTNode colNamesNode = (ASTNode)root.getFirstChildWithType(1097);
        truncateTask = colNamesNode == null ? this.getTruncateTaskWithoutColumnNames(tableName, partitionSpec, table) : this.getTruncateTaskWithColumnNames(tableNode, tableName, table, partitionSpec, colNamesNode);
        this.rootTasks.add(truncateTask);
    }

    private void checkTruncateEligibility(ASTNode ast, ASTNode root, String tableName, Table table) throws SemanticException {
        boolean isForce;
        boolean bl = isForce = ast.getFirstChildWithType(894) != null;
        if (!isForce && table.getTableType() != TableType.MANAGED_TABLE && table.getParameters().getOrDefault("external.table.purge", "FALSE").equalsIgnoreCase("FALSE")) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_MANAGED_TABLE.format(tableName));
        }
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_NATIVE_TABLE.format(tableName));
        }
        if (!table.isPartitioned() && root.getChildCount() > 1) {
            throw new SemanticException(ErrorMsg.PARTSPEC_FOR_NON_PARTITIONED_TABLE.format(tableName));
        }
    }

    private void addTruncateTableOutputs(ASTNode root, Table table, Map<String, String> partitionSpec) throws SemanticException {
        if (partitionSpec == null) {
            if (!table.isPartitioned()) {
                this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
            } else {
                for (Partition partition : PartitionUtils.getPartitions(this.db, table, null, false)) {
                    this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        } else if (AlterTableUtils.isFullPartitionSpec(table, partitionSpec)) {
            TruncateTableAnalyzer.validatePartSpec(table, partitionSpec, (ASTNode)root.getChild(1), this.conf, true);
            Partition partition = PartitionUtils.getPartition(this.db, table, partitionSpec, true);
            this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
        } else {
            TruncateTableAnalyzer.validatePartSpec(table, partitionSpec, (ASTNode)root.getChild(1), this.conf, false);
            for (Partition partition : PartitionUtils.getPartitions(this.db, table, partitionSpec, false)) {
                this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
            }
        }
    }

    private Task<?> getTruncateTaskWithoutColumnNames(TableName tableName, Map<String, String> partitionSpec, Table table) {
        TruncateTableDesc desc = new TruncateTableDesc(tableName, partitionSpec, null, table);
        if (desc.mayNeedWriteId()) {
            this.setAcidDdlDesc(desc);
        }
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        return TaskFactory.get(ddlWork);
    }

    private Task<?> getTruncateTaskWithColumnNames(ASTNode root, TableName tableName, Table table, Map<String, String> partitionSpec, ASTNode columnNamesNode) throws SemanticException {
        try {
            if (AcidUtils.isInsertOnlyTable(table.getParameters())) {
                throw new SemanticException("Truncating MM table columns not presently supported");
            }
            List<String> columnNames = TruncateTableAnalyzer.getColumnNames(columnNamesNode);
            if (table.isPartitioned()) {
                return this.truncatePartitionedTableWithColumnNames(root, tableName, table, partitionSpec, columnNames);
            }
            return this.truncateUnpartitionedTableWithColumnNames(root, tableName, table, partitionSpec, columnNames);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
    }

    private Task<?> truncatePartitionedTableWithColumnNames(ASTNode root, TableName tableName, Table table, Map<String, String> partitionSpec, List<String> columnNames) throws HiveException, SemanticException {
        Path partitionPath;
        Partition partition = this.db.getPartition(table, partitionSpec, false);
        Path tablePath = table.getPath();
        Path oldPartitionLocation = partitionPath = partition.getDataLocation();
        Path newPartitionLocation = new Path(tablePath.toUri().getScheme(), tablePath.toUri().getAuthority(), partitionPath.toUri().getPath());
        List<FieldSchema> columns = partition.getCols();
        List<String> bucketColumns = partition.getBucketCols();
        List<String> listBucketColumns = partition.getSkewedColNames();
        Class<? extends InputFormat> inputFormatClass = partition.getInputFormatClass();
        boolean isArchived = ArchiveUtils.isArchived(partition);
        ListBucketingCtx lbCtx = this.constructListBucketingCtx(partition.getSkewedColNames(), partition.getSkewedColValues(), partition.getSkewedColValueLocationMaps(), partition.isStoredAsSubDirectories());
        boolean isListBucketed = partition.isStoredAsSubDirectories();
        return this.createTasks(root, tableName, table, partitionSpec, columnNames, bucketColumns, inputFormatClass, isArchived, newPartitionLocation, oldPartitionLocation, columns, lbCtx, isListBucketed, listBucketColumns);
    }

    private Task<?> truncateUnpartitionedTableWithColumnNames(ASTNode root, TableName tableName, Table table, Map<String, String> partitionSpec, List<String> columnNames) throws SemanticException {
        Path oldPartitionLocation = table.getPath();
        Path newPartitionLocation = table.getPath();
        List<FieldSchema> columns = table.getCols();
        List<String> bucketColumns = table.getBucketCols();
        List<String> listBucketColumns = table.getSkewedColNames();
        Class<? extends InputFormat> inputFormatClass = table.getInputFormatClass();
        ListBucketingCtx lbCtx = this.constructListBucketingCtx(table.getSkewedColNames(), table.getSkewedColValues(), table.getSkewedColValueLocationMaps(), table.isStoredAsSubDirectories());
        boolean isListBucketed = table.isStoredAsSubDirectories();
        return this.createTasks(root, tableName, table, partitionSpec, columnNames, bucketColumns, inputFormatClass, false, newPartitionLocation, oldPartitionLocation, columns, lbCtx, isListBucketed, listBucketColumns);
    }

    private Task<?> createTasks(ASTNode root, TableName tableName, Table table, Map<String, String> partitionSpec, List<String> columnNames, List<String> bucketColumns, Class<? extends InputFormat> inputFormatClass, boolean isArchived, Path newPartitionLocation, Path oldPartitionLocation, List<FieldSchema> columns, ListBucketingCtx lbCtx, boolean isListBucketed, List<String> listBucketColumns) throws SemanticException {
        if (!inputFormatClass.equals(RCFileInputFormat.class)) {
            throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_NOT_RC.getMsg());
        }
        if (isArchived) {
            throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_ARCHIVED.getMsg());
        }
        Set<Integer> columnIndexes = this.getColumnIndexes(columnNames, bucketColumns, columns, isListBucketed, listBucketColumns);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, null, AlterTableType.TRUNCATE, false);
        TableDesc tableDesc = Utilities.getTableDesc(table);
        Path queryTmpdir = this.ctx.getExternalTmpPath(newPartitionLocation);
        Task<?> truncateTask = this.createTruncateTask(tableName, table, partitionSpec, oldPartitionLocation, lbCtx, columnIndexes, queryTmpdir);
        this.addMoveTask(root, table, partitionSpec, oldPartitionLocation, newPartitionLocation, lbCtx, queryTmpdir, truncateTask, tableDesc);
        return truncateTask;
    }

    private Set<Integer> getColumnIndexes(List<String> columnNames, List<String> bucketColumns, List<FieldSchema> columns, boolean isListBucketed, List<String> listBucketColumns) throws SemanticException {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        for (String columnName : columnNames) {
            boolean found = false;
            for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
                if (!columnName.equalsIgnoreCase(columns.get(columnIndex).getName())) continue;
                columnIndexes.add(columnIndex);
                found = true;
                break;
            }
            if (!found) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(columnName));
            }
            for (String bucketColumn : bucketColumns) {
                if (!bucketColumn.equalsIgnoreCase(columnName)) continue;
                throw new SemanticException(ErrorMsg.TRUNCATE_BUCKETED_COLUMN.getMsg(columnName));
            }
            if (!isListBucketed) continue;
            for (String listBucketColumn : listBucketColumns) {
                if (!listBucketColumn.equalsIgnoreCase(columnName)) continue;
                throw new SemanticException(ErrorMsg.TRUNCATE_LIST_BUCKETED_COLUMN.getMsg(columnName));
            }
        }
        return columnIndexes;
    }

    private Task<?> createTruncateTask(TableName tableName, Table table, Map<String, String> partitionSpec, Path oldPartitionLocation, ListBucketingCtx lbCtx, Set<Integer> columnIndexes, Path queryTmpdir) {
        TruncateTableDesc desc = new TruncateTableDesc(tableName, partitionSpec, null, table, new ArrayList<Integer>(columnIndexes), oldPartitionLocation, queryTmpdir, lbCtx);
        if (desc.mayNeedWriteId()) {
            this.setAcidDdlDesc(desc);
        }
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        ddlWork.setNeedLock(true);
        return TaskFactory.get(ddlWork);
    }

    private void addMoveTask(ASTNode root, Table table, Map<String, String> partitionSpec, Path oldPartitionLocation, Path newPartitionLocation, ListBucketingCtx lbCtx, Path queryTmpdir, Task<?> truncateTask, TableDesc tableDesc) throws SemanticException {
        LoadTableDesc loadTableDesc = new LoadTableDesc(queryTmpdir, tableDesc, partitionSpec == null ? new HashMap() : partitionSpec);
        loadTableDesc.setLbCtx(lbCtx);
        Task<MoveWork> moveTask = TaskFactory.get(new MoveWork(null, null, loadTableDesc, null, false));
        truncateTask.addDependentTask(moveTask);
        this.addStatTask(root, table, oldPartitionLocation, newPartitionLocation, loadTableDesc, moveTask);
    }

    private void addStatTask(ASTNode root, Table table, Path oldPartitionLocation, Path newPartitionLocation, LoadTableDesc loadTableDesc, Task<MoveWork> moveTask) throws SemanticException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            BasicStatsWork basicStatsWork;
            if (oldPartitionLocation.equals((Object)newPartitionLocation)) {
                BaseSemanticAnalyzer.TableSpec partitionSpec = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, root);
                basicStatsWork = new BasicStatsWork(partitionSpec);
            } else {
                basicStatsWork = new BasicStatsWork(loadTableDesc);
            }
            basicStatsWork.setNoStatsAggregator(true);
            basicStatsWork.setClearAggregatorStats(true);
            StatsWork columnStatsWork = new StatsWork(table, basicStatsWork, this.conf);
            Task<StatsWork> statTask = TaskFactory.get(columnStatsWork);
            moveTask.addDependentTask(statTask);
        }
    }
}

