/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AbstractAddPartitionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;

@DDLSemanticAnalyzerFactory.DDLType(types={760})
public class AlterTableAddPartitionAnalyzer
extends AbstractAddPartitionAnalyzer {
    public AlterTableAddPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected boolean expectView() {
        return false;
    }

    @Override
    protected boolean allowLocation() {
        return true;
    }

    @Override
    protected void postProcess(TableName tableName, Table table, AlterTableAddPartitionDesc desc, Task<DDLWork> ddlTask) throws SemanticException {
        if (!AcidUtils.isTransactionalTable(table)) {
            return;
        }
        Long writeId = null;
        int stmtId = 0;
        for (int i = 0; i < desc.getPartitionCount(); ++i) {
            Partition oldPart;
            AlterTableAddPartitionDesc.PartitionDesc partitionDesc = desc.getPartition(i);
            if (partitionDesc.getLocation() == null) continue;
            AcidUtils.validateAcidPartitionLocation(partitionDesc.getLocation(), this.conf);
            if (desc.isIfNotExists() && (oldPart = PartitionUtils.getPartition(this.db, table, partitionDesc.getPartSpec(), false)) != null) continue;
            if (writeId == null) {
                try {
                    writeId = this.getTxnMgr().getTableWriteId(table.getDbName(), table.getTableName());
                }
                catch (LockException ex) {
                    throw new SemanticException("Failed to allocate the write id", ex);
                }
                stmtId = this.getTxnMgr().getStmtIdAndIncrement();
            }
            LoadTableDesc loadTableWork = new LoadTableDesc(new Path(partitionDesc.getLocation()), Utilities.getTableDesc(table), partitionDesc.getPartSpec(), LoadTableDesc.LoadFileType.KEEP_EXISTING, writeId);
            loadTableWork.setStmtId(stmtId);
            loadTableWork.setInheritTableSpecs(true);
            try {
                partitionDesc.setLocation(new Path(table.getDataLocation(), Warehouse.makePartPath(partitionDesc.getPartSpec())).toString());
            }
            catch (MetaException ex) {
                throw new SemanticException("Could not determine partition path due to: " + ex.getMessage(), ex);
            }
            Task<MoveWork> moveTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true, false));
            ddlTask.addDependentTask(moveTask);
        }
    }
}

