/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.drop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

abstract class AbstractDropPartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    AbstractDropPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        boolean ifExists;
        boolean canGroupExprs = ifExists = command.getFirstChildWithType(911) != null || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        boolean mustPurge = command.getFirstChildWithType(252) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(command);
        Table table = null;
        try {
            table = this.getTable(tableName);
        }
        catch (SemanticException se) {
            if (replicationSpec.isInReplicationScope() && (se.getCause() instanceof InvalidTableException || se.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg()))) {
                return;
            }
            throw se;
        }
        Map<Integer, List<ExprNodeGenericFuncDesc>> partitionSpecs = this.getFullPartitionSpecs(command, table, canGroupExprs);
        if (partitionSpecs.isEmpty()) {
            return;
        }
        this.validateAlterTableType(table, AlterTableType.DROPPARTITION, this.expectView());
        ReadEntity re = new ReadEntity(table);
        re.noLockNeeded();
        this.inputs.add(re);
        this.addTableDropPartsOutputs(table, partitionSpecs.values(), !ifExists);
        AlterTableDropPartitionDesc desc = new AlterTableDropPartitionDesc(tableName, partitionSpecs, mustPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private Map<Integer, List<ExprNodeGenericFuncDesc>> getFullPartitionSpecs(CommonTree ast, Table table, boolean canGroupExprs) throws SemanticException {
        String defaultPartitionName = HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        HashMap<String, String> colTypes = new HashMap<String, String>();
        for (FieldSchema fs : table.getPartitionKeys()) {
            colTypes.put(fs.getName().toLowerCase(), fs.getType());
        }
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> result = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partSpecTree = ast.getChild(childIndex);
            if (partSpecTree.getType() != 989) continue;
            ExprNodeGenericFuncDesc expr = null;
            HashSet<String> names = new HashSet<String>(partSpecTree.getChildCount());
            for (int i = 0; i < partSpecTree.getChildCount(); ++i) {
                ExprNodeGenericFuncDesc op;
                CommonTree partSpecSingleKey = (CommonTree)partSpecTree.getChild(i);
                assert (partSpecSingleKey.getType() == 990);
                String key = AbstractDropPartitionAnalyzer.stripIdentifierQuotes(partSpecSingleKey.getChild(0).getText()).toLowerCase();
                String operator = partSpecSingleKey.getChild(1).getText();
                ASTNode partValNode = (ASTNode)partSpecSingleKey.getChild(2);
                TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
                ExprNodeConstantDesc valExpr = (ExprNodeConstantDesc)TypeCheckProcFactory.genExprNode(partValNode, typeCheckCtx).get(partValNode);
                Object val = valExpr.getValue();
                boolean isDefaultPartitionName = val.equals(defaultPartitionName);
                String type = (String)colTypes.get(key);
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo(type);
                if (type == null) {
                    throw new SemanticException("Column " + key + " not found");
                }
                if (!isDefaultPartitionName && !valExpr.getTypeString().equals(type)) {
                    ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(valExpr.getTypeInfo()), TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(pti));
                    val = converter.convert(valExpr.getValue());
                }
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pti, key, null, true);
                if (!isDefaultPartitionName) {
                    op = PartitionUtils.makeBinaryPredicate(operator, column, new ExprNodeConstantDesc(pti, val));
                } else {
                    String fnName;
                    GenericUDF originalOp = FunctionRegistry.getFunctionInfo(operator).getGenericUDF();
                    if (FunctionRegistry.isEq(originalOp)) {
                        fnName = "isnull";
                    } else if (FunctionRegistry.isNeq(originalOp)) {
                        fnName = "isnotnull";
                    } else {
                        throw new SemanticException("Cannot use " + operator + " in a default partition spec; only '=' and '!=' are allowed.");
                    }
                    op = PartitionUtils.makeUnaryPredicate(fnName, column);
                }
                expr = expr == null ? op : PartitionUtils.makeBinaryPredicate("and", expr, op);
                names.add(key);
            }
            if (expr == null) continue;
            int prefixLength = this.calculatePartPrefix(table, names);
            List orExpr = (List)result.get(prefixLength);
            if (orExpr == null) {
                result.put(prefixLength, Lists.newArrayList(expr));
                continue;
            }
            if (canGroupExprs) {
                orExpr.set(0, PartitionUtils.makeBinaryPredicate("or", expr, (ExprNodeDesc)orExpr.get(0)));
                continue;
            }
            orExpr.add(expr);
        }
        return result;
    }

    private int calculatePartPrefix(Table tbl, Set<String> partSpecKeys) {
        int partPrefixToDrop = 0;
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!partSpecKeys.contains(fs.getName())) break;
            ++partPrefixToDrop;
        }
        return partPrefixToDrop;
    }

    protected abstract boolean expectView();

    private void addTableDropPartsOutputs(Table tab, Collection<List<ExprNodeGenericFuncDesc>> partitionSpecs, boolean throwIfNonExistent) throws SemanticException {
        for (List<ExprNodeGenericFuncDesc> specs : partitionSpecs) {
            for (ExprNodeGenericFuncDesc partitionSpec : specs) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknown = false;
                try {
                    hasUnknown = this.db.getPartitionsByExpr(tab, partitionSpec, this.conf, parts);
                }
                catch (Exception e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.getExprString()), e);
                }
                if (hasUnknown) {
                    throw new SemanticException("Unexpected unknown partitions for " + partitionSpec.getExprString());
                }
                if (parts.isEmpty() && throwIfNonExistent) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.getExprString()));
                }
                for (Partition p : parts) {
                    this.outputs.add(new WriteEntity(p, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        }
    }
}

