/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.exchange;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.exchange.AlterTableExchangePartitionsDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={769})
public class AlterTableExchangePartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableExchangePartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table destTable = this.getTable(tableName);
        Table sourceTable = this.getTable(AlterTableExchangePartitionAnalyzer.getUnescapedName((ASTNode)command.getChild(1)));
        Map<String, String> partitionSpecs = AlterTableExchangePartitionAnalyzer.getValidatedPartSpec(sourceTable, (ASTNode)command.getChild(0), this.conf, false);
        PartitionUtils.validatePartitions(this.conf, partitionSpecs);
        boolean sameColumns = MetaStoreUtils.compareFieldColumns(destTable.getAllCols(), sourceTable.getAllCols());
        boolean samePartitions = MetaStoreUtils.compareFieldColumns(destTable.getPartitionKeys(), sourceTable.getPartitionKeys());
        if (!sameColumns || !samePartitions) {
            throw new SemanticException(ErrorMsg.TABLES_INCOMPATIBLE_SCHEMAS.getMsg());
        }
        if (AcidUtils.isTransactionalTable(sourceTable) || AcidUtils.isTransactionalTable(destTable)) {
            throw new SemanticException(ErrorMsg.EXCHANGE_PARTITION_NOT_ALLOWED_WITH_TRANSACTIONAL_TABLES.getMsg());
        }
        PartitionUtils.getPartitions(this.db, sourceTable, partitionSpecs, true);
        int counter = this.isPartitionValueContinuous(sourceTable.getPartitionKeys(), partitionSpecs);
        if (counter < 0) {
            throw new SemanticException(ErrorMsg.PARTITION_VALUE_NOT_CONTINUOUS.getMsg(partitionSpecs.toString()));
        }
        List<Partition> destPartitions = null;
        try {
            destPartitions = PartitionUtils.getPartitions(this.db, destTable, partitionSpecs, true);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        if (destPartitions != null) {
            throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(destPartitions.toString()));
        }
        AlterTableExchangePartitionsDesc desc = new AlterTableExchangePartitionsDesc(sourceTable, destTable, partitionSpecs);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.inputs.add(new ReadEntity(sourceTable));
        this.outputs.add(new WriteEntity(destTable, WriteEntity.WriteType.DDL_SHARED));
    }

    private int isPartitionValueContinuous(List<FieldSchema> partitionKeys, Map<String, String> partitionSpecs) {
        int counter = 0;
        for (FieldSchema partitionKey : partitionKeys) {
            if (partitionSpecs.containsKey(partitionKey.getName())) {
                ++counter;
                continue;
            }
            return partitionSpecs.size() == counter ? counter : -1;
        }
        return counter;
    }
}

