/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.cluster;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.storage.cluster.AlterTableIntoBucketsDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={762, 749})
public class AlterTableIntoBucketsAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableIntoBucketsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName, true);
        if (CollectionUtils.isEmpty(table.getBucketCols())) {
            throw new SemanticException(ErrorMsg.ALTER_BUCKETNUM_NONBUCKETIZED_TBL.getMsg());
        }
        this.validateAlterTableType(table, AlterTableType.INTO_BUCKETS, false);
        this.inputs.add(new ReadEntity(table));
        int numberOfBuckets = Integer.parseInt(command.getChild(0).getText());
        AlterTableIntoBucketsDesc desc = new AlterTableIntoBucketsDesc(tableName, partitionSpec, numberOfBuckets);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

