/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.concatenate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.storage.compact.AlterTableCompactDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.concatenate.AlterTableConcatenateDesc;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.InputFormat;

@DDLSemanticAnalyzerFactory.DDLType(types={772, 752})
public class AlterTableConcatenateAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableConcatenateAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        if (AcidUtils.isTransactionalTable(table)) {
            this.compactAcidTable(tableName, partitionSpec);
        } else {
            if (table.isNonNative()) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_NON_NATIVE.getMsg());
            }
            if (table.getTableType() != TableType.MANAGED_TABLE) {
                throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_NOT_MANAGED.getMsg());
            }
            if (table.isPartitioned()) {
                this.concatenatePartitionedTable(tableName, table, partitionSpec);
            } else {
                this.concatenateUnpartitionedTable(tableName, table, partitionSpec);
            }
        }
    }

    private void compactAcidTable(TableName tableName, Map<String, String> partitionSpec) {
        boolean isBlocking = !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, false);
        AlterTableCompactDesc desc = new AlterTableCompactDesc(tableName, partitionSpec, "MAJOR", isBlocking, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private void concatenatePartitionedTable(TableName tableName, Table table, Map<String, String> partitionSpec) throws SemanticException {
        Path partitionPath;
        if (partitionSpec == null) {
            throw new SemanticException("source table " + tableName + " is partitioned but no partition desc found.");
        }
        Partition part = PartitionUtils.getPartition(this.db, table, partitionSpec, false);
        if (part == null) {
            throw new SemanticException("source table " + tableName + " is partitioned but partition not found.");
        }
        if (ArchiveUtils.isArchived(part)) {
            throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_PARTITION_ARCHIVED.getMsg());
        }
        Path tablePath = table.getPath();
        Path oldLocation = partitionPath = part.getDataLocation();
        Path newLocation = new Path(tablePath.toUri().getScheme(), tablePath.toUri().getAuthority(), partitionPath.toUri().getPath());
        ListBucketingCtx lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories());
        List<String> bucketCols = part.getBucketCols();
        Class<? extends InputFormat> inputFormatClass = null;
        try {
            inputFormatClass = part.getInputFormatClass();
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        this.createConcatenateTasks(tableName, table, partitionSpec, oldLocation, newLocation, lbCtx, bucketCols, inputFormatClass);
    }

    private void concatenateUnpartitionedTable(TableName tableName, Table table, Map<String, String> partitionSpec) throws SemanticException {
        Path oldLocation = table.getPath();
        Path newLocation = table.getPath();
        ListBucketingCtx lbCtx = this.constructListBucketingCtx(table.getSkewedColNames(), table.getSkewedColValues(), table.getSkewedColValueLocationMaps(), table.isStoredAsSubDirectories());
        List<String> bucketCols = table.getBucketCols();
        Class<? extends InputFormat> inputFormatClass = table.getInputFormatClass();
        this.createConcatenateTasks(tableName, table, partitionSpec, oldLocation, newLocation, lbCtx, bucketCols, inputFormatClass);
    }

    private void createConcatenateTasks(TableName tableName, Table table, Map<String, String> partitionSpec, Path oldLocation, Path newLocation, ListBucketingCtx lbCtx, List<String> bucketCols, Class<? extends InputFormat> inputFormatClass) throws SemanticException {
        if (!inputFormatClass.equals(RCFileInputFormat.class) && !inputFormatClass.equals(OrcInputFormat.class)) {
            throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_FILE_FORMAT.getMsg());
        }
        if (bucketCols != null && bucketCols.size() > 0) {
            throw new SemanticException(ErrorMsg.CONCATENATE_UNSUPPORTED_TABLE_BUCKETED.getMsg());
        }
        this.addInputsOutputsAlterTable(tableName, partitionSpec, null, AlterTableType.MERGEFILES, false);
        TableDesc tableDesc = Utilities.getTableDesc(table);
        Path queryTmpDir = this.ctx.getExternalTmpPath(newLocation);
        Task<?> mergeTask = this.createMergeTask(tableName, table, partitionSpec, oldLocation, lbCtx, inputFormatClass, queryTmpDir);
        this.addMoveTask(tableName, table, partitionSpec, oldLocation, newLocation, lbCtx, tableDesc, queryTmpDir, mergeTask);
        this.rootTasks.add(mergeTask);
    }

    private Task<?> createMergeTask(TableName tableName, Table table, Map<String, String> partitionSpec, Path oldLocation, ListBucketingCtx lbCtx, Class<? extends InputFormat> inputFormatClass, Path queryTmpDir) {
        AlterTableConcatenateDesc desc = new AlterTableConcatenateDesc(tableName, partitionSpec, lbCtx, oldLocation, queryTmpDir, inputFormatClass, Utilities.getTableDesc(table));
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        ddlWork.setNeedLock(true);
        return TaskFactory.get(ddlWork);
    }

    private void addMoveTask(TableName tableName, Table table, Map<String, String> partitionSpec, Path oldLocation, Path newLocation, ListBucketingCtx lbCtx, TableDesc tableDesc, Path queryTmpDir, Task<?> mergeTask) throws SemanticException {
        LoadTableDesc loadTableDesc = new LoadTableDesc(queryTmpDir, tableDesc, (Map<String, String>)(partitionSpec == null ? new HashMap<String, String>() : partitionSpec));
        loadTableDesc.setLbCtx(lbCtx);
        loadTableDesc.setInheritTableSpecs(true);
        Task<MoveWork> moveTask = TaskFactory.get(new MoveWork(null, null, loadTableDesc, null, false));
        mergeTask.addDependentTask(moveTask);
        this.addStatTask(tableName, table, partitionSpec, oldLocation, newLocation, loadTableDesc, moveTask);
    }

    private void addStatTask(TableName tableName, Table table, Map<String, String> partitionSpec, Path oldLocation, Path newLocation, LoadTableDesc loadTableDesc, Task<MoveWork> moveTask) throws SemanticException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            BasicStatsWork basicStatsWork;
            if (oldLocation.equals((Object)newLocation)) {
                try {
                    BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec(this.db, tableName, partitionSpec);
                    basicStatsWork = new BasicStatsWork(tableSpec);
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
            } else {
                basicStatsWork = new BasicStatsWork(loadTableDesc);
            }
            basicStatsWork.setNoStatsAggregator(true);
            basicStatsWork.setClearAggregatorStats(true);
            StatsWork statsWork = new StatsWork(table, basicStatsWork, this.conf);
            Task<StatsWork> statTask = TaskFactory.get(statsWork);
            moveTask.addDependentTask(statTask);
        }
    }
}

