/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.AlterTableSetSkewedLocationDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.SkewedTableUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={783})
public class AlterTableSetSkewedLocationAnalyzer
extends AbstractAlterTableAnalyzer {
    private static final Set<Integer> CONSTANT_TYPES = Sets.newHashSet(382, 394, 25, 383, 12, 333, 135);

    public AlterTableSetSkewedLocationAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        List<Node> locationNodes = command.getChildren();
        if (locationNodes == null) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
        }
        HashMap<List<String>, String> locations = new HashMap<List<String>, String>();
        for (Node locationNode : locationNodes) {
            List<Node> locationListNodes = ((ASTNode)locationNode).getChildren();
            if (locationListNodes == null) {
                throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
            }
            for (Node locationListNode : locationListNodes) {
                List<Node> locationMapNodes = ((ASTNode)locationListNode).getChildren();
                if (locationMapNodes == null) {
                    throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
                }
                for (Node locationMapNode : locationMapNodes) {
                    List<Node> locationMapNodeMaps = ((ASTNode)locationMapNode).getChildren();
                    if (locationMapNodeMaps == null || locationMapNodeMaps.size() != 2) {
                        throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_MAP.getMsg());
                    }
                    List<Object> keyList = new LinkedList();
                    ASTNode node = (ASTNode)locationMapNodeMaps.get(0);
                    if (node.getToken().getType() == 1099) {
                        keyList = SkewedTableUtils.getSkewedValuesFromASTNode(node);
                    } else if (this.isConstant(node)) {
                        keyList.add(PlanUtils.stripQuotes(node.getText()));
                    } else {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    String newLocation = PlanUtils.stripQuotes(AlterTableSetSkewedLocationAnalyzer.unescapeSQLString(((ASTNode)locationMapNodeMaps.get(1)).getText()));
                    this.validateSkewedLocationString(newLocation);
                    locations.put(keyList, newLocation);
                    this.outputs.add(this.toWriteEntity(newLocation));
                }
            }
        }
        AlterTableSetSkewedLocationDesc desc = new AlterTableSetSkewedLocationDesc(tableName, partitionSpec, locations);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, AlterTableType.SET_SKEWED_LOCATION, false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private boolean isConstant(ASTNode node) {
        return CONSTANT_TYPES.contains(node.getToken().getType());
    }

    private void validateSkewedLocationString(String location) throws SemanticException {
        try {
            URI locationUri = new URI(location);
            if (!locationUri.isAbsolute() || locationUri.getScheme() == null || locationUri.getScheme().trim().equals("")) {
                throw new SemanticException(location + " is not absolute or has no scheme information. " + "Please specify a complete absolute uri with scheme information.");
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticException(e);
        }
    }
}

