/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.drop;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.drop.DropViewDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={872})
public class DropViewAnalyzer
extends BaseSemanticAnalyzer {
    public DropViewAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean ifExists;
        boolean throwException;
        String viewName = DropViewAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table view = this.getTable(viewName, throwException = !(ifExists = root.getFirstChildWithType(911) != null) && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT));
        if (view != null) {
            this.inputs.add(new ReadEntity(view));
            this.outputs.add(new WriteEntity(view, WriteEntity.WriteType.DDL_EXCLUSIVE));
        }
        DropViewDesc desc = new DropViewDesc(viewName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

