/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.show;

import java.io.DataOutputStream;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.show.ShowViewsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ShowViewsOperation
extends DDLOperation<ShowViewsDesc> {
    public ShowViewsOperation(DDLOperationContext context, ShowViewsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dbName = ((ShowViewsDesc)this.desc).getDbName();
        String pattern = ((ShowViewsDesc)this.desc).getPattern();
        String resultsFile = ((ShowViewsDesc)this.desc).getResFile();
        if (!this.context.getDb().databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        List<String> tableNames = this.context.getDb().getTablesByType(dbName, pattern, TableType.VIRTUAL_VIEW);
        LOG.debug("Found {} view(s) matching the SHOW VIEWS statement.", (Object)tableNames.size());
        try (DataOutputStream os = DDLUtils.getOutputStream(new Path(resultsFile), this.context);){
            TreeSet<String> sortedSet = new TreeSet<String>(tableNames);
            this.context.getFormatter().showTables(os, sortedSet);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
        }
        return 0;
    }
}

