/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.mapping;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public abstract class AbstractVMMappingAnalyzer
extends BaseSemanticAnalyzer {
    public AbstractVMMappingAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() < 4 || root.getChildCount() > 5) {
            throw new SemanticException("Invalid syntax for create or alter mapping.");
        }
        String resourcePlanName = AbstractVMMappingAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String entityType = root.getChild(1).getText();
        String entityName = PlanUtils.stripQuotes(root.getChild(2).getText());
        String poolPath = root.getChild(3).getType() == 1150 ? null : WMUtils.poolPath(root.getChild(3));
        Integer ordering = root.getChildCount() == 5 ? Integer.valueOf(root.getChild(4).getText()) : null;
        DDLDesc desc = this.getDesc(resourcePlanName, entityType, entityName, poolPath, ordering);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }

    protected abstract DDLDesc getDesc(String var1, String var2, String var3, String var4, Integer var5);
}

