/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.replace;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.replace.AlterResourcePlanReplaceDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={805})
public class AlterResourcePlanReplaceAnalyzer
extends BaseSemanticAnalyzer {
    public AlterResourcePlanReplaceAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() < 1 || root.getChildCount() > 2) {
            throw new SemanticException("Incorrect syntax");
        }
        String resourcePlanName = AlterResourcePlanReplaceAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String destinationResourcePlan = root.getChildCount() == 2 ? AlterResourcePlanReplaceAnalyzer.unescapeIdentifier(root.getChild(1).getText()) : null;
        AlterResourcePlanReplaceDesc desc = new AlterResourcePlanReplaceDesc(resourcePlanName, destinationResourcePlan);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

